/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal.request;

import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.http.crt.internal.request.CrtRequestBodySubscriber;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
final class CrtRequestBodyAdapter
implements HttpRequestBodyStream {
    private final int windowSize;
    private final CrtRequestBodySubscriber requestBodySubscriber;

    CrtRequestBodyAdapter(SdkHttpContentPublisher requestPublisher, int windowSize) {
        this.windowSize = Validate.isPositive((int)windowSize, (String)"windowSize is <= 0");
        this.requestBodySubscriber = new CrtRequestBodySubscriber(windowSize);
        requestPublisher.subscribe((Subscriber)this.requestBodySubscriber);
    }

    public boolean sendRequestBody(ByteBuffer bodyBytesOut) {
        return this.requestBodySubscriber.transferRequestBody(bodyBytesOut);
    }
}

