/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkPreviewApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@SdkPreviewApi
public final class ConnectionHealthChecksConfiguration {
    private final long minThroughputInBytesPerSecond;
    private final Duration allowableThroughputFailureInterval;

    private ConnectionHealthChecksConfiguration(DefaultConnectionHealthChecksConfigurationBuilder builder) {
        this.minThroughputInBytesPerSecond = (Long)Validate.paramNotNull((Object)builder.minThroughputInBytesPerSecond, (String)"minThroughputInBytesPerSecond");
        this.allowableThroughputFailureInterval = Validate.isPositive((Duration)builder.allowableThroughputFailureIntervalSeconds, (String)"allowableThroughputFailureIntervalSeconds");
    }

    public long minThroughputInBytesPerSecond() {
        return this.minThroughputInBytesPerSecond;
    }

    public Duration allowableThroughputFailureInterval() {
        return this.allowableThroughputFailureInterval;
    }

    public static Builder builder() {
        return new DefaultConnectionHealthChecksConfigurationBuilder();
    }

    private static final class DefaultConnectionHealthChecksConfigurationBuilder
    implements Builder {
        private Long minThroughputInBytesPerSecond;
        private Duration allowableThroughputFailureIntervalSeconds;

        private DefaultConnectionHealthChecksConfigurationBuilder() {
        }

        @Override
        public Builder minThroughputInBytesPerSecond(Long minThroughputInBytesPerSecond) {
            this.minThroughputInBytesPerSecond = minThroughputInBytesPerSecond;
            return this;
        }

        @Override
        public Builder allowableThroughputFailureInterval(Duration allowableThroughputFailureIntervalSeconds) {
            this.allowableThroughputFailureIntervalSeconds = allowableThroughputFailureIntervalSeconds;
            return this;
        }

        @Override
        public ConnectionHealthChecksConfiguration build() {
            return new ConnectionHealthChecksConfiguration(this);
        }
    }

    public static interface Builder {
        public Builder minThroughputInBytesPerSecond(Long var1);

        public Builder allowableThroughputFailureInterval(Duration var1);

        public ConnectionHealthChecksConfiguration build();
    }
}

