/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.client.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsAdvancedClientOption;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptorChain;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Validate;
import software.amazon.eventstream.HeaderValue;
import software.amazon.eventstream.Message;

@SdkProtectedApi
public final class AwsClientHandlerUtils {
    private AwsClientHandlerUtils() {
    }

    static <InputT extends SdkRequest, OutputT extends SdkResponse> ExecutionContext createExecutionContext(ClientExecutionParams<InputT, OutputT> executionParams, SdkClientConfiguration clientConfig, ExecutionAttributes executionAttributes) {
        SdkRequest originalRequest = executionParams.getInput();
        AwsCredentialsProvider clientCredentials = (AwsCredentialsProvider)clientConfig.option(AwsClientOption.CREDENTIALS_PROVIDER);
        AwsCredentialsProvider credentialsProvider = originalRequest.overrideConfiguration().filter(c -> c instanceof AwsRequestOverrideConfiguration).map(c -> (AwsRequestOverrideConfiguration)((Object)c)).flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElse(clientCredentials);
        long credentialsResolveStart = System.nanoTime();
        AwsCredentials credentials = credentialsProvider.resolveCredentials();
        Duration fetchDuration = Duration.ofNanos(System.nanoTime() - credentialsResolveStart);
        MetricCollector metricCollector = AwsClientHandlerUtils.resolveMetricCollector(executionParams);
        metricCollector.reportMetric(CoreMetric.CREDENTIALS_FETCH_DURATION, (Object)fetchDuration);
        Validate.validState((credentials != null ? 1 : 0) != 0, (String)"Credential providers must never return null.", (Object[])new Object[0]);
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG, clientConfig.option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION)).putAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS, (Object)credentials).putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, clientConfig.option(AwsClientOption.SERVICE_SIGNING_NAME)).putAttribute(AwsExecutionAttribute.AWS_REGION, clientConfig.option(AwsClientOption.AWS_REGION)).putAttribute(AwsExecutionAttribute.ENDPOINT_PREFIX, clientConfig.option(AwsClientOption.ENDPOINT_PREFIX)).putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, clientConfig.option(AwsClientOption.SIGNING_REGION)).putAttribute(SdkInternalExecutionAttribute.IS_FULL_DUPLEX, (Object)executionParams.isFullDuplex()).putAttribute(SdkExecutionAttribute.CLIENT_TYPE, clientConfig.option((ClientOption)SdkClientOption.CLIENT_TYPE)).putAttribute(SdkExecutionAttribute.SERVICE_NAME, clientConfig.option((ClientOption)SdkClientOption.SERVICE_NAME)).putAttribute(SdkExecutionAttribute.OPERATION_NAME, (Object)executionParams.getOperationName()).putAttribute(SdkExecutionAttribute.CLIENT_ENDPOINT, clientConfig.option((ClientOption)SdkClientOption.ENDPOINT)).putAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN, clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN)).putAttribute(SdkInternalExecutionAttribute.DISABLE_HOST_PREFIX_INJECTION, clientConfig.option((ClientOption)SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION));
        ExecutionInterceptorChain executionInterceptorChain = new ExecutionInterceptorChain((List)clientConfig.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS));
        return ExecutionContext.builder().interceptorChain(executionInterceptorChain).interceptorContext(InterceptorContext.builder().request(originalRequest).asyncRequestBody(executionParams.getAsyncRequestBody()).requestBody(executionParams.getRequestBody()).build()).executionAttributes(executionAttributes).signer(AwsClientHandlerUtils.computeSigner(originalRequest, clientConfig)).metricCollector(metricCollector).build();
    }

    public static ByteBuffer encodeEventStreamRequestToByteBuffer(SdkHttpFullRequest request) {
        Map<String, HeaderValue> headers = request.headers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> HeaderValue.fromString((String)((String)CollectionUtils.firstIfPresent((List)((List)e.getValue()))))));
        byte[] payload = null;
        if (request.contentStreamProvider().isPresent()) {
            try {
                payload = IoUtils.toByteArray((InputStream)((ContentStreamProvider)request.contentStreamProvider().get()).newStream());
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
        return new Message(headers, payload).toByteBuffer();
    }

    private static Signer computeSigner(SdkRequest originalRequest, SdkClientConfiguration clientConfiguration) {
        return (Signer)originalRequest.overrideConfiguration().flatMap(RequestOverrideConfiguration::signer).orElse(clientConfiguration.option((ClientOption)AwsAdvancedClientOption.SIGNER));
    }

    private static MetricCollector resolveMetricCollector(ClientExecutionParams<?, ?> params) {
        MetricCollector metricCollector = params.getMetricCollector();
        if (metricCollector == null) {
            metricCollector = MetricCollector.create((String)"ApiCall");
        }
        return metricCollector;
    }
}

