/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.eventstream;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

@SdkProtectedApi
public class EventStreamExceptionJsonUnmarshaller<T extends AwsServiceException>
implements Unmarshaller<T, JsonUnmarshallerContext> {
    private static final Logger log = LoggerFactory.getLogger(EventStreamExceptionJsonUnmarshaller.class);
    private final Map<String, Unmarshaller<? extends T, JsonUnmarshallerContext>> unmarshallers;
    private final Unmarshaller<? extends T, JsonUnmarshallerContext> defaultUnmarshaller;

    private EventStreamExceptionJsonUnmarshaller(Builder<T> builder) {
        this.unmarshallers = new HashMap<String, Unmarshaller<? extends T, JsonUnmarshallerContext>>(((Builder)builder).unmarshallers);
        this.defaultUnmarshaller = ((Builder)builder).defaultUnmarshaller;
    }

    public static <T extends AwsServiceException> Builder<T> builder() {
        return new Builder();
    }

    public static AwsServiceException populateDefaultException(Supplier<? extends AwsServiceException.Builder> exceptionBuilderSupplier, JsonUnmarshallerContext context) {
        String errorCode;
        String errorMessage;
        String messageType = context.getHeader(":message-type");
        if ("error".equals(messageType)) {
            errorMessage = context.getHeader(":error-message");
            errorCode = context.getHeader(":error-code");
        } else if ("exception".equals(messageType)) {
            errorMessage = EventStreamExceptionJsonUnmarshaller.extractErrorMessageFromPayload(context);
            errorCode = context.getHeader(":exception-type");
        } else {
            throw new IllegalStateException("Unexpected exception message type: " + messageType);
        }
        SdkBytes rawResponse = SdkBytes.fromInputStream((InputStream)context.getHttpResponse().getContent());
        return exceptionBuilderSupplier.get().awsErrorDetails(AwsErrorDetails.builder().errorMessage(errorMessage).errorCode(errorCode).rawResponse(rawResponse).build()).build();
    }

    public T unmarshall(JsonUnmarshallerContext in) throws Exception {
        String exceptionType = Optional.ofNullable(in.getHeader(":exception-type")).orElse("");
        return (T)((Object)((AwsServiceException)((Object)this.unmarshallers.getOrDefault(exceptionType, this.defaultUnmarshaller).unmarshall((Object)in))));
    }

    private static String extractErrorMessageFromPayload(JsonUnmarshallerContext context) {
        try {
            do {
                if (!context.testExpression("message", 1)) continue;
                context.nextToken();
                return (String)context.getUnmarshaller(String.class).unmarshall((Object)context);
            } while (context.nextToken() != null);
        }
        catch (IOException e) {
            log.info("Could not parse error message from content");
        }
        catch (Exception e) {
            log.info("Could not parse error message from content");
        }
        return null;
    }

    public static final class Builder<T extends AwsServiceException> {
        private final Map<String, Unmarshaller<? extends T, JsonUnmarshallerContext>> unmarshallers = new HashMap<String, Unmarshaller<? extends T, JsonUnmarshallerContext>>();
        private Unmarshaller<? extends T, JsonUnmarshallerContext> defaultUnmarshaller;

        private Builder() {
        }

        public Builder<T> addUnmarshaller(String type, Unmarshaller<? extends T, JsonUnmarshallerContext> unmarshaller) {
            this.unmarshallers.put(type, unmarshaller);
            return this;
        }

        public Builder<T> defaultUnmarshaller(Unmarshaller<? extends T, JsonUnmarshallerContext> defaultUnmarshaller) {
            this.defaultUnmarshaller = defaultUnmarshaller;
            return this;
        }

        public EventStreamExceptionJsonUnmarshaller<T> build() {
            return new EventStreamExceptionJsonUnmarshaller(this);
        }
    }
}

