/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.client.handler;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.internal.client.config.AwsClientOptionValidation;
import software.amazon.awssdk.awscore.internal.client.handler.AwsClientHandlerUtils;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SdkSyncClientHandler;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.internal.http.Crc32Validation;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.http.SdkHttpFullResponse;

@ThreadSafe
@Immutable
@ReviewBeforeRelease(value="This looks identical to the Sdk version, revisit when we add APIG back")
@SdkProtectedApi
public final class AwsSyncClientHandler
extends SdkSyncClientHandler
implements SyncClientHandler {
    private final SdkClientConfiguration clientConfiguration;

    public AwsSyncClientHandler(SdkClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        AwsClientOptionValidation.validateSyncClientOptions(clientConfiguration);
    }

    public <InputT extends SdkRequest, OutputT extends SdkResponse> OutputT execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        ClientExecutionParams<InputT, OutputT> clientExecutionParams = this.addCrc32Validation(executionParams);
        return (OutputT)super.execute(clientExecutionParams);
    }

    public <InputT extends SdkRequest, OutputT extends SdkResponse, ReturnT> ReturnT execute(ClientExecutionParams<InputT, OutputT> executionParams, ResponseTransformer<OutputT, ReturnT> responseTransformer) {
        return (ReturnT)super.execute(executionParams, responseTransformer);
    }

    protected <InputT extends SdkRequest, OutputT extends SdkResponse> ExecutionContext createExecutionContext(ClientExecutionParams<InputT, OutputT> executionParams) {
        return AwsClientHandlerUtils.createExecutionContext(executionParams, this.clientConfiguration);
    }

    private <InputT extends SdkRequest, OutputT> ClientExecutionParams<InputT, OutputT> addCrc32Validation(ClientExecutionParams<InputT, OutputT> executionParams) {
        return executionParams.withResponseHandler(new Crc32ValidationResponseHandler(executionParams.getResponseHandler()));
    }

    private class Crc32ValidationResponseHandler<T>
    implements HttpResponseHandler<T> {
        private final HttpResponseHandler<T> delegate;

        private Crc32ValidationResponseHandler(HttpResponseHandler<T> delegate) {
            this.delegate = delegate;
        }

        public T handle(SdkHttpFullResponse response, ExecutionAttributes executionAttributes) throws Exception {
            return (T)this.delegate.handle(Crc32Validation.validate((boolean)AwsSyncClientHandler.this.isCalculateCrc32FromCompressedData(), (SdkHttpFullResponse)response), executionAttributes);
        }
    }
}

