/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.internal.protocol.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.internal.protocol.json.ErrorCodeParser;
import software.amazon.awssdk.core.internal.protocol.json.JsonContent;
import software.amazon.awssdk.http.SdkHttpFullResponse;

@SdkInternalApi
public class JsonErrorCodeParser
implements ErrorCodeParser {
    public static final String X_AMZN_ERROR_TYPE = "x-amzn-ErrorType";
    static final String ERROR_CODE_HEADER = ":error-code";
    static final String EXCEPTION_TYPE_HEADER = ":exception-type";
    private static final Logger log = LoggerFactory.getLogger(JsonErrorCodeParser.class);
    private final List<String> errorCodeHeaders;
    private final String errorCodeFieldName;

    public JsonErrorCodeParser() {
        this(null);
    }

    public JsonErrorCodeParser(String errorCodeFieldName) {
        this.errorCodeFieldName = errorCodeFieldName == null ? "__type" : errorCodeFieldName;
        this.errorCodeHeaders = Arrays.asList(X_AMZN_ERROR_TYPE, ERROR_CODE_HEADER, EXCEPTION_TYPE_HEADER);
    }

    @Override
    public String parseErrorCode(SdkHttpFullResponse response, JsonContent jsonContent) {
        String errorCodeFromHeader = this.parseErrorCodeFromHeader(response);
        if (errorCodeFromHeader != null) {
            return errorCodeFromHeader;
        }
        if (jsonContent != null) {
            return this.parseErrorCodeFromContents(jsonContent.getJsonNode());
        }
        return null;
    }

    private String parseErrorCodeFromHeader(SdkHttpFullResponse response) {
        Map<String, List> filteredHeaders = response.headers().entrySet().stream().filter(e -> this.errorCodeHeaders.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (filteredHeaders.isEmpty()) {
            return null;
        }
        if (filteredHeaders.size() > 1) {
            log.warn("Response contains multiple headers representing the error code: " + filteredHeaders.keySet());
        }
        String headerKey = (String)filteredHeaders.keySet().stream().findFirst().get();
        String headerValue = (String)filteredHeaders.get(headerKey).get(0);
        if (X_AMZN_ERROR_TYPE.equals(headerKey)) {
            return this.parseErrorCodeFromXAmzErrorType(headerValue);
        }
        return headerValue;
    }

    private String parseErrorCodeFromXAmzErrorType(String headerValue) {
        int separator;
        if (headerValue != null && (separator = headerValue.indexOf(58)) != -1) {
            headerValue = headerValue.substring(0, separator);
        }
        return headerValue;
    }

    private String parseErrorCodeFromContents(JsonNode jsonContents) {
        if (jsonContents == null || !jsonContents.has(this.errorCodeFieldName)) {
            return null;
        }
        String code = jsonContents.findValue(this.errorCodeFieldName).asText();
        int separator = code.lastIndexOf("#");
        return code.substring(separator + 1);
    }
}

