/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.internal.protocol.json;

import java.util.Arrays;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.internal.protocol.json.ErrorCodeParser;
import software.amazon.awssdk.core.internal.protocol.json.JsonContent;
import software.amazon.awssdk.http.SdkHttpFullResponse;

@SdkInternalApi
public class CompositeErrorCodeParser
implements ErrorCodeParser {
    private final Iterable<ErrorCodeParser> parsers;

    CompositeErrorCodeParser(ErrorCodeParser ... parsers) {
        this.parsers = Arrays.asList(parsers);
    }

    @Override
    public String parseErrorCode(SdkHttpFullResponse response, JsonContent jsonContent) {
        for (ErrorCodeParser parser : this.parsers) {
            String errorCode = parser.parseErrorCode(response, jsonContent);
            if (errorCode == null) continue;
            return errorCode;
        }
        return null;
    }
}

