/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.protocol.xml;

import javax.xml.xpath.XPath;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.runtime.transform.AbstractErrorUnmarshaller;
import software.amazon.awssdk.core.util.xml.XpathUtils;

@SdkProtectedApi
public class StandardErrorUnmarshaller
extends AbstractErrorUnmarshaller<AwsServiceException, Node> {
    public StandardErrorUnmarshaller() {
        super(AwsServiceException.class);
    }

    public StandardErrorUnmarshaller(Class<? extends AwsServiceException> exceptionClass) {
        super(exceptionClass);
    }

    public AwsServiceException unmarshall(Node in) throws Exception {
        XPath xpath = XpathUtils.xpath();
        String errorCode = this.parseErrorCode(in, xpath);
        return this.standardErrorPathException(errorCode, in, xpath);
    }

    public String parseErrorCode(Node in) throws Exception {
        return XpathUtils.asString((String)"ErrorResponse/Error/Code", (Node)in);
    }

    public String parseErrorCode(Node in, XPath xpath) throws Exception {
        return XpathUtils.asString((String)"ErrorResponse/Error/Code", (Node)in, (XPath)xpath);
    }

    public String getErrorPropertyPath(String property) {
        return "ErrorResponse/Error/" + property;
    }

    public AwsServiceException standardErrorPathException(String errorCode, Node in, XPath xpath) throws Exception {
        String requestId = XpathUtils.asString((String)"ErrorResponse/RequestId", (Node)in, (XPath)xpath);
        String message = XpathUtils.asString((String)"ErrorResponse/Error/Message", (Node)in, (XPath)xpath);
        AwsServiceException.Builder exception = ((AwsServiceException)this.newException(message)).toBuilder();
        AwsErrorDetails awsErrorDetails = AwsErrorDetails.builder().errorCode(errorCode).errorMessage(message).build();
        exception.requestId(requestId);
        exception.awsErrorDetails(awsErrorDetails);
        return exception.build();
    }
}

