/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.http.response;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponse;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.util.xml.XpathUtils;
import software.amazon.awssdk.utils.IoUtils;

@SdkProtectedApi
public final class DefaultErrorResponseHandler
implements HttpResponseHandler<AwsServiceException> {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorResponseHandler.class);
    private List<Unmarshaller<AwsServiceException, Node>> unmarshallerList;

    public DefaultErrorResponseHandler(List<Unmarshaller<AwsServiceException, Node>> unmarshallerList) {
        this.unmarshallerList = unmarshallerList;
    }

    public AwsServiceException handle(HttpResponse errorResponse, ExecutionAttributes executionAttributes) throws Exception {
        AwsServiceException exception = this.createServiceException(errorResponse);
        if (exception == null) {
            throw SdkClientException.builder().message("Unable to unmarshall error response from service").build();
        }
        AwsServiceException.Builder exceptionBuilder = exception.toBuilder();
        AwsErrorDetails.Builder awsErrorDetails = exceptionBuilder.awsErrorDetails().toBuilder().sdkHttpResponse(errorResponse).serviceName((String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME));
        if (awsErrorDetails.errorCode() == null) {
            awsErrorDetails.errorCode(errorResponse.getStatusCode() + " " + errorResponse.getStatusText());
        }
        return exceptionBuilder.awsErrorDetails(awsErrorDetails.build()).build();
    }

    private AwsServiceException createServiceException(HttpResponse errorResponse) throws Exception {
        Document document = this.documentFromContent(errorResponse.getContent(), this.idString(errorResponse));
        for (Unmarshaller<AwsServiceException, Node> unmarshaller : this.unmarshallerList) {
            AwsServiceException exception = (AwsServiceException)((Object)unmarshaller.unmarshall((Object)document));
            if (exception == null) continue;
            return exception.toBuilder().statusCode(errorResponse.getStatusCode()).build();
        }
        return null;
    }

    private Document documentFromContent(InputStream content, String idString) throws ParserConfigurationException, SAXException, IOException {
        try {
            return this.parseXml(this.contentToString(content, idString), idString);
        }
        catch (Exception e) {
            return XpathUtils.documentFrom((String)"<empty/>");
        }
    }

    private String contentToString(InputStream content, String idString) throws Exception {
        try {
            return IoUtils.toUtf8String((InputStream)content);
        }
        catch (Exception e) {
            log.debug(String.format("Unable to read input stream to string (%s)", idString), (Throwable)e);
            throw e;
        }
    }

    private Document parseXml(String xml, String idString) throws Exception {
        try {
            return XpathUtils.documentFrom((String)xml);
        }
        catch (Exception e) {
            log.debug("Unable to parse HTTP response ({}) content to XML document '{}' ", new Object[]{idString, xml, e});
            throw e;
        }
    }

    private String idString(HttpResponse errorResponse) {
        StringBuilder idString = new StringBuilder();
        try {
            errorResponse.getRequest().firstMatchingHeader("amz-sdk-invocation-id").ifPresent(h -> idString.append("Invocation Id:").append((String)h));
            if (errorResponse.getHeaders().containsKey("x-amzn-RequestId")) {
                if (idString.length() > 0) {
                    idString.append(", ");
                }
                idString.append("Request Id:").append((String)errorResponse.getHeaders().get("x-amzn-RequestId"));
            }
        }
        catch (NullPointerException npe) {
            log.debug("Error getting Request or Invocation ID from response", (Throwable)npe);
        }
        return idString.length() > 0 ? idString.toString() : "Unknown";
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

