/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.protocol.xml;

import javax.xml.xpath.XPath;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.ErrorType;
import software.amazon.awssdk.core.runtime.transform.AbstractErrorUnmarshaller;
import software.amazon.awssdk.core.util.XpathUtils;

@SdkProtectedApi
public class StandardErrorUnmarshaller
extends AbstractErrorUnmarshaller<AwsServiceException, Node> {
    public StandardErrorUnmarshaller() {
        super(AwsServiceException.class);
    }

    public StandardErrorUnmarshaller(Class<? extends AwsServiceException> exceptionClass) {
        super(exceptionClass);
    }

    public AwsServiceException unmarshall(Node in) throws Exception {
        XPath xpath = XpathUtils.xpath();
        String errorCode = this.parseErrorCode(in, xpath);
        return this.standardErrorPathException(errorCode, in, xpath);
    }

    public String parseErrorCode(Node in) throws Exception {
        return XpathUtils.asString((String)"ErrorResponse/Error/Code", (Node)in);
    }

    public String parseErrorCode(Node in, XPath xpath) throws Exception {
        return XpathUtils.asString((String)"ErrorResponse/Error/Code", (Node)in, (XPath)xpath);
    }

    public String getErrorPropertyPath(String property) {
        return "ErrorResponse/Error/" + property;
    }

    public AwsServiceException standardErrorPathException(String errorCode, Node in, XPath xpath) throws Exception {
        String errorType = XpathUtils.asString((String)"ErrorResponse/Error/Type", (Node)in, (XPath)xpath);
        String requestId = XpathUtils.asString((String)"ErrorResponse/RequestId", (Node)in, (XPath)xpath);
        String message = XpathUtils.asString((String)"ErrorResponse/Error/Message", (Node)in, (XPath)xpath);
        AwsServiceException exception = (AwsServiceException)this.newException(message);
        exception.errorCode(errorCode);
        exception.requestId(requestId);
        exception.errorType(this.getErrorType(errorType));
        return exception;
    }

    public ErrorType getErrorType(String errorType) {
        if ("Receiver".equals(errorType)) {
            return ErrorType.SERVICE;
        }
        if ("Sender".equals(errorType)) {
            return ErrorType.CLIENT;
        }
        return ErrorType.fromValue((String)errorType);
    }
}

