/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.protocol.xml;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.util.DateUtils;
import software.amazon.awssdk.utils.Base64Utils;

public class SimpleTypeStaxUnmarshallers {
    private static Logger log = LoggerFactory.getLogger(SimpleTypeStaxUnmarshallers.class);

    private SimpleTypeStaxUnmarshallers() {
    }

    public static class ShortJsonUnmarshaller
    implements Unmarshaller<Short, StaxUnmarshallerContext> {
        private static final ShortJsonUnmarshaller INSTANCE = new ShortJsonUnmarshaller();

        public static ShortJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        public Short unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String shortString = unmarshallerContext.readText();
            return shortString == null ? null : Short.valueOf(shortString);
        }
    }

    public static class CharacterJsonUnmarshaller
    implements Unmarshaller<Character, StaxUnmarshallerContext> {
        private static final CharacterJsonUnmarshaller INSTANCE = new CharacterJsonUnmarshaller();

        public static CharacterJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        public Character unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String charString = unmarshallerContext.readText();
            if (charString == null) {
                return null;
            }
            if ((charString = charString.trim()).isEmpty() || charString.length() > 1) {
                throw new SdkClientException("'" + charString + "' cannot be converted to Character");
            }
            return Character.valueOf(charString.charAt(0));
        }
    }

    public static class ByteBufferUnmarshaller
    implements Unmarshaller<ByteBuffer, StaxUnmarshallerContext> {
        private static final ByteBufferUnmarshaller INSTANCE = new ByteBufferUnmarshaller();

        public static ByteBufferUnmarshaller getInstance() {
            return INSTANCE;
        }

        public ByteBuffer unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String base64EncodedString = unmarshallerContext.readText();
            byte[] decodedBytes = Base64Utils.decode((String)base64EncodedString);
            return ByteBuffer.wrap(decodedBytes);
        }
    }

    public static class InstantUnmarshaller
    implements Unmarshaller<Instant, StaxUnmarshallerContext> {
        private static final InstantUnmarshaller INSTANCE = new InstantUnmarshaller();

        public static InstantUnmarshaller getInstance() {
            return INSTANCE;
        }

        public Instant unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String dateString = unmarshallerContext.readText();
            if (dateString == null) {
                return null;
            }
            try {
                return DateUtils.parseIso8601Date((String)dateString);
            }
            catch (Exception e) {
                log.warn("Unable to parse date '" + dateString + "':  " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    public static class ByteUnmarshaller
    implements Unmarshaller<Byte, StaxUnmarshallerContext> {
        private static final ByteUnmarshaller INSTANCE = new ByteUnmarshaller();

        public static ByteUnmarshaller getInstance() {
            return INSTANCE;
        }

        public Byte unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String byteString = unmarshallerContext.readText();
            return byteString == null ? null : Byte.valueOf(byteString);
        }
    }

    public static class LongUnmarshaller
    implements Unmarshaller<Long, StaxUnmarshallerContext> {
        private static final LongUnmarshaller INSTANCE = new LongUnmarshaller();

        public static LongUnmarshaller getInstance() {
            return INSTANCE;
        }

        public Long unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String longString = unmarshallerContext.readText();
            return longString == null ? null : Long.valueOf(Long.parseLong(longString));
        }
    }

    public static class FloatUnmarshaller
    implements Unmarshaller<Float, StaxUnmarshallerContext> {
        private static final FloatUnmarshaller INSTANCE = new FloatUnmarshaller();

        public static FloatUnmarshaller getInstance() {
            return INSTANCE;
        }

        public Float unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String floatString = unmarshallerContext.readText();
            return floatString == null ? null : Float.valueOf(floatString);
        }
    }

    public static class BooleanUnmarshaller
    implements Unmarshaller<Boolean, StaxUnmarshallerContext> {
        private static final BooleanUnmarshaller INSTANCE = new BooleanUnmarshaller();

        public static BooleanUnmarshaller getInstance() {
            return INSTANCE;
        }

        public Boolean unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String booleanString = unmarshallerContext.readText();
            return booleanString == null ? null : Boolean.valueOf(Boolean.parseBoolean(booleanString));
        }
    }

    public static class IntegerUnmarshaller
    implements Unmarshaller<Integer, StaxUnmarshallerContext> {
        private static final IntegerUnmarshaller INSTANCE = new IntegerUnmarshaller();

        public static IntegerUnmarshaller getInstance() {
            return INSTANCE;
        }

        public Integer unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String intString = unmarshallerContext.readText();
            return intString == null ? null : Integer.valueOf(Integer.parseInt(intString));
        }
    }

    public static class DoubleUnmarshaller
    implements Unmarshaller<Double, StaxUnmarshallerContext> {
        private static final DoubleUnmarshaller INSTANCE = new DoubleUnmarshaller();

        public static DoubleUnmarshaller getInstance() {
            return INSTANCE;
        }

        public Double unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String doubleString = unmarshallerContext.readText();
            return doubleString == null ? null : Double.valueOf(Double.parseDouble(doubleString));
        }
    }

    public static class BigIntegerUnmarshaller
    implements Unmarshaller<BigInteger, StaxUnmarshallerContext> {
        private static final BigIntegerUnmarshaller INSTANCE = new BigIntegerUnmarshaller();

        public static BigIntegerUnmarshaller getInstance() {
            return INSTANCE;
        }

        public BigInteger unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String s = unmarshallerContext.readText();
            return s == null ? null : new BigInteger(s);
        }
    }

    public static class BigDecimalUnmarshaller
    implements Unmarshaller<BigDecimal, StaxUnmarshallerContext> {
        private static final BigDecimalUnmarshaller INSTANCE = new BigDecimalUnmarshaller();

        public static BigDecimalUnmarshaller getInstance() {
            return INSTANCE;
        }

        public BigDecimal unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String s = unmarshallerContext.readText();
            return s == null ? null : new BigDecimal(s);
        }
    }

    public static class StringUnmarshaller
    implements Unmarshaller<String, StaxUnmarshallerContext> {
        private static final StringUnmarshaller INSTANCE = new StringUnmarshaller();

        public static StringUnmarshaller getInstance() {
            return INSTANCE;
        }

        public String unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.readText();
        }
    }
}

