/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.protocol.xml;

import javax.xml.xpath.XPath;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.ErrorType;
import software.amazon.awssdk.core.runtime.transform.AbstractErrorUnmarshaller;
import software.amazon.awssdk.core.util.XpathUtils;

@SdkProtectedApi
public class LegacyErrorUnmarshaller
extends AbstractErrorUnmarshaller<AwsServiceException, Node> {
    public LegacyErrorUnmarshaller() {
        this(AwsServiceException.class);
    }

    public LegacyErrorUnmarshaller(Class<? extends AwsServiceException> exceptionClass) {
        super(exceptionClass);
    }

    public AwsServiceException unmarshall(Node in) throws Exception {
        XPath xpath = XpathUtils.xpath();
        String errorCode = this.parseErrorCode(in, xpath);
        String message = XpathUtils.asString((String)"Response/Errors/Error/Message", (Node)in, (XPath)xpath);
        String requestId = XpathUtils.asString((String)"Response/RequestID", (Node)in, (XPath)xpath);
        String errorType = XpathUtils.asString((String)"Response/Errors/Error/Type", (Node)in, (XPath)xpath);
        AwsServiceException exception = (AwsServiceException)this.newException(message);
        exception.errorCode(errorCode);
        exception.requestId(requestId);
        if ("Client".equalsIgnoreCase(errorType)) {
            exception.errorType(ErrorType.CLIENT);
        } else if ("Server".equalsIgnoreCase(errorType)) {
            exception.errorType(ErrorType.SERVICE);
        } else {
            exception.errorType(ErrorType.fromValue((String)errorType));
        }
        return exception;
    }

    public String parseErrorCode(Node in) throws Exception {
        return XpathUtils.asString((String)"Response/Errors/Error/Code", (Node)in);
    }

    public String parseErrorCode(Node in, XPath xpath) throws Exception {
        return XpathUtils.asString((String)"Response/Errors/Error/Code", (Node)in, (XPath)xpath);
    }

    public String getErrorPropertyPath(String property) {
        return "Response/Errors/Error/" + property;
    }
}

