/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.http.response;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.VoidStaxUnmarshaller;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.SdkResponseMetadata;
import software.amazon.awssdk.core.SdkStandardLoggers;
import software.amazon.awssdk.core.http.HttpResponse;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.XmlUtils;

@SdkProtectedApi
@ReviewBeforeRelease(value="ResponseMetadata is currently broken. Revisit when base result types are refactored")
public class StaxResponseHandler<T>
implements HttpResponseHandler<T> {
    private static final Logger log = Logger.loggerFor(StaxResponseHandler.class);
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T handle(HttpResponse response, ExecutionAttributes executionAttributes) throws Exception {
        SdkStandardLoggers.REQUEST_LOGGER.trace(() -> "Parsing service response XML.");
        InputStream content = response.getContent();
        if (content == null) {
            content = new ByteArrayInputStream("<eof/>".getBytes(StringUtils.UTF8));
        }
        XMLEventReader eventReader = XmlUtils.xmlInputFactory().createXMLEventReader(content);
        try {
            StaxUnmarshallerContext unmarshallerContext = new StaxUnmarshallerContext(eventReader, response.getHeaders());
            unmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
            unmarshallerContext.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            Object result = this.responseUnmarshaller.unmarshall((Object)unmarshallerContext);
            SdkStandardLoggers.REQUEST_LOGGER.trace(() -> "Done parsing service response.");
            Object object = result;
            return (T)object;
        }
        finally {
            try {
                eventReader.close();
            }
            catch (XMLStreamException e) {
                log.warn(() -> "Error closing XML parser.", (Throwable)e);
            }
        }
    }

    protected SdkResponseMetadata getResponseMetadata(Map<String, String> metadata) {
        return new SdkResponseMetadata(metadata);
    }

    protected void registerAdditionalMetadataExpressions(StaxUnmarshallerContext unmarshallerContext) {
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }

    public static <ResponseT extends SdkResponse> HttpResponseHandler<ResponseT> createStreamingResponseHandler(Unmarshaller<ResponseT, StaxUnmarshallerContext> unmarshaller) {
        final FunctionalUtils.UnsafeFunction unmarshallFunction = response -> StaxResponseHandler.unmarshallStreaming(unmarshaller, response);
        return new HttpResponseHandler<ResponseT>(){

            public ResponseT handle(HttpResponse response, ExecutionAttributes executionAttributes) throws Exception {
                return (SdkResponse)unmarshallFunction.apply((Object)response);
            }

            public boolean needsConnectionLeftOpen() {
                return true;
            }
        };
    }

    private static <ResponseT extends SdkResponse> ResponseT unmarshallStreaming(Unmarshaller<ResponseT, StaxUnmarshallerContext> unmarshaller, HttpResponse response) throws Exception {
        XMLEventReader eventReader = XmlUtils.xmlInputFactory().createXMLEventReader(new ByteArrayInputStream("<eof/>".getBytes(StringUtils.UTF8)));
        StaxUnmarshallerContext unmarshallerContext = new StaxUnmarshallerContext(eventReader, response.getHeaders());
        unmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
        unmarshallerContext.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
        return (ResponseT)((SdkResponse)unmarshaller.unmarshall((Object)unmarshallerContext));
    }
}

