/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.http.response;

import com.fasterxml.jackson.core.JsonFactory;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonErrorUnmarshaller;
import software.amazon.awssdk.awscore.protocol.json.ErrorCodeParser;
import software.amazon.awssdk.core.http.HttpResponse;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttributes;
import software.amazon.awssdk.core.protocol.json.ErrorMessageParser;
import software.amazon.awssdk.core.protocol.json.JsonContent;
import software.amazon.awssdk.core.protocol.json.JsonErrorUnmarshaller;
import software.amazon.awssdk.core.runtime.http.response.JsonErrorResponseHandler;

@SdkInternalApi
public class AwsJsonErrorResponseHandler
extends JsonErrorResponseHandler<AwsServiceException> {
    private final List<AwsJsonErrorUnmarshaller> unmarshallers;
    private final ErrorCodeParser errorCodeParser;
    private final ErrorMessageParser errorMessageParser;
    private final JsonFactory jsonFactory;

    public AwsJsonErrorResponseHandler(List<AwsJsonErrorUnmarshaller> errorUnmarshallers, ErrorCodeParser errorCodeParser, ErrorMessageParser errorMessageParser, JsonFactory jsonFactory) {
        this.unmarshallers = errorUnmarshallers;
        this.errorCodeParser = errorCodeParser;
        this.errorMessageParser = errorMessageParser;
        this.jsonFactory = jsonFactory;
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }

    public AwsServiceException handle(HttpResponse response, ExecutionAttributes executionAttributes) throws Exception {
        JsonContent jsonContent = JsonContent.createJsonContent((HttpResponse)response, (JsonFactory)this.jsonFactory);
        String errorCode = this.errorCodeParser.parseErrorCode(response, jsonContent);
        AwsServiceException exception = this.createException(errorCode, jsonContent);
        if (exception.errorMessage() == null) {
            exception.errorMessage(this.errorMessageParser.parseErrorMessage(response, jsonContent.getJsonNode()));
        }
        exception.errorCode(errorCode);
        exception.serviceName((String)executionAttributes.getAttribute(SdkExecutionAttributes.SERVICE_NAME));
        exception.statusCode(response.getStatusCode());
        exception.errorType(this.getErrorType(response.getStatusCode()));
        exception.rawResponse(jsonContent.getRawContent());
        exception.requestId(this.getRequestIdFromHeaders(response.getHeaders()));
        exception.headers(response.getHeaders());
        return exception;
    }

    private AwsServiceException createException(String errorCode, JsonContent jsonContent) {
        return this.unmarshallers.stream().filter(u -> u.matchErrorCode(errorCode)).findFirst().map(u -> (AwsServiceException)this.safeUnmarshall(jsonContent, (JsonErrorUnmarshaller)u)).orElseGet(this::createUnknownException);
    }

    protected AwsServiceException createUnknownException() {
        return new AwsServiceException("Unable to unmarshall exception response with the unmarshallers provided");
    }
}

