/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.config.defaults;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.config.AwsAdvancedClientOption;
import software.amazon.awssdk.awscore.config.defaults.AwsClientConfigurationDefaults;
import software.amazon.awssdk.core.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.config.InternalAdvancedClientOption;
import software.amazon.awssdk.core.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.runtime.auth.SignerProvider;

@SdkProtectedApi
public class ServiceBuilderConfigurationDefaults
extends AwsClientConfigurationDefaults {
    private final Supplier<SignerProvider> defaultSignerProvider;
    private final Supplier<URI> defaultEndpoint;
    private final List<String> requestHandlerPaths;
    private final Boolean crc32FromCompressedDataEnabled;

    private ServiceBuilderConfigurationDefaults(Builder builder) {
        this.defaultSignerProvider = builder.defaultSignerProvider;
        this.defaultEndpoint = builder.defaultEndpoint;
        this.requestHandlerPaths = new ArrayList<String>(builder.requestHandlerPaths);
        this.crc32FromCompressedDataEnabled = builder.crc32FromCompressedDataEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected void applyOverrideDefaults(ClientOverrideConfiguration.Builder builder) {
        ClientOverrideConfiguration config = (ClientOverrideConfiguration)builder.build();
        if (this.defaultSignerProvider != null) {
            builder.advancedOption(AwsAdvancedClientOption.SIGNER_PROVIDER, this.applyDefault(config.advancedOption(AwsAdvancedClientOption.SIGNER_PROVIDER), this.defaultSignerProvider));
        }
        if (this.crc32FromCompressedDataEnabled != null) {
            Boolean currentValue = (Boolean)config.advancedOption((SdkAdvancedClientOption)InternalAdvancedClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED);
            builder.advancedOption((SdkAdvancedClientOption)InternalAdvancedClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, this.applyDefault(currentValue, () -> this.crc32FromCompressedDataEnabled));
        }
        ClasspathInterceptorChainFactory chainFactory = new ClasspathInterceptorChainFactory();
        ArrayList serviceInterceptors = new ArrayList();
        this.requestHandlerPaths.forEach(p -> serviceInterceptors.addAll(chainFactory.getInterceptors(p)));
        serviceInterceptors.addAll(config.executionInterceptors());
        builder.executionInterceptors(serviceInterceptors);
    }

    protected URI getEndpointDefault() {
        return this.defaultEndpoint.get();
    }

    public static final class Builder {
        private Supplier<SignerProvider> defaultSignerProvider;
        private Supplier<URI> defaultEndpoint;
        private List<String> requestHandlerPaths = new ArrayList<String>();
        private Boolean crc32FromCompressedDataEnabled = false;

        private Builder() {
        }

        public Builder defaultSignerProvider(Supplier<SignerProvider> defaultSignerProvider) {
            this.defaultSignerProvider = defaultSignerProvider;
            return this;
        }

        public Builder defaultEndpoint(Supplier<URI> endpoint) {
            this.defaultEndpoint = endpoint;
            return this;
        }

        public Builder crc32FromCompressedDataEnabled(Boolean crc32FromCompressedDataEnabled) {
            this.crc32FromCompressedDataEnabled = crc32FromCompressedDataEnabled;
            return this;
        }

        public Builder addRequestHandlerPath(String handlerPath) {
            this.requestHandlerPaths.add(handlerPath);
            return this;
        }

        public ServiceBuilderConfigurationDefaults build() {
            return new ServiceBuilderConfigurationDefaults(this);
        }
    }
}

