/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.config.defaults;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.config.defaults.AwsClientConfigurationDefaults;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.core.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.config.InternalAdvancedClientOption;
import software.amazon.awssdk.core.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.util.UserAgentUtils;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
public final class AwsGlobalClientConfigurationDefaults
extends AwsClientConfigurationDefaults {
    @ReviewBeforeRelease(value="Load test this to make sure it's appropriate.")
    public static final int DEFAULT_ASYNC_POOL_SIZE = 1;

    protected void applyOverrideDefaults(ClientOverrideConfiguration.Builder builder) {
        ClientOverrideConfiguration configuration = (ClientOverrideConfiguration)builder.build();
        builder.gzipEnabled((Boolean)this.applyDefault(configuration.gzipEnabled(), () -> false));
        builder.advancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, this.applyDefault(configuration.advancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX), UserAgentUtils::getUserAgent));
        builder.advancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, this.applyDefault(configuration.advancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX), () -> ""));
        builder.advancedOption((SdkAdvancedClientOption)InternalAdvancedClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, this.applyDefault(configuration.advancedOption((SdkAdvancedClientOption)InternalAdvancedClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED), () -> false));
        builder.retryPolicy((RetryPolicy)this.applyDefault(configuration.retryPolicy(), () -> AwsRetryPolicy.DEFAULT));
        List globalInterceptors = new ClasspathInterceptorChainFactory().getGlobalInterceptors();
        builder.executionInterceptors(CollectionUtils.mergeLists((List)globalInterceptors, (List)configuration.executionInterceptors()));
    }

    protected ScheduledExecutorService getAsyncExecutorDefault() {
        return Executors.newScheduledThreadPool(1);
    }
}

