/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.client.builder;

import java.net.URI;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.config.AwsAdvancedClientOption;
import software.amazon.awssdk.awscore.config.AwsImmutableAsyncClientConfiguration;
import software.amazon.awssdk.awscore.config.AwsImmutableSyncClientConfiguration;
import software.amazon.awssdk.awscore.config.AwsMutableClientConfiguration;
import software.amazon.awssdk.awscore.config.defaults.AwsClientConfigurationDefaults;
import software.amazon.awssdk.awscore.config.defaults.AwsGlobalClientConfigurationDefaults;
import software.amazon.awssdk.awscore.endpoint.EndpointUtils;
import software.amazon.awssdk.core.client.builder.SdkDefaultClientBuilder;
import software.amazon.awssdk.core.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.SdkHttpClientFactory;
import software.amazon.awssdk.http.async.SdkAsyncHttpClientFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;

@SdkProtectedApi
public abstract class AwsDefaultClientBuilder<B extends AwsClientBuilder<B, C>, C>
extends SdkDefaultClientBuilder<B, C>
implements AwsClientBuilder<B, C> {
    private static final String DEFAULT_ENDPOINT_PROTOCOL = "https";
    private static final AwsRegionProvider DEFAULT_REGION_PROVIDER = new DefaultAwsRegionProviderChain();
    private AwsMutableClientConfiguration awsMutableClientConfiguration = new AwsMutableClientConfiguration();
    private Region region;

    protected AwsDefaultClientBuilder() {
    }

    @SdkTestInternalApi
    AwsDefaultClientBuilder(SdkHttpClientFactory defaultHttpClientFactory, SdkAsyncHttpClientFactory defaultAsyncHttpClientFactory) {
        super(defaultHttpClientFactory, defaultAsyncHttpClientFactory);
    }

    protected abstract String serviceEndpointPrefix();

    protected AwsClientConfigurationDefaults serviceDefaults() {
        return new AwsClientConfigurationDefaults(){};
    }

    protected final Region signingRegion() {
        return ServiceMetadata.of((String)this.serviceEndpointPrefix()).signingRegion(this.resolveRegion().orElseThrow(() -> new IllegalStateException("The signing region could not be determined.")));
    }

    protected final AwsImmutableSyncClientConfiguration syncClientConfiguration() {
        AwsMutableClientConfiguration configuration = this.awsMutableClientConfiguration.clone();
        this.builderDefaults().applySyncDefaults(configuration);
        this.serviceDefaults().applySyncDefaults(configuration);
        new AwsGlobalClientConfigurationDefaults().applySyncDefaults(configuration);
        this.applySdkHttpClient(configuration);
        return new AwsImmutableSyncClientConfiguration(configuration);
    }

    protected final AwsImmutableAsyncClientConfiguration asyncClientConfiguration() {
        AwsMutableClientConfiguration configuration = this.awsMutableClientConfiguration.clone();
        this.builderDefaults().applyAsyncDefaults(configuration);
        this.serviceDefaults().applyAsyncDefaults(configuration);
        new AwsGlobalClientConfigurationDefaults().applyAsyncDefaults(configuration);
        this.applySdkAsyncHttpClient(configuration);
        return new AwsImmutableAsyncClientConfiguration(configuration);
    }

    protected final AwsClientConfigurationDefaults builderDefaults() {
        return new AwsClientConfigurationDefaults(){

            protected URI getEndpointDefault() {
                return AwsDefaultClientBuilder.this.resolveEndpoint().orElse(null);
            }

            @Override
            protected AwsCredentialsProvider getCredentialsDefault() {
                return DefaultCredentialsProvider.create();
            }

            protected ScheduledExecutorService getAsyncExecutorDefault() {
                return Optional.ofNullable(AwsDefaultClientBuilder.this.asyncExecutorProvider).map(Supplier::get).orElse(null);
            }

            protected void applyOverrideDefaults(ClientOverrideConfiguration.Builder builder) {
                builder.advancedOption(AwsAdvancedClientOption.AWS_REGION, AwsDefaultClientBuilder.this.resolveRegion().orElseThrow(() -> new SdkClientException("AWS region not provided")));
            }
        };
    }

    protected Optional<URI> resolveEndpoint() {
        URI configuredEndpoint = this.awsMutableClientConfiguration.endpoint();
        return configuredEndpoint != null ? Optional.of(configuredEndpoint) : this.endpointFromRegion();
    }

    private Optional<Region> regionFromDefaultProvider() {
        return this.useRegionProviderChain() ? Optional.ofNullable(DEFAULT_REGION_PROVIDER.getRegion()) : Optional.empty();
    }

    private boolean useRegionProviderChain() {
        Boolean configuredToUseRegionProviderChain = (Boolean)this.awsMutableClientConfiguration.overrideConfiguration().advancedOption(AwsAdvancedClientOption.ENABLE_DEFAULT_REGION_DETECTION);
        return configuredToUseRegionProviderChain != null ? configuredToUseRegionProviderChain : true;
    }

    public B endpointOverride(URI endpointOverride) {
        this.awsMutableClientConfiguration.endpoint(endpointOverride);
        return (B)((AwsClientBuilder)this.thisBuilder());
    }

    public final B overrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.awsMutableClientConfiguration.overrideConfiguration(overrideConfiguration);
        return (B)((AwsClientBuilder)this.thisBuilder());
    }

    private Optional<Region> resolveRegion() {
        return this.region != null ? Optional.of(this.region) : this.regionFromDefaultProvider();
    }

    private Optional<URI> endpointFromRegion() {
        return this.resolveRegion().map(r -> EndpointUtils.buildEndpoint(DEFAULT_ENDPOINT_PROTOCOL, this.serviceEndpointPrefix(), r));
    }

    @Override
    public final B region(Region region) {
        this.region = region;
        return (B)((AwsClientBuilder)this.thisBuilder());
    }

    public final void setRegion(Region region) {
        this.region(region);
    }

    @Override
    public final B credentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.awsMutableClientConfiguration.credentialsProvider(credentialsProvider);
        return (B)((AwsClientBuilder)this.thisBuilder());
    }

    public final void setCredentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.credentialsProvider(credentialsProvider);
    }
}

