/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore;

import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.RequestOverrideConfig;

public final class AwsRequestOverrideConfig
extends RequestOverrideConfig {
    private final AwsCredentialsProvider credentialsProvider;

    private AwsRequestOverrideConfig(Builder builder) {
        super((RequestOverrideConfig.Builder)builder);
        this.credentialsProvider = builder.credentialsProvider();
    }

    public Optional<AwsCredentialsProvider> credentialsProvider() {
        return Optional.ofNullable(this.credentialsProvider);
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static final class BuilderImpl
    extends RequestOverrideConfig.BuilderImpl<Builder>
    implements Builder {
        private AwsCredentialsProvider awsCredentialsProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super((RequestOverrideConfig)awsRequestOverrideConfig);
            this.awsCredentialsProvider = awsRequestOverrideConfig.credentialsProvider;
        }

        @Override
        public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.awsCredentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public AwsCredentialsProvider credentialsProvider() {
            return this.awsCredentialsProvider;
        }

        @Override
        public AwsRequestOverrideConfig build() {
            return new AwsRequestOverrideConfig(this);
        }
    }

    public static interface Builder
    extends RequestOverrideConfig.Builder<Builder> {
        public Builder credentialsProvider(AwsCredentialsProvider var1);

        public AwsCredentialsProvider credentialsProvider();

        public AwsRequestOverrideConfig build();
    }
}

