/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscalingplans.model.AutoScalingPlansRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteScalingPlanRequest
extends AutoScalingPlansRequest
implements ToCopyableBuilder<Builder, DeleteScalingPlanRequest> {
    private static final SdkField<String> SCALING_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingPlanName").getter(DeleteScalingPlanRequest.getter(DeleteScalingPlanRequest::scalingPlanName)).setter(DeleteScalingPlanRequest.setter(Builder::scalingPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanName").build()}).build();
    private static final SdkField<Long> SCALING_PLAN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ScalingPlanVersion").getter(DeleteScalingPlanRequest.getter(DeleteScalingPlanRequest::scalingPlanVersion)).setter(DeleteScalingPlanRequest.setter(Builder::scalingPlanVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_NAME_FIELD, SCALING_PLAN_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteScalingPlanRequest.memberNameToFieldInitializer();
    private final String scalingPlanName;
    private final Long scalingPlanVersion;

    private DeleteScalingPlanRequest(BuilderImpl builder) {
        super(builder);
        this.scalingPlanName = builder.scalingPlanName;
        this.scalingPlanVersion = builder.scalingPlanVersion;
    }

    public final String scalingPlanName() {
        return this.scalingPlanName;
    }

    public final Long scalingPlanVersion() {
        return this.scalingPlanVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPlanVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteScalingPlanRequest)) {
            return false;
        }
        DeleteScalingPlanRequest other = (DeleteScalingPlanRequest)((Object)obj);
        return Objects.equals(this.scalingPlanName(), other.scalingPlanName()) && Objects.equals(this.scalingPlanVersion(), other.scalingPlanVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteScalingPlanRequest").add("ScalingPlanName", (Object)this.scalingPlanName()).add("ScalingPlanVersion", (Object)this.scalingPlanVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingPlanName": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanName()));
            }
            case "ScalingPlanVersion": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScalingPlanName", SCALING_PLAN_NAME_FIELD);
        map.put("ScalingPlanVersion", SCALING_PLAN_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteScalingPlanRequest, T> g) {
        return obj -> g.apply((DeleteScalingPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingPlansRequest.BuilderImpl
    implements Builder {
        private String scalingPlanName;
        private Long scalingPlanVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteScalingPlanRequest model) {
            super(model);
            this.scalingPlanName(model.scalingPlanName);
            this.scalingPlanVersion(model.scalingPlanVersion);
        }

        public final String getScalingPlanName() {
            return this.scalingPlanName;
        }

        public final void setScalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
        }

        @Override
        public final Builder scalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
            return this;
        }

        public final Long getScalingPlanVersion() {
            return this.scalingPlanVersion;
        }

        public final void setScalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
        }

        @Override
        public final Builder scalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteScalingPlanRequest build() {
            return new DeleteScalingPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AutoScalingPlansRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteScalingPlanRequest> {
        public Builder scalingPlanName(String var1);

        public Builder scalingPlanVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

