/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscalingplans.model.ApplicationSource;
import software.amazon.awssdk.services.autoscalingplans.model.ApplicationSourcesCopier;
import software.amazon.awssdk.services.autoscalingplans.model.AutoScalingPlansRequest;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingPlansRequest
extends AutoScalingPlansRequest
implements ToCopyableBuilder<Builder, DescribeScalingPlansRequest> {
    private static final SdkField<List<String>> SCALING_PLAN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScalingPlanNames").getter(DescribeScalingPlansRequest.getter(DescribeScalingPlansRequest::scalingPlanNames)).setter(DescribeScalingPlansRequest.setter(Builder::scalingPlanNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> SCALING_PLAN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ScalingPlanVersion").getter(DescribeScalingPlansRequest.getter(DescribeScalingPlansRequest::scalingPlanVersion)).setter(DescribeScalingPlansRequest.setter(Builder::scalingPlanVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanVersion").build()}).build();
    private static final SdkField<List<ApplicationSource>> APPLICATION_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationSources").getter(DescribeScalingPlansRequest.getter(DescribeScalingPlansRequest::applicationSources)).setter(DescribeScalingPlansRequest.setter(Builder::applicationSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeScalingPlansRequest.getter(DescribeScalingPlansRequest::maxResults)).setter(DescribeScalingPlansRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScalingPlansRequest.getter(DescribeScalingPlansRequest::nextToken)).setter(DescribeScalingPlansRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_NAMES_FIELD, SCALING_PLAN_VERSION_FIELD, APPLICATION_SOURCES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeScalingPlansRequest.memberNameToFieldInitializer();
    private final List<String> scalingPlanNames;
    private final Long scalingPlanVersion;
    private final List<ApplicationSource> applicationSources;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeScalingPlansRequest(BuilderImpl builder) {
        super(builder);
        this.scalingPlanNames = builder.scalingPlanNames;
        this.scalingPlanVersion = builder.scalingPlanVersion;
        this.applicationSources = builder.applicationSources;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScalingPlanNames() {
        return this.scalingPlanNames != null && !(this.scalingPlanNames instanceof SdkAutoConstructList);
    }

    public final List<String> scalingPlanNames() {
        return this.scalingPlanNames;
    }

    public final Long scalingPlanVersion() {
        return this.scalingPlanVersion;
    }

    public final boolean hasApplicationSources() {
        return this.applicationSources != null && !(this.applicationSources instanceof SdkAutoConstructList);
    }

    public final List<ApplicationSource> applicationSources() {
        return this.applicationSources;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalingPlanNames() ? this.scalingPlanNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPlanVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationSources() ? this.applicationSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPlansRequest)) {
            return false;
        }
        DescribeScalingPlansRequest other = (DescribeScalingPlansRequest)((Object)obj);
        return this.hasScalingPlanNames() == other.hasScalingPlanNames() && Objects.equals(this.scalingPlanNames(), other.scalingPlanNames()) && Objects.equals(this.scalingPlanVersion(), other.scalingPlanVersion()) && this.hasApplicationSources() == other.hasApplicationSources() && Objects.equals(this.applicationSources(), other.applicationSources()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScalingPlansRequest").add("ScalingPlanNames", this.hasScalingPlanNames() ? this.scalingPlanNames() : null).add("ScalingPlanVersion", (Object)this.scalingPlanVersion()).add("ApplicationSources", this.hasApplicationSources() ? this.applicationSources() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingPlanNames": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanNames()));
            }
            case "ScalingPlanVersion": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanVersion()));
            }
            case "ApplicationSources": {
                return Optional.ofNullable(clazz.cast(this.applicationSources()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScalingPlanNames", SCALING_PLAN_NAMES_FIELD);
        map.put("ScalingPlanVersion", SCALING_PLAN_VERSION_FIELD);
        map.put("ApplicationSources", APPLICATION_SOURCES_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingPlansRequest, T> g) {
        return obj -> g.apply((DescribeScalingPlansRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingPlansRequest.BuilderImpl
    implements Builder {
        private List<String> scalingPlanNames = DefaultSdkAutoConstructList.getInstance();
        private Long scalingPlanVersion;
        private List<ApplicationSource> applicationSources = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPlansRequest model) {
            super(model);
            this.scalingPlanNames(model.scalingPlanNames);
            this.scalingPlanVersion(model.scalingPlanVersion);
            this.applicationSources(model.applicationSources);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getScalingPlanNames() {
            if (this.scalingPlanNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scalingPlanNames;
        }

        public final void setScalingPlanNames(Collection<String> scalingPlanNames) {
            this.scalingPlanNames = ScalingPlanNamesCopier.copy(scalingPlanNames);
        }

        @Override
        public final Builder scalingPlanNames(Collection<String> scalingPlanNames) {
            this.scalingPlanNames = ScalingPlanNamesCopier.copy(scalingPlanNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPlanNames(String ... scalingPlanNames) {
            this.scalingPlanNames(Arrays.asList(scalingPlanNames));
            return this;
        }

        public final Long getScalingPlanVersion() {
            return this.scalingPlanVersion;
        }

        public final void setScalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
        }

        @Override
        public final Builder scalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
            return this;
        }

        public final List<ApplicationSource.Builder> getApplicationSources() {
            List<ApplicationSource.Builder> result = ApplicationSourcesCopier.copyToBuilder(this.applicationSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationSources(Collection<ApplicationSource.BuilderImpl> applicationSources) {
            this.applicationSources = ApplicationSourcesCopier.copyFromBuilder(applicationSources);
        }

        @Override
        public final Builder applicationSources(Collection<ApplicationSource> applicationSources) {
            this.applicationSources = ApplicationSourcesCopier.copy(applicationSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationSources(ApplicationSource ... applicationSources) {
            this.applicationSources(Arrays.asList(applicationSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationSources(Consumer<ApplicationSource.Builder> ... applicationSources) {
            this.applicationSources(Stream.of(applicationSources).map(c -> (ApplicationSource)((ApplicationSource.Builder)ApplicationSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScalingPlansRequest build() {
            return new DescribeScalingPlansRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AutoScalingPlansRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingPlansRequest> {
        public Builder scalingPlanNames(Collection<String> var1);

        public Builder scalingPlanNames(String ... var1);

        public Builder scalingPlanVersion(Long var1);

        public Builder applicationSources(Collection<ApplicationSource> var1);

        public Builder applicationSources(ApplicationSource ... var1);

        public Builder applicationSources(Consumer<ApplicationSource.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

