/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscalingplans.model.AutoScalingPlansResponse;
import software.amazon.awssdk.services.autoscalingplans.model.Datapoint;
import software.amazon.awssdk.services.autoscalingplans.model.DatapointsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetScalingPlanResourceForecastDataResponse
extends AutoScalingPlansResponse
implements ToCopyableBuilder<Builder, GetScalingPlanResourceForecastDataResponse> {
    private static final SdkField<List<Datapoint>> DATAPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Datapoints").getter(GetScalingPlanResourceForecastDataResponse.getter(GetScalingPlanResourceForecastDataResponse::datapoints)).setter(GetScalingPlanResourceForecastDataResponse.setter(Builder::datapoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datapoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Datapoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATAPOINTS_FIELD));
    private final List<Datapoint> datapoints;

    private GetScalingPlanResourceForecastDataResponse(BuilderImpl builder) {
        super(builder);
        this.datapoints = builder.datapoints;
    }

    public final boolean hasDatapoints() {
        return this.datapoints != null && !(this.datapoints instanceof SdkAutoConstructList);
    }

    public final List<Datapoint> datapoints() {
        return this.datapoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatapoints() ? this.datapoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScalingPlanResourceForecastDataResponse)) {
            return false;
        }
        GetScalingPlanResourceForecastDataResponse other = (GetScalingPlanResourceForecastDataResponse)((Object)obj);
        return this.hasDatapoints() == other.hasDatapoints() && Objects.equals(this.datapoints(), other.datapoints());
    }

    public final String toString() {
        return ToString.builder((String)"GetScalingPlanResourceForecastDataResponse").add("Datapoints", this.hasDatapoints() ? this.datapoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Datapoints": {
                return Optional.ofNullable(clazz.cast(this.datapoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetScalingPlanResourceForecastDataResponse, T> g) {
        return obj -> g.apply((GetScalingPlanResourceForecastDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingPlansResponse.BuilderImpl
    implements Builder {
        private List<Datapoint> datapoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetScalingPlanResourceForecastDataResponse model) {
            super(model);
            this.datapoints(model.datapoints);
        }

        public final List<Datapoint.Builder> getDatapoints() {
            List<Datapoint.Builder> result = DatapointsCopier.copyToBuilder(this.datapoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatapoints(Collection<Datapoint.BuilderImpl> datapoints) {
            this.datapoints = DatapointsCopier.copyFromBuilder(datapoints);
        }

        @Override
        public final Builder datapoints(Collection<Datapoint> datapoints) {
            this.datapoints = DatapointsCopier.copy(datapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Datapoint ... datapoints) {
            this.datapoints(Arrays.asList(datapoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Consumer<Datapoint.Builder> ... datapoints) {
            this.datapoints(Stream.of(datapoints).map(c -> (Datapoint)((Datapoint.Builder)Datapoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetScalingPlanResourceForecastDataResponse build() {
            return new GetScalingPlanResourceForecastDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingPlansResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetScalingPlanResourceForecastDataResponse> {
        public Builder datapoints(Collection<Datapoint> var1);

        public Builder datapoints(Datapoint ... var1);

        public Builder datapoints(Consumer<Datapoint.Builder> ... var1);
    }
}

