/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScalingStatusCode {
    INACTIVE("Inactive"),
    PARTIALLY_ACTIVE("PartiallyActive"),
    ACTIVE("Active"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScalingStatusCode> VALUE_MAP;
    private final String value;

    private ScalingStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalingStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalingStatusCode> knownValues() {
        EnumSet<ScalingStatusCode> knownValues = EnumSet.allOf(ScalingStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScalingStatusCode.class, ScalingStatusCode::toString);
    }
}

