/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.autoscalingplans.AutoScalingPlansAsyncClient;
import software.amazon.awssdk.services.autoscalingplans.AutoScalingPlansAsyncClientBuilder;
import software.amazon.awssdk.services.autoscalingplans.AutoScalingPlansServiceClientConfiguration;
import software.amazon.awssdk.services.autoscalingplans.DefaultAutoScalingPlansAsyncClient;
import software.amazon.awssdk.services.autoscalingplans.DefaultAutoScalingPlansBaseClientBuilder;
import software.amazon.awssdk.services.autoscalingplans.endpoints.AutoScalingPlansEndpointProvider;

@SdkInternalApi
final class DefaultAutoScalingPlansAsyncClientBuilder
extends DefaultAutoScalingPlansBaseClientBuilder<AutoScalingPlansAsyncClientBuilder, AutoScalingPlansAsyncClient>
implements AutoScalingPlansAsyncClientBuilder {
    DefaultAutoScalingPlansAsyncClientBuilder() {
    }

    @Override
    public DefaultAutoScalingPlansAsyncClientBuilder endpointProvider(AutoScalingPlansEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AutoScalingPlansAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAutoScalingPlansAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AutoScalingPlansServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAutoScalingPlansAsyncClient client = new DefaultAutoScalingPlansAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AutoScalingPlansServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AutoScalingPlansServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

