/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ScalableDimension {
    AUTOSCALING_AUTO_SCALING_GROUP_DESIRED_CAPACITY("autoscaling:autoScalingGroup:DesiredCapacity"),
    ECS_SERVICE_DESIRED_COUNT("ecs:service:DesiredCount"),
    EC2_SPOT_FLEET_REQUEST_TARGET_CAPACITY("ec2:spot-fleet-request:TargetCapacity"),
    RDS_CLUSTER_READ_REPLICA_COUNT("rds:cluster:ReadReplicaCount"),
    DYNAMODB_TABLE_READ_CAPACITY_UNITS("dynamodb:table:ReadCapacityUnits"),
    DYNAMODB_TABLE_WRITE_CAPACITY_UNITS("dynamodb:table:WriteCapacityUnits"),
    DYNAMODB_INDEX_READ_CAPACITY_UNITS("dynamodb:index:ReadCapacityUnits"),
    DYNAMODB_INDEX_WRITE_CAPACITY_UNITS("dynamodb:index:WriteCapacityUnits"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ScalableDimension(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalableDimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ScalableDimension.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalableDimension> knownValues() {
        return Stream.of(ScalableDimension.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

