/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScalingPlanResourcesResponse extends AutoScalingPlansResponse implements
        ToCopyableBuilder<DescribeScalingPlanResourcesResponse.Builder, DescribeScalingPlanResourcesResponse> {
    private static final SdkField<List<ScalingPlanResource>> SCALING_PLAN_RESOURCES_FIELD = SdkField
            .<List<ScalingPlanResource>> builder(MarshallingType.LIST)
            .memberName("ScalingPlanResources")
            .getter(getter(DescribeScalingPlanResourcesResponse::scalingPlanResources))
            .setter(setter(Builder::scalingPlanResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScalingPlanResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScalingPlanResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeScalingPlanResourcesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_RESOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ScalingPlanResource> scalingPlanResources;

    private final String nextToken;

    private DescribeScalingPlanResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.scalingPlanResources = builder.scalingPlanResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ScalingPlanResources property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasScalingPlanResources() {
        return scalingPlanResources != null && !(scalingPlanResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the scalable resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScalingPlanResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the scalable resources.
     */
    public final List<ScalingPlanResource> scalingPlanResources() {
        return scalingPlanResources;
    }

    /**
     * <p>
     * The token required to get the next set of results. This value is <code>null</code> if there are no more results
     * to return.
     * </p>
     * 
     * @return The token required to get the next set of results. This value is <code>null</code> if there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScalingPlanResources() ? scalingPlanResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPlanResourcesResponse)) {
            return false;
        }
        DescribeScalingPlanResourcesResponse other = (DescribeScalingPlanResourcesResponse) obj;
        return hasScalingPlanResources() == other.hasScalingPlanResources()
                && Objects.equals(scalingPlanResources(), other.scalingPlanResources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScalingPlanResourcesResponse")
                .add("ScalingPlanResources", hasScalingPlanResources() ? scalingPlanResources() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingPlanResources":
            return Optional.ofNullable(clazz.cast(scalingPlanResources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingPlanResourcesResponse, T> g) {
        return obj -> g.apply((DescribeScalingPlanResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingPlansResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScalingPlanResourcesResponse> {
        /**
         * <p>
         * Information about the scalable resources.
         * </p>
         * 
         * @param scalingPlanResources
         *        Information about the scalable resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanResources(Collection<ScalingPlanResource> scalingPlanResources);

        /**
         * <p>
         * Information about the scalable resources.
         * </p>
         * 
         * @param scalingPlanResources
         *        Information about the scalable resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanResources(ScalingPlanResource... scalingPlanResources);

        /**
         * <p>
         * Information about the scalable resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScalingPlanResource>.Builder} avoiding the
         * need to create one manually via {@link List<ScalingPlanResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScalingPlanResource>.Builder#build()} is called immediately
         * and its result is passed to {@link #scalingPlanResources(List<ScalingPlanResource>)}.
         * 
         * @param scalingPlanResources
         *        a consumer that will call methods on {@link List<ScalingPlanResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingPlanResources(List<ScalingPlanResource>)
         */
        Builder scalingPlanResources(Consumer<ScalingPlanResource.Builder>... scalingPlanResources);

        /**
         * <p>
         * The token required to get the next set of results. This value is <code>null</code> if there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to get the next set of results. This value is <code>null</code> if there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingPlansResponse.BuilderImpl implements Builder {
        private List<ScalingPlanResource> scalingPlanResources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPlanResourcesResponse model) {
            super(model);
            scalingPlanResources(model.scalingPlanResources);
            nextToken(model.nextToken);
        }

        public final Collection<ScalingPlanResource.Builder> getScalingPlanResources() {
            if (scalingPlanResources instanceof SdkAutoConstructList) {
                return null;
            }
            return scalingPlanResources != null ? scalingPlanResources.stream().map(ScalingPlanResource::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scalingPlanResources(Collection<ScalingPlanResource> scalingPlanResources) {
            this.scalingPlanResources = ScalingPlanResourcesCopier.copy(scalingPlanResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPlanResources(ScalingPlanResource... scalingPlanResources) {
            scalingPlanResources(Arrays.asList(scalingPlanResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPlanResources(Consumer<ScalingPlanResource.Builder>... scalingPlanResources) {
            scalingPlanResources(Stream.of(scalingPlanResources).map(c -> ScalingPlanResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setScalingPlanResources(Collection<ScalingPlanResource.BuilderImpl> scalingPlanResources) {
            this.scalingPlanResources = ScalingPlanResourcesCopier.copyFromBuilder(scalingPlanResources);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScalingPlanResourcesResponse build() {
            return new DescribeScalingPlanResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
