/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LoadMetricType {
    ASG_TOTAL_CPU_UTILIZATION("ASGTotalCPUUtilization"),
    ASG_TOTAL_NETWORK_IN("ASGTotalNetworkIn"),
    ASG_TOTAL_NETWORK_OUT("ASGTotalNetworkOut"),
    ALB_TARGET_GROUP_REQUEST_COUNT("ALBTargetGroupRequestCount"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LoadMetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LoadMetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LoadMetricType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LoadMetricType> knownValues() {
        return Stream.of(LoadMetricType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

