/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscalingplans.model.ApplicationSource;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingInstructionsCopier;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingPlan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingPlan> {
    private static final SdkField<String> SCALING_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingPlanName").getter(ScalingPlan.getter(ScalingPlan::scalingPlanName)).setter(ScalingPlan.setter(Builder::scalingPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanName").build()}).build();
    private static final SdkField<Long> SCALING_PLAN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ScalingPlanVersion").getter(ScalingPlan.getter(ScalingPlan::scalingPlanVersion)).setter(ScalingPlan.setter(Builder::scalingPlanVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanVersion").build()}).build();
    private static final SdkField<ApplicationSource> APPLICATION_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSource").getter(ScalingPlan.getter(ScalingPlan::applicationSource)).setter(ScalingPlan.setter(Builder::applicationSource)).constructor(ApplicationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSource").build()}).build();
    private static final SdkField<List<ScalingInstruction>> SCALING_INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScalingInstructions").getter(ScalingPlan.getter(ScalingPlan::scalingInstructions)).setter(ScalingPlan.setter(Builder::scalingInstructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingInstructions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingInstruction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(ScalingPlan.getter(ScalingPlan::statusCodeAsString)).setter(ScalingPlan.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ScalingPlan.getter(ScalingPlan::statusMessage)).setter(ScalingPlan.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> STATUS_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StatusStartTime").getter(ScalingPlan.getter(ScalingPlan::statusStartTime)).setter(ScalingPlan.setter(Builder::statusStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusStartTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ScalingPlan.getter(ScalingPlan::creationTime)).setter(ScalingPlan.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_NAME_FIELD, SCALING_PLAN_VERSION_FIELD, APPLICATION_SOURCE_FIELD, SCALING_INSTRUCTIONS_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, STATUS_START_TIME_FIELD, CREATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scalingPlanName;
    private final Long scalingPlanVersion;
    private final ApplicationSource applicationSource;
    private final List<ScalingInstruction> scalingInstructions;
    private final String statusCode;
    private final String statusMessage;
    private final Instant statusStartTime;
    private final Instant creationTime;

    private ScalingPlan(BuilderImpl builder) {
        this.scalingPlanName = builder.scalingPlanName;
        this.scalingPlanVersion = builder.scalingPlanVersion;
        this.applicationSource = builder.applicationSource;
        this.scalingInstructions = builder.scalingInstructions;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.statusStartTime = builder.statusStartTime;
        this.creationTime = builder.creationTime;
    }

    public String scalingPlanName() {
        return this.scalingPlanName;
    }

    public Long scalingPlanVersion() {
        return this.scalingPlanVersion;
    }

    public ApplicationSource applicationSource() {
        return this.applicationSource;
    }

    public boolean hasScalingInstructions() {
        return this.scalingInstructions != null && !(this.scalingInstructions instanceof SdkAutoConstructList);
    }

    public List<ScalingInstruction> scalingInstructions() {
        return this.scalingInstructions;
    }

    public ScalingPlanStatusCode statusCode() {
        return ScalingPlanStatusCode.fromValue(this.statusCode);
    }

    public String statusCodeAsString() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Instant statusStartTime() {
        return this.statusStartTime;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPlanVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalingInstructions() ? this.scalingInstructions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPlan)) {
            return false;
        }
        ScalingPlan other = (ScalingPlan)obj;
        return Objects.equals(this.scalingPlanName(), other.scalingPlanName()) && Objects.equals(this.scalingPlanVersion(), other.scalingPlanVersion()) && Objects.equals(this.applicationSource(), other.applicationSource()) && this.hasScalingInstructions() == other.hasScalingInstructions() && Objects.equals(this.scalingInstructions(), other.scalingInstructions()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.statusStartTime(), other.statusStartTime()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"ScalingPlan").add("ScalingPlanName", (Object)this.scalingPlanName()).add("ScalingPlanVersion", (Object)this.scalingPlanVersion()).add("ApplicationSource", (Object)this.applicationSource()).add("ScalingInstructions", this.hasScalingInstructions() ? this.scalingInstructions() : null).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StatusStartTime", (Object)this.statusStartTime()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingPlanName": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanName()));
            }
            case "ScalingPlanVersion": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanVersion()));
            }
            case "ApplicationSource": {
                return Optional.ofNullable(clazz.cast(this.applicationSource()));
            }
            case "ScalingInstructions": {
                return Optional.ofNullable(clazz.cast(this.scalingInstructions()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "StatusStartTime": {
                return Optional.ofNullable(clazz.cast(this.statusStartTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPlan, T> g) {
        return obj -> g.apply((ScalingPlan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scalingPlanName;
        private Long scalingPlanVersion;
        private ApplicationSource applicationSource;
        private List<ScalingInstruction> scalingInstructions = DefaultSdkAutoConstructList.getInstance();
        private String statusCode;
        private String statusMessage;
        private Instant statusStartTime;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPlan model) {
            this.scalingPlanName(model.scalingPlanName);
            this.scalingPlanVersion(model.scalingPlanVersion);
            this.applicationSource(model.applicationSource);
            this.scalingInstructions(model.scalingInstructions);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
            this.statusStartTime(model.statusStartTime);
            this.creationTime(model.creationTime);
        }

        public final String getScalingPlanName() {
            return this.scalingPlanName;
        }

        @Override
        public final Builder scalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
            return this;
        }

        public final void setScalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
        }

        public final Long getScalingPlanVersion() {
            return this.scalingPlanVersion;
        }

        @Override
        public final Builder scalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
            return this;
        }

        public final void setScalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
        }

        public final ApplicationSource.Builder getApplicationSource() {
            return this.applicationSource != null ? this.applicationSource.toBuilder() : null;
        }

        @Override
        public final Builder applicationSource(ApplicationSource applicationSource) {
            this.applicationSource = applicationSource;
            return this;
        }

        public final void setApplicationSource(ApplicationSource.BuilderImpl applicationSource) {
            this.applicationSource = applicationSource != null ? applicationSource.build() : null;
        }

        public final Collection<ScalingInstruction.Builder> getScalingInstructions() {
            if (this.scalingInstructions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scalingInstructions != null ? (Collection)this.scalingInstructions.stream().map(ScalingInstruction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scalingInstructions(Collection<ScalingInstruction> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copy(scalingInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(ScalingInstruction ... scalingInstructions) {
            this.scalingInstructions(Arrays.asList(scalingInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(Consumer<ScalingInstruction.Builder> ... scalingInstructions) {
            this.scalingInstructions(Stream.of(scalingInstructions).map(c -> (ScalingInstruction)((ScalingInstruction.Builder)ScalingInstruction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScalingInstructions(Collection<ScalingInstruction.BuilderImpl> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copyFromBuilder(scalingInstructions);
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ScalingPlanStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getStatusStartTime() {
            return this.statusStartTime;
        }

        @Override
        public final Builder statusStartTime(Instant statusStartTime) {
            this.statusStartTime = statusStartTime;
            return this;
        }

        public final void setStatusStartTime(Instant statusStartTime) {
            this.statusStartTime = statusStartTime;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public ScalingPlan build() {
            return new ScalingPlan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingPlan> {
        public Builder scalingPlanName(String var1);

        public Builder scalingPlanVersion(Long var1);

        public Builder applicationSource(ApplicationSource var1);

        default public Builder applicationSource(Consumer<ApplicationSource.Builder> applicationSource) {
            return this.applicationSource((ApplicationSource)((ApplicationSource.Builder)ApplicationSource.builder().applyMutation(applicationSource)).build());
        }

        public Builder scalingInstructions(Collection<ScalingInstruction> var1);

        public Builder scalingInstructions(ScalingInstruction ... var1);

        public Builder scalingInstructions(Consumer<ScalingInstruction.Builder> ... var1);

        public Builder statusCode(String var1);

        public Builder statusCode(ScalingPlanStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder statusStartTime(Instant var1);

        public Builder creationTime(Instant var1);
    }
}

