/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscalingplans.model.CustomizedScalingMetricSpecification;
import software.amazon.awssdk.services.autoscalingplans.model.PredefinedScalingMetricSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetTrackingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetTrackingConfiguration> {
    private static final SdkField<PredefinedScalingMetricSpecification> PREDEFINED_SCALING_METRIC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TargetTrackingConfiguration.getter(TargetTrackingConfiguration::predefinedScalingMetricSpecification)).setter(TargetTrackingConfiguration.setter(Builder::predefinedScalingMetricSpecification)).constructor(PredefinedScalingMetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedScalingMetricSpecification").build()}).build();
    private static final SdkField<CustomizedScalingMetricSpecification> CUSTOMIZED_SCALING_METRIC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TargetTrackingConfiguration.getter(TargetTrackingConfiguration::customizedScalingMetricSpecification)).setter(TargetTrackingConfiguration.setter(Builder::customizedScalingMetricSpecification)).constructor(CustomizedScalingMetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomizedScalingMetricSpecification").build()}).build();
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(TargetTrackingConfiguration.getter(TargetTrackingConfiguration::targetValue)).setter(TargetTrackingConfiguration.setter(Builder::targetValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()}).build();
    private static final SdkField<Boolean> DISABLE_SCALE_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TargetTrackingConfiguration.getter(TargetTrackingConfiguration::disableScaleIn)).setter(TargetTrackingConfiguration.setter(Builder::disableScaleIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableScaleIn").build()}).build();
    private static final SdkField<Integer> SCALE_OUT_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TargetTrackingConfiguration.getter(TargetTrackingConfiguration::scaleOutCooldown)).setter(TargetTrackingConfiguration.setter(Builder::scaleOutCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleOutCooldown").build()}).build();
    private static final SdkField<Integer> SCALE_IN_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TargetTrackingConfiguration.getter(TargetTrackingConfiguration::scaleInCooldown)).setter(TargetTrackingConfiguration.setter(Builder::scaleInCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleInCooldown").build()}).build();
    private static final SdkField<Integer> ESTIMATED_INSTANCE_WARMUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TargetTrackingConfiguration.getter(TargetTrackingConfiguration::estimatedInstanceWarmup)).setter(TargetTrackingConfiguration.setter(Builder::estimatedInstanceWarmup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedInstanceWarmup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_SCALING_METRIC_SPECIFICATION_FIELD, CUSTOMIZED_SCALING_METRIC_SPECIFICATION_FIELD, TARGET_VALUE_FIELD, DISABLE_SCALE_IN_FIELD, SCALE_OUT_COOLDOWN_FIELD, SCALE_IN_COOLDOWN_FIELD, ESTIMATED_INSTANCE_WARMUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final PredefinedScalingMetricSpecification predefinedScalingMetricSpecification;
    private final CustomizedScalingMetricSpecification customizedScalingMetricSpecification;
    private final Double targetValue;
    private final Boolean disableScaleIn;
    private final Integer scaleOutCooldown;
    private final Integer scaleInCooldown;
    private final Integer estimatedInstanceWarmup;

    private TargetTrackingConfiguration(BuilderImpl builder) {
        this.predefinedScalingMetricSpecification = builder.predefinedScalingMetricSpecification;
        this.customizedScalingMetricSpecification = builder.customizedScalingMetricSpecification;
        this.targetValue = builder.targetValue;
        this.disableScaleIn = builder.disableScaleIn;
        this.scaleOutCooldown = builder.scaleOutCooldown;
        this.scaleInCooldown = builder.scaleInCooldown;
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
    }

    public PredefinedScalingMetricSpecification predefinedScalingMetricSpecification() {
        return this.predefinedScalingMetricSpecification;
    }

    public CustomizedScalingMetricSpecification customizedScalingMetricSpecification() {
        return this.customizedScalingMetricSpecification;
    }

    public Double targetValue() {
        return this.targetValue;
    }

    public Boolean disableScaleIn() {
        return this.disableScaleIn;
    }

    public Integer scaleOutCooldown() {
        return this.scaleOutCooldown;
    }

    public Integer scaleInCooldown() {
        return this.scaleInCooldown;
    }

    public Integer estimatedInstanceWarmup() {
        return this.estimatedInstanceWarmup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.predefinedScalingMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizedScalingMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleOutCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleInCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedInstanceWarmup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingConfiguration)) {
            return false;
        }
        TargetTrackingConfiguration other = (TargetTrackingConfiguration)obj;
        return Objects.equals(this.predefinedScalingMetricSpecification(), other.predefinedScalingMetricSpecification()) && Objects.equals(this.customizedScalingMetricSpecification(), other.customizedScalingMetricSpecification()) && Objects.equals(this.targetValue(), other.targetValue()) && Objects.equals(this.disableScaleIn(), other.disableScaleIn()) && Objects.equals(this.scaleOutCooldown(), other.scaleOutCooldown()) && Objects.equals(this.scaleInCooldown(), other.scaleInCooldown()) && Objects.equals(this.estimatedInstanceWarmup(), other.estimatedInstanceWarmup());
    }

    public String toString() {
        return ToString.builder((String)"TargetTrackingConfiguration").add("PredefinedScalingMetricSpecification", (Object)this.predefinedScalingMetricSpecification()).add("CustomizedScalingMetricSpecification", (Object)this.customizedScalingMetricSpecification()).add("TargetValue", (Object)this.targetValue()).add("DisableScaleIn", (Object)this.disableScaleIn()).add("ScaleOutCooldown", (Object)this.scaleOutCooldown()).add("ScaleInCooldown", (Object)this.scaleInCooldown()).add("EstimatedInstanceWarmup", (Object)this.estimatedInstanceWarmup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredefinedScalingMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.predefinedScalingMetricSpecification()));
            }
            case "CustomizedScalingMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.customizedScalingMetricSpecification()));
            }
            case "TargetValue": {
                return Optional.ofNullable(clazz.cast(this.targetValue()));
            }
            case "DisableScaleIn": {
                return Optional.ofNullable(clazz.cast(this.disableScaleIn()));
            }
            case "ScaleOutCooldown": {
                return Optional.ofNullable(clazz.cast(this.scaleOutCooldown()));
            }
            case "ScaleInCooldown": {
                return Optional.ofNullable(clazz.cast(this.scaleInCooldown()));
            }
            case "EstimatedInstanceWarmup": {
                return Optional.ofNullable(clazz.cast(this.estimatedInstanceWarmup()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingConfiguration, T> g) {
        return obj -> g.apply((TargetTrackingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PredefinedScalingMetricSpecification predefinedScalingMetricSpecification;
        private CustomizedScalingMetricSpecification customizedScalingMetricSpecification;
        private Double targetValue;
        private Boolean disableScaleIn;
        private Integer scaleOutCooldown;
        private Integer scaleInCooldown;
        private Integer estimatedInstanceWarmup;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingConfiguration model) {
            this.predefinedScalingMetricSpecification(model.predefinedScalingMetricSpecification);
            this.customizedScalingMetricSpecification(model.customizedScalingMetricSpecification);
            this.targetValue(model.targetValue);
            this.disableScaleIn(model.disableScaleIn);
            this.scaleOutCooldown(model.scaleOutCooldown);
            this.scaleInCooldown(model.scaleInCooldown);
            this.estimatedInstanceWarmup(model.estimatedInstanceWarmup);
        }

        public final PredefinedScalingMetricSpecification.Builder getPredefinedScalingMetricSpecification() {
            return this.predefinedScalingMetricSpecification != null ? this.predefinedScalingMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder predefinedScalingMetricSpecification(PredefinedScalingMetricSpecification predefinedScalingMetricSpecification) {
            this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
            return this;
        }

        public final void setPredefinedScalingMetricSpecification(PredefinedScalingMetricSpecification.BuilderImpl predefinedScalingMetricSpecification) {
            this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification != null ? predefinedScalingMetricSpecification.build() : null;
        }

        public final CustomizedScalingMetricSpecification.Builder getCustomizedScalingMetricSpecification() {
            return this.customizedScalingMetricSpecification != null ? this.customizedScalingMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder customizedScalingMetricSpecification(CustomizedScalingMetricSpecification customizedScalingMetricSpecification) {
            this.customizedScalingMetricSpecification = customizedScalingMetricSpecification;
            return this;
        }

        public final void setCustomizedScalingMetricSpecification(CustomizedScalingMetricSpecification.BuilderImpl customizedScalingMetricSpecification) {
            this.customizedScalingMetricSpecification = customizedScalingMetricSpecification != null ? customizedScalingMetricSpecification.build() : null;
        }

        public final Double getTargetValue() {
            return this.targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        public final Boolean getDisableScaleIn() {
            return this.disableScaleIn;
        }

        @Override
        public final Builder disableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        public final void setDisableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
        }

        public final Integer getScaleOutCooldown() {
            return this.scaleOutCooldown;
        }

        @Override
        public final Builder scaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        public final void setScaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
        }

        public final Integer getScaleInCooldown() {
            return this.scaleInCooldown;
        }

        @Override
        public final Builder scaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        public final void setScaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
        }

        public final Integer getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        public TargetTrackingConfiguration build() {
            return new TargetTrackingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetTrackingConfiguration> {
        public Builder predefinedScalingMetricSpecification(PredefinedScalingMetricSpecification var1);

        default public Builder predefinedScalingMetricSpecification(Consumer<PredefinedScalingMetricSpecification.Builder> predefinedScalingMetricSpecification) {
            return this.predefinedScalingMetricSpecification((PredefinedScalingMetricSpecification)((PredefinedScalingMetricSpecification.Builder)PredefinedScalingMetricSpecification.builder().applyMutation(predefinedScalingMetricSpecification)).build());
        }

        public Builder customizedScalingMetricSpecification(CustomizedScalingMetricSpecification var1);

        default public Builder customizedScalingMetricSpecification(Consumer<CustomizedScalingMetricSpecification.Builder> customizedScalingMetricSpecification) {
            return this.customizedScalingMetricSpecification((CustomizedScalingMetricSpecification)((CustomizedScalingMetricSpecification.Builder)CustomizedScalingMetricSpecification.builder().applyMutation(customizedScalingMetricSpecification)).build());
        }

        public Builder targetValue(Double var1);

        public Builder disableScaleIn(Boolean var1);

        public Builder scaleOutCooldown(Integer var1);

        public Builder scaleInCooldown(Integer var1);

        public Builder estimatedInstanceWarmup(Integer var1);
    }
}

