/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscalingplans.model.PolicyType;
import software.amazon.awssdk.services.autoscalingplans.model.TargetTrackingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingPolicy> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingPolicy.getter(ScalingPolicy::policyName)).setter(ScalingPolicy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingPolicy.getter(ScalingPolicy::policyTypeAsString)).setter(ScalingPolicy.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<TargetTrackingConfiguration> TARGET_TRACKING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ScalingPolicy.getter(ScalingPolicy::targetTrackingConfiguration)).setter(ScalingPolicy.setter(Builder::targetTrackingConfiguration)).constructor(TargetTrackingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, POLICY_TYPE_FIELD, TARGET_TRACKING_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyName;
    private final String policyType;
    private final TargetTrackingConfiguration targetTrackingConfiguration;

    private ScalingPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyType = builder.policyType;
        this.targetTrackingConfiguration = builder.targetTrackingConfiguration;
    }

    public String policyName() {
        return this.policyName;
    }

    public PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public String policyTypeAsString() {
        return this.policyType;
    }

    public TargetTrackingConfiguration targetTrackingConfiguration() {
        return this.targetTrackingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTrackingConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.targetTrackingConfiguration(), other.targetTrackingConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"ScalingPolicy").add("PolicyName", (Object)this.policyName()).add("PolicyType", (Object)this.policyTypeAsString()).add("TargetTrackingConfiguration", (Object)this.targetTrackingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "TargetTrackingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicy, T> g) {
        return obj -> g.apply((ScalingPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyType;
        private TargetTrackingConfiguration targetTrackingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            this.policyName(model.policyName);
            this.policyType(model.policyType);
            this.targetTrackingConfiguration(model.targetTrackingConfiguration);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final TargetTrackingConfiguration.Builder getTargetTrackingConfiguration() {
            return this.targetTrackingConfiguration != null ? this.targetTrackingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        public final void setTargetTrackingConfiguration(TargetTrackingConfiguration.BuilderImpl targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration != null ? targetTrackingConfiguration.build() : null;
        }

        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingPolicy> {
        public Builder policyName(String var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder targetTrackingConfiguration(TargetTrackingConfiguration var1);

        default public Builder targetTrackingConfiguration(Consumer<TargetTrackingConfiguration.Builder> targetTrackingConfiguration) {
            return this.targetTrackingConfiguration((TargetTrackingConfiguration)((TargetTrackingConfiguration.Builder)TargetTrackingConfiguration.builder().applyMutation(targetTrackingConfiguration)).build());
        }
    }
}

