/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a target tracking configuration to use with AWS Auto Scaling. Used with <a>ScalingInstruction</a> and
 * <a>ScalingPolicy</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetTrackingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetTrackingConfiguration.Builder, TargetTrackingConfiguration> {
    private static final SdkField<PredefinedScalingMetricSpecification> PREDEFINED_SCALING_METRIC_SPECIFICATION_FIELD = SdkField
            .<PredefinedScalingMetricSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(TargetTrackingConfiguration::predefinedScalingMetricSpecification))
            .setter(setter(Builder::predefinedScalingMetricSpecification))
            .constructor(PredefinedScalingMetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PredefinedScalingMetricSpecification").build()).build();

    private static final SdkField<CustomizedScalingMetricSpecification> CUSTOMIZED_SCALING_METRIC_SPECIFICATION_FIELD = SdkField
            .<CustomizedScalingMetricSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(TargetTrackingConfiguration::customizedScalingMetricSpecification))
            .setter(setter(Builder::customizedScalingMetricSpecification))
            .constructor(CustomizedScalingMetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CustomizedScalingMetricSpecification").build()).build();

    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(TargetTrackingConfiguration::targetValue)).setter(setter(Builder::targetValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()).build();

    private static final SdkField<Boolean> DISABLE_SCALE_IN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(TargetTrackingConfiguration::disableScaleIn)).setter(setter(Builder::disableScaleIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableScaleIn").build()).build();

    private static final SdkField<Integer> SCALE_OUT_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TargetTrackingConfiguration::scaleOutCooldown)).setter(setter(Builder::scaleOutCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleOutCooldown").build()).build();

    private static final SdkField<Integer> SCALE_IN_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TargetTrackingConfiguration::scaleInCooldown)).setter(setter(Builder::scaleInCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleInCooldown").build()).build();

    private static final SdkField<Integer> ESTIMATED_INSTANCE_WARMUP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TargetTrackingConfiguration::estimatedInstanceWarmup))
            .setter(setter(Builder::estimatedInstanceWarmup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedInstanceWarmup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREDEFINED_SCALING_METRIC_SPECIFICATION_FIELD, CUSTOMIZED_SCALING_METRIC_SPECIFICATION_FIELD, TARGET_VALUE_FIELD,
            DISABLE_SCALE_IN_FIELD, SCALE_OUT_COOLDOWN_FIELD, SCALE_IN_COOLDOWN_FIELD, ESTIMATED_INSTANCE_WARMUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final PredefinedScalingMetricSpecification predefinedScalingMetricSpecification;

    private final CustomizedScalingMetricSpecification customizedScalingMetricSpecification;

    private final Double targetValue;

    private final Boolean disableScaleIn;

    private final Integer scaleOutCooldown;

    private final Integer scaleInCooldown;

    private final Integer estimatedInstanceWarmup;

    private TargetTrackingConfiguration(BuilderImpl builder) {
        this.predefinedScalingMetricSpecification = builder.predefinedScalingMetricSpecification;
        this.customizedScalingMetricSpecification = builder.customizedScalingMetricSpecification;
        this.targetValue = builder.targetValue;
        this.disableScaleIn = builder.disableScaleIn;
        this.scaleOutCooldown = builder.scaleOutCooldown;
        this.scaleInCooldown = builder.scaleInCooldown;
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
    }

    /**
     * <p>
     * A predefined metric. You can specify either a predefined metric or a customized metric.
     * </p>
     * 
     * @return A predefined metric. You can specify either a predefined metric or a customized metric.
     */
    public PredefinedScalingMetricSpecification predefinedScalingMetricSpecification() {
        return predefinedScalingMetricSpecification;
    }

    /**
     * <p>
     * A customized metric. You can specify either a predefined metric or a customized metric.
     * </p>
     * 
     * @return A customized metric. You can specify either a predefined metric or a customized metric.
     */
    public CustomizedScalingMetricSpecification customizedScalingMetricSpecification() {
        return customizedScalingMetricSpecification;
    }

    /**
     * <p>
     * The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base
     * 2).
     * </p>
     * 
     * @return The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360
     *         (Base 2).
     */
    public Double targetValue() {
        return targetValue;
    }

    /**
     * <p>
     * Indicates whether scale in by the target tracking scaling policy is disabled. If the value is <code>true</code>,
     * scale in is disabled and the target tracking scaling policy doesn't remove capacity from the scalable resource.
     * Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable
     * resource.
     * </p>
     * <p>
     * The default value is <code>false</code>.
     * </p>
     * 
     * @return Indicates whether scale in by the target tracking scaling policy is disabled. If the value is
     *         <code>true</code>, scale in is disabled and the target tracking scaling policy doesn't remove capacity
     *         from the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can
     *         remove capacity from the scalable resource. </p>
     *         <p>
     *         The default value is <code>false</code>.
     */
    public Boolean disableScaleIn() {
        return disableScaleIn;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
     * This value is not used if the scalable resource is an Auto Scaling group.
     * </p>
     * <p>
     * While the cooldown period is in effect, the capacity that has been added by the previous scale-out event that
     * initiated the cooldown is calculated as part of the desired capacity for the next scale out. The intention is to
     * continuously (but not excessively) scale out.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scale-out activity completes before another scale-out activity
     *         can start. This value is not used if the scalable resource is an Auto Scaling group.</p>
     *         <p>
     *         While the cooldown period is in effect, the capacity that has been added by the previous scale-out event
     *         that initiated the cooldown is calculated as part of the desired capacity for the next scale out. The
     *         intention is to continuously (but not excessively) scale out.
     */
    public Integer scaleOutCooldown() {
        return scaleOutCooldown;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
     * This value is not used if the scalable resource is an Auto Scaling group.
     * </p>
     * <p>
     * The cooldown period is used to block subsequent scale in requests until it has expired. The intention is to scale
     * in conservatively to protect your application's availability. However, if another alarm triggers a scale-out
     * policy during the cooldown period after a scale-in, AWS Auto Scaling scales out your scalable target immediately.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scale in activity completes before another scale in activity can
     *         start. This value is not used if the scalable resource is an Auto Scaling group.</p>
     *         <p>
     *         The cooldown period is used to block subsequent scale in requests until it has expired. The intention is
     *         to scale in conservatively to protect your application's availability. However, if another alarm triggers
     *         a scale-out policy during the cooldown period after a scale-in, AWS Auto Scaling scales out your scalable
     *         target immediately.
     */
    public Integer scaleInCooldown() {
        return scaleInCooldown;
    }

    /**
     * <p>
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This
     * value is used only if the resource is an Auto Scaling group.
     * </p>
     * 
     * @return The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     *         This value is used only if the resource is an Auto Scaling group.
     */
    public Integer estimatedInstanceWarmup() {
        return estimatedInstanceWarmup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefinedScalingMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(customizedScalingMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        hashCode = 31 * hashCode + Objects.hashCode(disableScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(scaleOutCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(scaleInCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedInstanceWarmup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingConfiguration)) {
            return false;
        }
        TargetTrackingConfiguration other = (TargetTrackingConfiguration) obj;
        return Objects.equals(predefinedScalingMetricSpecification(), other.predefinedScalingMetricSpecification())
                && Objects.equals(customizedScalingMetricSpecification(), other.customizedScalingMetricSpecification())
                && Objects.equals(targetValue(), other.targetValue()) && Objects.equals(disableScaleIn(), other.disableScaleIn())
                && Objects.equals(scaleOutCooldown(), other.scaleOutCooldown())
                && Objects.equals(scaleInCooldown(), other.scaleInCooldown())
                && Objects.equals(estimatedInstanceWarmup(), other.estimatedInstanceWarmup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TargetTrackingConfiguration")
                .add("PredefinedScalingMetricSpecification", predefinedScalingMetricSpecification())
                .add("CustomizedScalingMetricSpecification", customizedScalingMetricSpecification())
                .add("TargetValue", targetValue()).add("DisableScaleIn", disableScaleIn())
                .add("ScaleOutCooldown", scaleOutCooldown()).add("ScaleInCooldown", scaleInCooldown())
                .add("EstimatedInstanceWarmup", estimatedInstanceWarmup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredefinedScalingMetricSpecification":
            return Optional.ofNullable(clazz.cast(predefinedScalingMetricSpecification()));
        case "CustomizedScalingMetricSpecification":
            return Optional.ofNullable(clazz.cast(customizedScalingMetricSpecification()));
        case "TargetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        case "DisableScaleIn":
            return Optional.ofNullable(clazz.cast(disableScaleIn()));
        case "ScaleOutCooldown":
            return Optional.ofNullable(clazz.cast(scaleOutCooldown()));
        case "ScaleInCooldown":
            return Optional.ofNullable(clazz.cast(scaleInCooldown()));
        case "EstimatedInstanceWarmup":
            return Optional.ofNullable(clazz.cast(estimatedInstanceWarmup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingConfiguration, T> g) {
        return obj -> g.apply((TargetTrackingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetTrackingConfiguration> {
        /**
         * <p>
         * A predefined metric. You can specify either a predefined metric or a customized metric.
         * </p>
         * 
         * @param predefinedScalingMetricSpecification
         *        A predefined metric. You can specify either a predefined metric or a customized metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedScalingMetricSpecification(PredefinedScalingMetricSpecification predefinedScalingMetricSpecification);

        /**
         * <p>
         * A predefined metric. You can specify either a predefined metric or a customized metric.
         * </p>
         * This is a convenience that creates an instance of the {@link PredefinedScalingMetricSpecification.Builder}
         * avoiding the need to create one manually via {@link PredefinedScalingMetricSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link PredefinedScalingMetricSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #predefinedScalingMetricSpecification(PredefinedScalingMetricSpecification)}.
         * 
         * @param predefinedScalingMetricSpecification
         *        a consumer that will call methods on {@link PredefinedScalingMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefinedScalingMetricSpecification(PredefinedScalingMetricSpecification)
         */
        default Builder predefinedScalingMetricSpecification(
                Consumer<PredefinedScalingMetricSpecification.Builder> predefinedScalingMetricSpecification) {
            return predefinedScalingMetricSpecification(PredefinedScalingMetricSpecification.builder()
                    .applyMutation(predefinedScalingMetricSpecification).build());
        }

        /**
         * <p>
         * A customized metric. You can specify either a predefined metric or a customized metric.
         * </p>
         * 
         * @param customizedScalingMetricSpecification
         *        A customized metric. You can specify either a predefined metric or a customized metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizedScalingMetricSpecification(CustomizedScalingMetricSpecification customizedScalingMetricSpecification);

        /**
         * <p>
         * A customized metric. You can specify either a predefined metric or a customized metric.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomizedScalingMetricSpecification.Builder}
         * avoiding the need to create one manually via {@link CustomizedScalingMetricSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomizedScalingMetricSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customizedScalingMetricSpecification(CustomizedScalingMetricSpecification)}.
         * 
         * @param customizedScalingMetricSpecification
         *        a consumer that will call methods on {@link CustomizedScalingMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizedScalingMetricSpecification(CustomizedScalingMetricSpecification)
         */
        default Builder customizedScalingMetricSpecification(
                Consumer<CustomizedScalingMetricSpecification.Builder> customizedScalingMetricSpecification) {
            return customizedScalingMetricSpecification(CustomizedScalingMetricSpecification.builder()
                    .applyMutation(customizedScalingMetricSpecification).build());
        }

        /**
         * <p>
         * The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360
         * (Base 2).
         * </p>
         * 
         * @param targetValue
         *        The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to
         *        2e360 (Base 2).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);

        /**
         * <p>
         * Indicates whether scale in by the target tracking scaling policy is disabled. If the value is
         * <code>true</code>, scale in is disabled and the target tracking scaling policy doesn't remove capacity from
         * the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can remove
         * capacity from the scalable resource.
         * </p>
         * <p>
         * The default value is <code>false</code>.
         * </p>
         * 
         * @param disableScaleIn
         *        Indicates whether scale in by the target tracking scaling policy is disabled. If the value is
         *        <code>true</code>, scale in is disabled and the target tracking scaling policy doesn't remove capacity
         *        from the scalable resource. Otherwise, scale in is enabled and the target tracking scaling policy can
         *        remove capacity from the scalable resource. </p>
         *        <p>
         *        The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableScaleIn(Boolean disableScaleIn);

        /**
         * <p>
         * The amount of time, in seconds, after a scale-out activity completes before another scale-out activity can
         * start. This value is not used if the scalable resource is an Auto Scaling group.
         * </p>
         * <p>
         * While the cooldown period is in effect, the capacity that has been added by the previous scale-out event that
         * initiated the cooldown is calculated as part of the desired capacity for the next scale out. The intention is
         * to continuously (but not excessively) scale out.
         * </p>
         * 
         * @param scaleOutCooldown
         *        The amount of time, in seconds, after a scale-out activity completes before another scale-out activity
         *        can start. This value is not used if the scalable resource is an Auto Scaling group.</p>
         *        <p>
         *        While the cooldown period is in effect, the capacity that has been added by the previous scale-out
         *        event that initiated the cooldown is calculated as part of the desired capacity for the next scale
         *        out. The intention is to continuously (but not excessively) scale out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleOutCooldown(Integer scaleOutCooldown);

        /**
         * <p>
         * The amount of time, in seconds, after a scale in activity completes before another scale in activity can
         * start. This value is not used if the scalable resource is an Auto Scaling group.
         * </p>
         * <p>
         * The cooldown period is used to block subsequent scale in requests until it has expired. The intention is to
         * scale in conservatively to protect your application's availability. However, if another alarm triggers a
         * scale-out policy during the cooldown period after a scale-in, AWS Auto Scaling scales out your scalable
         * target immediately.
         * </p>
         * 
         * @param scaleInCooldown
         *        The amount of time, in seconds, after a scale in activity completes before another scale in activity
         *        can start. This value is not used if the scalable resource is an Auto Scaling group.</p>
         *        <p>
         *        The cooldown period is used to block subsequent scale in requests until it has expired. The intention
         *        is to scale in conservatively to protect your application's availability. However, if another alarm
         *        triggers a scale-out policy during the cooldown period after a scale-in, AWS Auto Scaling scales out
         *        your scalable target immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleInCooldown(Integer scaleInCooldown);

        /**
         * <p>
         * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
         * This value is used only if the resource is an Auto Scaling group.
         * </p>
         * 
         * @param estimatedInstanceWarmup
         *        The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch
         *        metrics. This value is used only if the resource is an Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup);
    }

    static final class BuilderImpl implements Builder {
        private PredefinedScalingMetricSpecification predefinedScalingMetricSpecification;

        private CustomizedScalingMetricSpecification customizedScalingMetricSpecification;

        private Double targetValue;

        private Boolean disableScaleIn;

        private Integer scaleOutCooldown;

        private Integer scaleInCooldown;

        private Integer estimatedInstanceWarmup;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingConfiguration model) {
            predefinedScalingMetricSpecification(model.predefinedScalingMetricSpecification);
            customizedScalingMetricSpecification(model.customizedScalingMetricSpecification);
            targetValue(model.targetValue);
            disableScaleIn(model.disableScaleIn);
            scaleOutCooldown(model.scaleOutCooldown);
            scaleInCooldown(model.scaleInCooldown);
            estimatedInstanceWarmup(model.estimatedInstanceWarmup);
        }

        public final PredefinedScalingMetricSpecification.Builder getPredefinedScalingMetricSpecification() {
            return predefinedScalingMetricSpecification != null ? predefinedScalingMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder predefinedScalingMetricSpecification(
                PredefinedScalingMetricSpecification predefinedScalingMetricSpecification) {
            this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
            return this;
        }

        public final void setPredefinedScalingMetricSpecification(
                PredefinedScalingMetricSpecification.BuilderImpl predefinedScalingMetricSpecification) {
            this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification != null ? predefinedScalingMetricSpecification
                    .build() : null;
        }

        public final CustomizedScalingMetricSpecification.Builder getCustomizedScalingMetricSpecification() {
            return customizedScalingMetricSpecification != null ? customizedScalingMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder customizedScalingMetricSpecification(
                CustomizedScalingMetricSpecification customizedScalingMetricSpecification) {
            this.customizedScalingMetricSpecification = customizedScalingMetricSpecification;
            return this;
        }

        public final void setCustomizedScalingMetricSpecification(
                CustomizedScalingMetricSpecification.BuilderImpl customizedScalingMetricSpecification) {
            this.customizedScalingMetricSpecification = customizedScalingMetricSpecification != null ? customizedScalingMetricSpecification
                    .build() : null;
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        public final Boolean getDisableScaleIn() {
            return disableScaleIn;
        }

        @Override
        public final Builder disableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        public final void setDisableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
        }

        public final Integer getScaleOutCooldown() {
            return scaleOutCooldown;
        }

        @Override
        public final Builder scaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        public final void setScaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
        }

        public final Integer getScaleInCooldown() {
            return scaleInCooldown;
        }

        @Override
        public final Builder scaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        public final void setScaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
        }

        public final Integer getEstimatedInstanceWarmup() {
            return estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        @Override
        public TargetTrackingConfiguration build() {
            return new TargetTrackingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
