/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum ScalingMetricType {
    ASG_AVERAGE_CPU_UTILIZATION("ASGAverageCPUUtilization"),

    ASG_AVERAGE_NETWORK_IN("ASGAverageNetworkIn"),

    ASG_AVERAGE_NETWORK_OUT("ASGAverageNetworkOut"),

    DYNAMO_DB_READ_CAPACITY_UTILIZATION("DynamoDBReadCapacityUtilization"),

    DYNAMO_DB_WRITE_CAPACITY_UTILIZATION("DynamoDBWriteCapacityUtilization"),

    ECS_SERVICE_AVERAGE_CPU_UTILIZATION("ECSServiceAverageCPUUtilization"),

    ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION("ECSServiceAverageMemoryUtilization"),

    ALB_REQUEST_COUNT_PER_TARGET("ALBRequestCountPerTarget"),

    RDS_READER_AVERAGE_CPU_UTILIZATION("RDSReaderAverageCPUUtilization"),

    RDS_READER_AVERAGE_DATABASE_CONNECTIONS("RDSReaderAverageDatabaseConnections"),

    EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION("EC2SpotFleetRequestAverageCPUUtilization"),

    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN("EC2SpotFleetRequestAverageNetworkIn"),

    EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT("EC2SpotFleetRequestAverageNetworkOut"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ScalingMetricType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ScalingMetricType corresponding to the value
     */
    public static ScalingMetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ScalingMetricType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ScalingMetricType}s
     */
    public static Set<ScalingMetricType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
