/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScalingPlanResponse extends AutoScalingPlansResponse implements
        ToCopyableBuilder<CreateScalingPlanResponse.Builder, CreateScalingPlanResponse> {
    private static final SdkField<Long> SCALING_PLAN_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateScalingPlanResponse::scalingPlanVersion)).setter(setter(Builder::scalingPlanVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_VERSION_FIELD));

    private final Long scalingPlanVersion;

    private CreateScalingPlanResponse(BuilderImpl builder) {
        super(builder);
        this.scalingPlanVersion = builder.scalingPlanVersion;
    }

    /**
     * <p>
     * The version number of the scaling plan. This value is always 1.
     * </p>
     * <p>
     * Currently, you cannot specify multiple scaling plan versions.
     * </p>
     * 
     * @return The version number of the scaling plan. This value is always 1.</p>
     *         <p>
     *         Currently, you cannot specify multiple scaling plan versions.
     */
    public Long scalingPlanVersion() {
        return scalingPlanVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scalingPlanVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScalingPlanResponse)) {
            return false;
        }
        CreateScalingPlanResponse other = (CreateScalingPlanResponse) obj;
        return Objects.equals(scalingPlanVersion(), other.scalingPlanVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateScalingPlanResponse").add("ScalingPlanVersion", scalingPlanVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingPlanVersion":
            return Optional.ofNullable(clazz.cast(scalingPlanVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScalingPlanResponse, T> g) {
        return obj -> g.apply((CreateScalingPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingPlansResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateScalingPlanResponse> {
        /**
         * <p>
         * The version number of the scaling plan. This value is always 1.
         * </p>
         * <p>
         * Currently, you cannot specify multiple scaling plan versions.
         * </p>
         * 
         * @param scalingPlanVersion
         *        The version number of the scaling plan. This value is always 1.</p>
         *        <p>
         *        Currently, you cannot specify multiple scaling plan versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanVersion(Long scalingPlanVersion);
    }

    static final class BuilderImpl extends AutoScalingPlansResponse.BuilderImpl implements Builder {
        private Long scalingPlanVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScalingPlanResponse model) {
            super(model);
            scalingPlanVersion(model.scalingPlanVersion);
        }

        public final Long getScalingPlanVersion() {
            return scalingPlanVersion;
        }

        @Override
        public final Builder scalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
            return this;
        }

        public final void setScalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
        }

        @Override
        public CreateScalingPlanResponse build() {
            return new CreateScalingPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
