/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.autoscalingplans.model.AutoScalingPlansException;
import software.amazon.awssdk.services.autoscalingplans.model.ConcurrentUpdateException;
import software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanRequest;
import software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanResponse;
import software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanRequest;
import software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanResponse;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesResponse;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse;
import software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest;
import software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse;
import software.amazon.awssdk.services.autoscalingplans.model.InternalServiceException;
import software.amazon.awssdk.services.autoscalingplans.model.InvalidNextTokenException;
import software.amazon.awssdk.services.autoscalingplans.model.LimitExceededException;
import software.amazon.awssdk.services.autoscalingplans.model.ObjectNotFoundException;
import software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanRequest;
import software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanResponse;
import software.amazon.awssdk.services.autoscalingplans.model.ValidationException;

/**
 * Service client for accessing AWS Auto Scaling Plans. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Auto Scaling</fullname>
 * <p>
 * Use AWS Auto Scaling to quickly discover all the scalable AWS resources for your application and configure dynamic
 * scaling and predictive scaling for your resources using scaling plans. Use this service in conjunction with the
 * Amazon EC2 Auto Scaling, Application Auto Scaling, Amazon CloudWatch, and AWS CloudFormation services.
 * </p>
 * <p>
 * Currently, predictive scaling is only available for Amazon EC2 Auto Scaling groups.
 * </p>
 * <p>
 * For more information about AWS Auto Scaling, including information about granting IAM users required permissions for
 * AWS Auto Scaling actions, see the <a
 * href="https://docs.aws.amazon.com/autoscaling/plans/userguide/what-is-aws-auto-scaling.html">AWS Auto Scaling User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface AutoScalingPlansClient extends SdkClient {
    String SERVICE_NAME = "autoscaling-plans";

    /**
     * Create a {@link AutoScalingPlansClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AutoScalingPlansClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AutoScalingPlansClient}.
     */
    static AutoScalingPlansClientBuilder builder() {
        return new DefaultAutoScalingPlansClientBuilder();
    }

    /**
     * <p>
     * Creates a scaling plan.
     * </p>
     *
     * @param createScalingPlanRequest
     * @return Result of the CreateScalingPlan operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws LimitExceededException
     *         Your account exceeded a limit. This exception is thrown when a per-account resource limit is exceeded.
     * @throws ConcurrentUpdateException
     *         Concurrent updates caused an exception, for example, if you request an update to a scaling plan that
     *         already has a pending update.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.CreateScalingPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/CreateScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateScalingPlanResponse createScalingPlan(CreateScalingPlanRequest createScalingPlanRequest)
            throws ValidationException, LimitExceededException, ConcurrentUpdateException, InternalServiceException,
            AwsServiceException, SdkClientException, AutoScalingPlansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a scaling plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScalingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreateScalingPlanRequest#builder()}
     * </p>
     *
     * @param createScalingPlanRequest
     *        A {@link Consumer} that will call methods on {@link CreateScalingPlanRequest.Builder} to create a request.
     * @return Result of the CreateScalingPlan operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws LimitExceededException
     *         Your account exceeded a limit. This exception is thrown when a per-account resource limit is exceeded.
     * @throws ConcurrentUpdateException
     *         Concurrent updates caused an exception, for example, if you request an update to a scaling plan that
     *         already has a pending update.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.CreateScalingPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/CreateScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateScalingPlanResponse createScalingPlan(Consumer<CreateScalingPlanRequest.Builder> createScalingPlanRequest)
            throws ValidationException, LimitExceededException, ConcurrentUpdateException, InternalServiceException,
            AwsServiceException, SdkClientException, AutoScalingPlansException {
        return createScalingPlan(CreateScalingPlanRequest.builder().applyMutation(createScalingPlanRequest).build());
    }

    /**
     * <p>
     * Deletes the specified scaling plan.
     * </p>
     * <p>
     * Deleting a scaling plan deletes the underlying <a>ScalingInstruction</a> for all of the scalable resources that
     * are covered by the plan.
     * </p>
     * <p>
     * If the plan has launched resources or has scaling activities in progress, you must delete those resources
     * separately.
     * </p>
     *
     * @param deleteScalingPlanRequest
     * @return Result of the DeleteScalingPlan operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws ObjectNotFoundException
     *         The specified object could not be found.
     * @throws ConcurrentUpdateException
     *         Concurrent updates caused an exception, for example, if you request an update to a scaling plan that
     *         already has a pending update.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.DeleteScalingPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DeleteScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteScalingPlanResponse deleteScalingPlan(DeleteScalingPlanRequest deleteScalingPlanRequest)
            throws ValidationException, ObjectNotFoundException, ConcurrentUpdateException, InternalServiceException,
            AwsServiceException, SdkClientException, AutoScalingPlansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified scaling plan.
     * </p>
     * <p>
     * Deleting a scaling plan deletes the underlying <a>ScalingInstruction</a> for all of the scalable resources that
     * are covered by the plan.
     * </p>
     * <p>
     * If the plan has launched resources or has scaling activities in progress, you must delete those resources
     * separately.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScalingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteScalingPlanRequest#builder()}
     * </p>
     *
     * @param deleteScalingPlanRequest
     *        A {@link Consumer} that will call methods on {@link DeleteScalingPlanRequest.Builder} to create a request.
     * @return Result of the DeleteScalingPlan operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws ObjectNotFoundException
     *         The specified object could not be found.
     * @throws ConcurrentUpdateException
     *         Concurrent updates caused an exception, for example, if you request an update to a scaling plan that
     *         already has a pending update.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.DeleteScalingPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DeleteScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteScalingPlanResponse deleteScalingPlan(Consumer<DeleteScalingPlanRequest.Builder> deleteScalingPlanRequest)
            throws ValidationException, ObjectNotFoundException, ConcurrentUpdateException, InternalServiceException,
            AwsServiceException, SdkClientException, AutoScalingPlansException {
        return deleteScalingPlan(DeleteScalingPlanRequest.builder().applyMutation(deleteScalingPlanRequest).build());
    }

    /**
     * <p>
     * Describes the scalable resources in the specified scaling plan.
     * </p>
     *
     * @param describeScalingPlanResourcesRequest
     * @return Result of the DescribeScalingPlanResources operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws InvalidNextTokenException
     *         The token provided is not valid.
     * @throws ConcurrentUpdateException
     *         Concurrent updates caused an exception, for example, if you request an update to a scaling plan that
     *         already has a pending update.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.DescribeScalingPlanResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlanResources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPlanResourcesResponse describeScalingPlanResources(
            DescribeScalingPlanResourcesRequest describeScalingPlanResourcesRequest) throws ValidationException,
            InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException,
            SdkClientException, AutoScalingPlansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the scalable resources in the specified scaling plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingPlanResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeScalingPlanResourcesRequest#builder()}
     * </p>
     *
     * @param describeScalingPlanResourcesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalingPlanResourcesRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeScalingPlanResources operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws InvalidNextTokenException
     *         The token provided is not valid.
     * @throws ConcurrentUpdateException
     *         Concurrent updates caused an exception, for example, if you request an update to a scaling plan that
     *         already has a pending update.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.DescribeScalingPlanResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlanResources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPlanResourcesResponse describeScalingPlanResources(
            Consumer<DescribeScalingPlanResourcesRequest.Builder> describeScalingPlanResourcesRequest)
            throws ValidationException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException,
            AwsServiceException, SdkClientException, AutoScalingPlansException {
        return describeScalingPlanResources(DescribeScalingPlanResourcesRequest.builder()
                .applyMutation(describeScalingPlanResourcesRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your scaling plans.
     * </p>
     *
     * @return Result of the DescribeScalingPlans operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws InvalidNextTokenException
     *         The token provided is not valid.
     * @throws ConcurrentUpdateException
     *         Concurrent updates caused an exception, for example, if you request an update to a scaling plan that
     *         already has a pending update.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.DescribeScalingPlans
     * @see #describeScalingPlans(DescribeScalingPlansRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPlansResponse describeScalingPlans() throws ValidationException, InvalidNextTokenException,
            ConcurrentUpdateException, InternalServiceException, AwsServiceException, SdkClientException,
            AutoScalingPlansException {
        return describeScalingPlans(DescribeScalingPlansRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your scaling plans.
     * </p>
     *
     * @param describeScalingPlansRequest
     * @return Result of the DescribeScalingPlans operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws InvalidNextTokenException
     *         The token provided is not valid.
     * @throws ConcurrentUpdateException
     *         Concurrent updates caused an exception, for example, if you request an update to a scaling plan that
     *         already has a pending update.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.DescribeScalingPlans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPlansResponse describeScalingPlans(DescribeScalingPlansRequest describeScalingPlansRequest)
            throws ValidationException, InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException,
            AwsServiceException, SdkClientException, AutoScalingPlansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your scaling plans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingPlansRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeScalingPlansRequest#builder()}
     * </p>
     *
     * @param describeScalingPlansRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalingPlansRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeScalingPlans operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws InvalidNextTokenException
     *         The token provided is not valid.
     * @throws ConcurrentUpdateException
     *         Concurrent updates caused an exception, for example, if you request an update to a scaling plan that
     *         already has a pending update.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.DescribeScalingPlans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPlansResponse describeScalingPlans(
            Consumer<DescribeScalingPlansRequest.Builder> describeScalingPlansRequest) throws ValidationException,
            InvalidNextTokenException, ConcurrentUpdateException, InternalServiceException, AwsServiceException,
            SdkClientException, AutoScalingPlansException {
        return describeScalingPlans(DescribeScalingPlansRequest.builder().applyMutation(describeScalingPlansRequest).build());
    }

    /**
     * <p>
     * Retrieves the forecast data for a scalable resource.
     * </p>
     * <p>
     * Capacity forecasts are represented as predicted values, or data points, that are calculated using historical data
     * points from a specified CloudWatch load metric. Data points are available for up to 56 days.
     * </p>
     *
     * @param getScalingPlanResourceForecastDataRequest
     * @return Result of the GetScalingPlanResourceForecastData operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.GetScalingPlanResourceForecastData
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/GetScalingPlanResourceForecastData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetScalingPlanResourceForecastDataResponse getScalingPlanResourceForecastData(
            GetScalingPlanResourceForecastDataRequest getScalingPlanResourceForecastDataRequest) throws ValidationException,
            InternalServiceException, AwsServiceException, SdkClientException, AutoScalingPlansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the forecast data for a scalable resource.
     * </p>
     * <p>
     * Capacity forecasts are represented as predicted values, or data points, that are calculated using historical data
     * points from a specified CloudWatch load metric. Data points are available for up to 56 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScalingPlanResourceForecastDataRequest.Builder}
     * avoiding the need to create one manually via {@link GetScalingPlanResourceForecastDataRequest#builder()}
     * </p>
     *
     * @param getScalingPlanResourceForecastDataRequest
     *        A {@link Consumer} that will call methods on {@link GetScalingPlanResourceForecastDataRequest.Builder} to
     *        create a request.
     * @return Result of the GetScalingPlanResourceForecastData operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.GetScalingPlanResourceForecastData
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/GetScalingPlanResourceForecastData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetScalingPlanResourceForecastDataResponse getScalingPlanResourceForecastData(
            Consumer<GetScalingPlanResourceForecastDataRequest.Builder> getScalingPlanResourceForecastDataRequest)
            throws ValidationException, InternalServiceException, AwsServiceException, SdkClientException,
            AutoScalingPlansException {
        return getScalingPlanResourceForecastData(GetScalingPlanResourceForecastDataRequest.builder()
                .applyMutation(getScalingPlanResourceForecastDataRequest).build());
    }

    /**
     * <p>
     * Updates the specified scaling plan.
     * </p>
     * <p>
     * You cannot update a scaling plan if it is in the process of being created, updated, or deleted.
     * </p>
     *
     * @param updateScalingPlanRequest
     * @return Result of the UpdateScalingPlan operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws ConcurrentUpdateException
     *         Concurrent updates caused an exception, for example, if you request an update to a scaling plan that
     *         already has a pending update.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws ObjectNotFoundException
     *         The specified object could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.UpdateScalingPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/UpdateScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateScalingPlanResponse updateScalingPlan(UpdateScalingPlanRequest updateScalingPlanRequest)
            throws ValidationException, ConcurrentUpdateException, InternalServiceException, ObjectNotFoundException,
            AwsServiceException, SdkClientException, AutoScalingPlansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified scaling plan.
     * </p>
     * <p>
     * You cannot update a scaling plan if it is in the process of being created, updated, or deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateScalingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateScalingPlanRequest#builder()}
     * </p>
     *
     * @param updateScalingPlanRequest
     *        A {@link Consumer} that will call methods on {@link UpdateScalingPlanRequest.Builder} to create a request.
     * @return Result of the UpdateScalingPlan operation returned by the service.
     * @throws ValidationException
     *         An exception was thrown for a validation issue. Review the parameters provided.
     * @throws ConcurrentUpdateException
     *         Concurrent updates caused an exception, for example, if you request an update to a scaling plan that
     *         already has a pending update.
     * @throws InternalServiceException
     *         The service encountered an internal error.
     * @throws ObjectNotFoundException
     *         The specified object could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AutoScalingPlansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AutoScalingPlansClient.UpdateScalingPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/UpdateScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateScalingPlanResponse updateScalingPlan(Consumer<UpdateScalingPlanRequest.Builder> updateScalingPlanRequest)
            throws ValidationException, ConcurrentUpdateException, InternalServiceException, ObjectNotFoundException,
            AwsServiceException, SdkClientException, AutoScalingPlansException {
        return updateScalingPlan(UpdateScalingPlanRequest.builder().applyMutation(updateScalingPlanRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("autoscaling-plans");
    }
}
