/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscalingplans.model.ApplicationSource;
import software.amazon.awssdk.services.autoscalingplans.model.AutoScalingPlansRequest;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingInstructionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateScalingPlanRequest
extends AutoScalingPlansRequest
implements ToCopyableBuilder<Builder, UpdateScalingPlanRequest> {
    private static final SdkField<ApplicationSource> APPLICATION_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateScalingPlanRequest.getter(UpdateScalingPlanRequest::applicationSource)).setter(UpdateScalingPlanRequest.setter(Builder::applicationSource)).constructor(ApplicationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSource").build()}).build();
    private static final SdkField<String> SCALING_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateScalingPlanRequest.getter(UpdateScalingPlanRequest::scalingPlanName)).setter(UpdateScalingPlanRequest.setter(Builder::scalingPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanName").build()}).build();
    private static final SdkField<List<ScalingInstruction>> SCALING_INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateScalingPlanRequest.getter(UpdateScalingPlanRequest::scalingInstructions)).setter(UpdateScalingPlanRequest.setter(Builder::scalingInstructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingInstructions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingInstruction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> SCALING_PLAN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(UpdateScalingPlanRequest.getter(UpdateScalingPlanRequest::scalingPlanVersion)).setter(UpdateScalingPlanRequest.setter(Builder::scalingPlanVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_SOURCE_FIELD, SCALING_PLAN_NAME_FIELD, SCALING_INSTRUCTIONS_FIELD, SCALING_PLAN_VERSION_FIELD));
    private final ApplicationSource applicationSource;
    private final String scalingPlanName;
    private final List<ScalingInstruction> scalingInstructions;
    private final Long scalingPlanVersion;

    private UpdateScalingPlanRequest(BuilderImpl builder) {
        super(builder);
        this.applicationSource = builder.applicationSource;
        this.scalingPlanName = builder.scalingPlanName;
        this.scalingInstructions = builder.scalingInstructions;
        this.scalingPlanVersion = builder.scalingPlanVersion;
    }

    public ApplicationSource applicationSource() {
        return this.applicationSource;
    }

    public String scalingPlanName() {
        return this.scalingPlanName;
    }

    public List<ScalingInstruction> scalingInstructions() {
        return this.scalingInstructions;
    }

    public Long scalingPlanVersion() {
        return this.scalingPlanVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingInstructions());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPlanVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScalingPlanRequest)) {
            return false;
        }
        UpdateScalingPlanRequest other = (UpdateScalingPlanRequest)((Object)obj);
        return Objects.equals(this.applicationSource(), other.applicationSource()) && Objects.equals(this.scalingPlanName(), other.scalingPlanName()) && Objects.equals(this.scalingInstructions(), other.scalingInstructions()) && Objects.equals(this.scalingPlanVersion(), other.scalingPlanVersion());
    }

    public String toString() {
        return ToString.builder((String)"UpdateScalingPlanRequest").add("ApplicationSource", (Object)this.applicationSource()).add("ScalingPlanName", (Object)this.scalingPlanName()).add("ScalingInstructions", this.scalingInstructions()).add("ScalingPlanVersion", (Object)this.scalingPlanVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationSource": {
                return Optional.ofNullable(clazz.cast(this.applicationSource()));
            }
            case "ScalingPlanName": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanName()));
            }
            case "ScalingInstructions": {
                return Optional.ofNullable(clazz.cast(this.scalingInstructions()));
            }
            case "ScalingPlanVersion": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateScalingPlanRequest, T> g) {
        return obj -> g.apply((UpdateScalingPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingPlansRequest.BuilderImpl
    implements Builder {
        private ApplicationSource applicationSource;
        private String scalingPlanName;
        private List<ScalingInstruction> scalingInstructions = DefaultSdkAutoConstructList.getInstance();
        private Long scalingPlanVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScalingPlanRequest model) {
            super(model);
            this.applicationSource(model.applicationSource);
            this.scalingPlanName(model.scalingPlanName);
            this.scalingInstructions(model.scalingInstructions);
            this.scalingPlanVersion(model.scalingPlanVersion);
        }

        public final ApplicationSource.Builder getApplicationSource() {
            return this.applicationSource != null ? this.applicationSource.toBuilder() : null;
        }

        @Override
        public final Builder applicationSource(ApplicationSource applicationSource) {
            this.applicationSource = applicationSource;
            return this;
        }

        public final void setApplicationSource(ApplicationSource.BuilderImpl applicationSource) {
            this.applicationSource = applicationSource != null ? applicationSource.build() : null;
        }

        public final String getScalingPlanName() {
            return this.scalingPlanName;
        }

        @Override
        public final Builder scalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
            return this;
        }

        public final void setScalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
        }

        public final Collection<ScalingInstruction.Builder> getScalingInstructions() {
            return this.scalingInstructions != null ? (Collection)this.scalingInstructions.stream().map(ScalingInstruction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scalingInstructions(Collection<ScalingInstruction> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copy(scalingInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(ScalingInstruction ... scalingInstructions) {
            this.scalingInstructions(Arrays.asList(scalingInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingInstructions(Consumer<ScalingInstruction.Builder> ... scalingInstructions) {
            this.scalingInstructions(Stream.of(scalingInstructions).map(c -> (ScalingInstruction)((ScalingInstruction.Builder)ScalingInstruction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScalingInstructions(Collection<ScalingInstruction.BuilderImpl> scalingInstructions) {
            this.scalingInstructions = ScalingInstructionsCopier.copyFromBuilder(scalingInstructions);
        }

        public final Long getScalingPlanVersion() {
            return this.scalingPlanVersion;
        }

        @Override
        public final Builder scalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
            return this;
        }

        public final void setScalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScalingPlanRequest build() {
            return new UpdateScalingPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingPlansRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateScalingPlanRequest> {
        public Builder applicationSource(ApplicationSource var1);

        default public Builder applicationSource(Consumer<ApplicationSource.Builder> applicationSource) {
            return this.applicationSource((ApplicationSource)((ApplicationSource.Builder)ApplicationSource.builder().applyMutation(applicationSource)).build());
        }

        public Builder scalingPlanName(String var1);

        public Builder scalingInstructions(Collection<ScalingInstruction> var1);

        public Builder scalingInstructions(ScalingInstruction ... var1);

        public Builder scalingInstructions(Consumer<ScalingInstruction.Builder> ... var1);

        public Builder scalingPlanVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

