/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfiguration;

public class DescribeLaunchConfigurationsIterable
implements SdkIterable<DescribeLaunchConfigurationsResponse> {
    private final AutoScalingClient client;
    private final DescribeLaunchConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLaunchConfigurationsIterable(AutoScalingClient client, DescribeLaunchConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeLaunchConfigurationsResponseFetcher();
    }

    public Iterator<DescribeLaunchConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LaunchConfiguration> launchConfigurations() {
        Function<DescribeLaunchConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.launchConfigurations() != null) {
                return response.launchConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeLaunchConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeLaunchConfigurationsResponse> {
        private DescribeLaunchConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLaunchConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLaunchConfigurationsResponse nextPage(DescribeLaunchConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLaunchConfigurationsIterable.this.client.describeLaunchConfigurations(DescribeLaunchConfigurationsIterable.this.firstRequest);
            }
            return DescribeLaunchConfigurationsIterable.this.client.describeLaunchConfigurations((DescribeLaunchConfigurationsRequest)((Object)DescribeLaunchConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

