/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.AvailabilityZoneIdsLimit1Copier;
import software.amazon.awssdk.services.autoscaling.model.AvailabilityZonesLimit1Copier;
import software.amazon.awssdk.services.autoscaling.model.RetryStrategy;
import software.amazon.awssdk.services.autoscaling.model.SubnetIdsLimit1Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchInstancesRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, LaunchInstancesRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(LaunchInstancesRequest.getter(LaunchInstancesRequest::autoScalingGroupName)).setter(LaunchInstancesRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<Integer> REQUESTED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RequestedCapacity").getter(LaunchInstancesRequest.getter(LaunchInstancesRequest::requestedCapacity)).setter(LaunchInstancesRequest.setter(Builder::requestedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedCapacity").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(LaunchInstancesRequest.getter(LaunchInstancesRequest::clientToken)).setter(LaunchInstancesRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(LaunchInstancesRequest.getter(LaunchInstancesRequest::availabilityZones)).setter(LaunchInstancesRequest.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZoneIds").getter(LaunchInstancesRequest.getter(LaunchInstancesRequest::availabilityZoneIds)).setter(LaunchInstancesRequest.setter(Builder::availabilityZoneIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(LaunchInstancesRequest.getter(LaunchInstancesRequest::subnetIds)).setter(LaunchInstancesRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RETRY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetryStrategy").getter(LaunchInstancesRequest.getter(LaunchInstancesRequest::retryStrategyAsString)).setter(LaunchInstancesRequest.setter(Builder::retryStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, REQUESTED_CAPACITY_FIELD, CLIENT_TOKEN_FIELD, AVAILABILITY_ZONES_FIELD, AVAILABILITY_ZONE_IDS_FIELD, SUBNET_IDS_FIELD, RETRY_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchInstancesRequest.memberNameToFieldInitializer();
    private final String autoScalingGroupName;
    private final Integer requestedCapacity;
    private final String clientToken;
    private final List<String> availabilityZones;
    private final List<String> availabilityZoneIds;
    private final List<String> subnetIds;
    private final String retryStrategy;

    private LaunchInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.requestedCapacity = builder.requestedCapacity;
        this.clientToken = builder.clientToken;
        this.availabilityZones = builder.availabilityZones;
        this.availabilityZoneIds = builder.availabilityZoneIds;
        this.subnetIds = builder.subnetIds;
        this.retryStrategy = builder.retryStrategy;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final Integer requestedCapacity() {
        return this.requestedCapacity;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasAvailabilityZoneIds() {
        return this.availabilityZoneIds != null && !(this.availabilityZoneIds instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZoneIds() {
        return this.availabilityZoneIds;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final RetryStrategy retryStrategy() {
        return RetryStrategy.fromValue(this.retryStrategy);
    }

    public final String retryStrategyAsString() {
        return this.retryStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchInstancesRequest)) {
            return false;
        }
        LaunchInstancesRequest other = (LaunchInstancesRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.requestedCapacity(), other.requestedCapacity()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasAvailabilityZoneIds() == other.hasAvailabilityZoneIds() && Objects.equals(this.availabilityZoneIds(), other.availabilityZoneIds()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.retryStrategyAsString(), other.retryStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchInstancesRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("RequestedCapacity", (Object)this.requestedCapacity()).add("ClientToken", (Object)this.clientToken()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("AvailabilityZoneIds", this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("RetryStrategy", (Object)this.retryStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "RequestedCapacity": {
                return Optional.ofNullable(clazz.cast(this.requestedCapacity()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "AvailabilityZoneIds": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneIds()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "RetryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("RequestedCapacity", REQUESTED_CAPACITY_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("AvailabilityZoneIds", AVAILABILITY_ZONE_IDS_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("RetryStrategy", RETRY_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchInstancesRequest, T> g) {
        return obj -> g.apply((LaunchInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private Integer requestedCapacity;
        private String clientToken;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> availabilityZoneIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String retryStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchInstancesRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.requestedCapacity(model.requestedCapacity);
            this.clientToken(model.clientToken);
            this.availabilityZones(model.availabilityZones);
            this.availabilityZoneIds(model.availabilityZoneIds);
            this.subnetIds(model.subnetIds);
            this.retryStrategy(model.retryStrategy);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final Integer getRequestedCapacity() {
            return this.requestedCapacity;
        }

        public final void setRequestedCapacity(Integer requestedCapacity) {
            this.requestedCapacity = requestedCapacity;
        }

        @Override
        public final Builder requestedCapacity(Integer requestedCapacity) {
            this.requestedCapacity = requestedCapacity;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesLimit1Copier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesLimit1Copier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getAvailabilityZoneIds() {
            if (this.availabilityZoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZoneIds;
        }

        public final void setAvailabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsLimit1Copier.copy(availabilityZoneIds);
        }

        @Override
        public final Builder availabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsLimit1Copier.copy(availabilityZoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIds(String ... availabilityZoneIds) {
            this.availabilityZoneIds(Arrays.asList(availabilityZoneIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsLimit1Copier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsLimit1Copier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getRetryStrategy() {
            return this.retryStrategy;
        }

        public final void setRetryStrategy(String retryStrategy) {
            this.retryStrategy = retryStrategy;
        }

        @Override
        public final Builder retryStrategy(String retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy(retryStrategy == null ? null : retryStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LaunchInstancesRequest build() {
            return new LaunchInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, LaunchInstancesRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder requestedCapacity(Integer var1);

        public Builder clientToken(String var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder availabilityZoneIds(Collection<String> var1);

        public Builder availabilityZoneIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder retryStrategy(String var1);

        public Builder retryStrategy(RetryStrategy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

