/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchInstancesRequest extends AutoScalingRequest implements
        ToCopyableBuilder<LaunchInstancesRequest.Builder, LaunchInstancesRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(LaunchInstancesRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<Integer> REQUESTED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RequestedCapacity").getter(getter(LaunchInstancesRequest::requestedCapacity))
            .setter(setter(Builder::requestedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedCapacity").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(LaunchInstancesRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(LaunchInstancesRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZoneIds")
            .getter(getter(LaunchInstancesRequest::availabilityZoneIds))
            .setter(setter(Builder::availabilityZoneIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(LaunchInstancesRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RETRY_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetryStrategy").getter(getter(LaunchInstancesRequest::retryStrategyAsString))
            .setter(setter(Builder::retryStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            REQUESTED_CAPACITY_FIELD, CLIENT_TOKEN_FIELD, AVAILABILITY_ZONES_FIELD, AVAILABILITY_ZONE_IDS_FIELD,
            SUBNET_IDS_FIELD, RETRY_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String autoScalingGroupName;

    private final Integer requestedCapacity;

    private final String clientToken;

    private final List<String> availabilityZones;

    private final List<String> availabilityZoneIds;

    private final List<String> subnetIds;

    private final String retryStrategy;

    private LaunchInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.requestedCapacity = builder.requestedCapacity;
        this.clientToken = builder.clientToken;
        this.availabilityZones = builder.availabilityZones;
        this.availabilityZoneIds = builder.availabilityZoneIds;
        this.subnetIds = builder.subnetIds;
        this.retryStrategy = builder.retryStrategy;
    }

    /**
     * <p>
     * The name of the Auto Scaling group to launch instances into.
     * </p>
     * 
     * @return The name of the Auto Scaling group to launch instances into.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The number of instances to launch. Although this value can exceed 100 for instance weights, the actual instance
     * count is limited to 100 instances per launch.
     * </p>
     * 
     * @return The number of instances to launch. Although this value can exceed 100 for instance weights, the actual
     *         instance count is limited to 100 instances per launch.
     */
    public final Integer requestedCapacity() {
        return requestedCapacity;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones for the instance launch. Must match or be included in the Auto Scaling group's
     * Availability Zone configuration. Either <code>AvailabilityZones</code> or <code>SubnetIds</code> must be
     * specified for groups with multiple Availability Zone configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return The Availability Zones for the instance launch. Must match or be included in the Auto Scaling group's
     *         Availability Zone configuration. Either <code>AvailabilityZones</code> or <code>SubnetIds</code> must be
     *         specified for groups with multiple Availability Zone configurations.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZoneIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZoneIds() {
        return availabilityZoneIds != null && !(availabilityZoneIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Availability Zone IDs where instances should be launched. Must match or be included in the group's AZ
     * configuration. You cannot specify both AvailabilityZones and AvailabilityZoneIds. Required for multi-AZ groups,
     * optional for single-AZ groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZoneIds} method.
     * </p>
     * 
     * @return A list of Availability Zone IDs where instances should be launched. Must match or be included in the
     *         group's AZ configuration. You cannot specify both AvailabilityZones and AvailabilityZoneIds. Required for
     *         multi-AZ groups, optional for single-AZ groups.
     */
    public final List<String> availabilityZoneIds() {
        return availabilityZoneIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnet IDs for the instance launch. Either <code>AvailabilityZones</code> or <code>SubnetIds</code> must be
     * specified. If both are specified, the subnets must reside in the specified Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The subnet IDs for the instance launch. Either <code>AvailabilityZones</code> or <code>SubnetIds</code>
     *         must be specified. If both are specified, the subnets must reside in the specified Availability Zones.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * Specifies whether to retry asynchronously if the synchronous launch fails. Valid values are NONE (default, no
     * async retry) and RETRY_WITH_GROUP_CONFIGURATION (increase desired capacity and retry with group configuration).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retryStrategy}
     * will return {@link RetryStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #retryStrategyAsString}.
     * </p>
     * 
     * @return Specifies whether to retry asynchronously if the synchronous launch fails. Valid values are NONE
     *         (default, no async retry) and RETRY_WITH_GROUP_CONFIGURATION (increase desired capacity and retry with
     *         group configuration).
     * @see RetryStrategy
     */
    public final RetryStrategy retryStrategy() {
        return RetryStrategy.fromValue(retryStrategy);
    }

    /**
     * <p>
     * Specifies whether to retry asynchronously if the synchronous launch fails. Valid values are NONE (default, no
     * async retry) and RETRY_WITH_GROUP_CONFIGURATION (increase desired capacity and retry with group configuration).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retryStrategy}
     * will return {@link RetryStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #retryStrategyAsString}.
     * </p>
     * 
     * @return Specifies whether to retry asynchronously if the synchronous launch fails. Valid values are NONE
     *         (default, no async retry) and RETRY_WITH_GROUP_CONFIGURATION (increase desired capacity and retry with
     *         group configuration).
     * @see RetryStrategy
     */
    public final String retryStrategyAsString() {
        return retryStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(requestedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZoneIds() ? availabilityZoneIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchInstancesRequest)) {
            return false;
        }
        LaunchInstancesRequest other = (LaunchInstancesRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(requestedCapacity(), other.requestedCapacity())
                && Objects.equals(clientToken(), other.clientToken()) && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && hasAvailabilityZoneIds() == other.hasAvailabilityZoneIds()
                && Objects.equals(availabilityZoneIds(), other.availabilityZoneIds()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(retryStrategyAsString(), other.retryStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchInstancesRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("RequestedCapacity", requestedCapacity()).add("ClientToken", clientToken())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("AvailabilityZoneIds", hasAvailabilityZoneIds() ? availabilityZoneIds() : null)
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("RetryStrategy", retryStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "RequestedCapacity":
            return Optional.ofNullable(clazz.cast(requestedCapacity()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "AvailabilityZoneIds":
            return Optional.ofNullable(clazz.cast(availabilityZoneIds()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "RetryStrategy":
            return Optional.ofNullable(clazz.cast(retryStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("RequestedCapacity", REQUESTED_CAPACITY_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("AvailabilityZoneIds", AVAILABILITY_ZONE_IDS_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("RetryStrategy", RETRY_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchInstancesRequest, T> g) {
        return obj -> g.apply((LaunchInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, LaunchInstancesRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group to launch instances into.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group to launch instances into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The number of instances to launch. Although this value can exceed 100 for instance weights, the actual
         * instance count is limited to 100 instances per launch.
         * </p>
         * 
         * @param requestedCapacity
         *        The number of instances to launch. Although this value can exceed 100 for instance weights, the actual
         *        instance count is limited to 100 instances per launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedCapacity(Integer requestedCapacity);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Availability Zones for the instance launch. Must match or be included in the Auto Scaling group's
         * Availability Zone configuration. Either <code>AvailabilityZones</code> or <code>SubnetIds</code> must be
         * specified for groups with multiple Availability Zone configurations.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones for the instance launch. Must match or be included in the Auto Scaling group's
         *        Availability Zone configuration. Either <code>AvailabilityZones</code> or <code>SubnetIds</code> must
         *        be specified for groups with multiple Availability Zone configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The Availability Zones for the instance launch. Must match or be included in the Auto Scaling group's
         * Availability Zone configuration. Either <code>AvailabilityZones</code> or <code>SubnetIds</code> must be
         * specified for groups with multiple Availability Zone configurations.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones for the instance launch. Must match or be included in the Auto Scaling group's
         *        Availability Zone configuration. Either <code>AvailabilityZones</code> or <code>SubnetIds</code> must
         *        be specified for groups with multiple Availability Zone configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * A list of Availability Zone IDs where instances should be launched. Must match or be included in the group's
         * AZ configuration. You cannot specify both AvailabilityZones and AvailabilityZoneIds. Required for multi-AZ
         * groups, optional for single-AZ groups.
         * </p>
         * 
         * @param availabilityZoneIds
         *        A list of Availability Zone IDs where instances should be launched. Must match or be included in the
         *        group's AZ configuration. You cannot specify both AvailabilityZones and AvailabilityZoneIds. Required
         *        for multi-AZ groups, optional for single-AZ groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIds(Collection<String> availabilityZoneIds);

        /**
         * <p>
         * A list of Availability Zone IDs where instances should be launched. Must match or be included in the group's
         * AZ configuration. You cannot specify both AvailabilityZones and AvailabilityZoneIds. Required for multi-AZ
         * groups, optional for single-AZ groups.
         * </p>
         * 
         * @param availabilityZoneIds
         *        A list of Availability Zone IDs where instances should be launched. Must match or be included in the
         *        group's AZ configuration. You cannot specify both AvailabilityZones and AvailabilityZoneIds. Required
         *        for multi-AZ groups, optional for single-AZ groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIds(String... availabilityZoneIds);

        /**
         * <p>
         * The subnet IDs for the instance launch. Either <code>AvailabilityZones</code> or <code>SubnetIds</code> must
         * be specified. If both are specified, the subnets must reside in the specified Availability Zones.
         * </p>
         * 
         * @param subnetIds
         *        The subnet IDs for the instance launch. Either <code>AvailabilityZones</code> or
         *        <code>SubnetIds</code> must be specified. If both are specified, the subnets must reside in the
         *        specified Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The subnet IDs for the instance launch. Either <code>AvailabilityZones</code> or <code>SubnetIds</code> must
         * be specified. If both are specified, the subnets must reside in the specified Availability Zones.
         * </p>
         * 
         * @param subnetIds
         *        The subnet IDs for the instance launch. Either <code>AvailabilityZones</code> or
         *        <code>SubnetIds</code> must be specified. If both are specified, the subnets must reside in the
         *        specified Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * Specifies whether to retry asynchronously if the synchronous launch fails. Valid values are NONE (default, no
         * async retry) and RETRY_WITH_GROUP_CONFIGURATION (increase desired capacity and retry with group
         * configuration).
         * </p>
         * 
         * @param retryStrategy
         *        Specifies whether to retry asynchronously if the synchronous launch fails. Valid values are NONE
         *        (default, no async retry) and RETRY_WITH_GROUP_CONFIGURATION (increase desired capacity and retry with
         *        group configuration).
         * @see RetryStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetryStrategy
         */
        Builder retryStrategy(String retryStrategy);

        /**
         * <p>
         * Specifies whether to retry asynchronously if the synchronous launch fails. Valid values are NONE (default, no
         * async retry) and RETRY_WITH_GROUP_CONFIGURATION (increase desired capacity and retry with group
         * configuration).
         * </p>
         * 
         * @param retryStrategy
         *        Specifies whether to retry asynchronously if the synchronous launch fails. Valid values are NONE
         *        (default, no async retry) and RETRY_WITH_GROUP_CONFIGURATION (increase desired capacity and retry with
         *        group configuration).
         * @see RetryStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetryStrategy
         */
        Builder retryStrategy(RetryStrategy retryStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private Integer requestedCapacity;

        private String clientToken;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> availabilityZoneIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String retryStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchInstancesRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            requestedCapacity(model.requestedCapacity);
            clientToken(model.clientToken);
            availabilityZones(model.availabilityZones);
            availabilityZoneIds(model.availabilityZoneIds);
            subnetIds(model.subnetIds);
            retryStrategy(model.retryStrategy);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final Integer getRequestedCapacity() {
            return requestedCapacity;
        }

        public final void setRequestedCapacity(Integer requestedCapacity) {
            this.requestedCapacity = requestedCapacity;
        }

        @Override
        public final Builder requestedCapacity(Integer requestedCapacity) {
            this.requestedCapacity = requestedCapacity;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesLimit1Copier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesLimit1Copier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getAvailabilityZoneIds() {
            if (availabilityZoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZoneIds;
        }

        public final void setAvailabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsLimit1Copier.copy(availabilityZoneIds);
        }

        @Override
        public final Builder availabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsLimit1Copier.copy(availabilityZoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIds(String... availabilityZoneIds) {
            availabilityZoneIds(Arrays.asList(availabilityZoneIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsLimit1Copier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsLimit1Copier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getRetryStrategy() {
            return retryStrategy;
        }

        public final void setRetryStrategy(String retryStrategy) {
            this.retryStrategy = retryStrategy;
        }

        @Override
        public final Builder retryStrategy(String retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy(retryStrategy == null ? null : retryStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LaunchInstancesRequest build() {
            return new LaunchInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
