/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AvailabilityZoneDistribution;
import software.amazon.awssdk.services.autoscaling.model.AvailabilityZoneImpairmentPolicy;
import software.amazon.awssdk.services.autoscaling.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.autoscaling.model.CapacityReservationSpecification;
import software.amazon.awssdk.services.autoscaling.model.EnabledMetric;
import software.amazon.awssdk.services.autoscaling.model.EnabledMetricsCopier;
import software.amazon.awssdk.services.autoscaling.model.Instance;
import software.amazon.awssdk.services.autoscaling.model.InstanceMaintenancePolicy;
import software.amazon.awssdk.services.autoscaling.model.InstancesCopier;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.services.autoscaling.model.MixedInstancesPolicy;
import software.amazon.awssdk.services.autoscaling.model.SuspendedProcess;
import software.amazon.awssdk.services.autoscaling.model.SuspendedProcessesCopier;
import software.amazon.awssdk.services.autoscaling.model.TagDescription;
import software.amazon.awssdk.services.autoscaling.model.TagDescriptionListCopier;
import software.amazon.awssdk.services.autoscaling.model.TargetGroupARNsCopier;
import software.amazon.awssdk.services.autoscaling.model.TerminationPoliciesCopier;
import software.amazon.awssdk.services.autoscaling.model.TrafficSourceIdentifier;
import software.amazon.awssdk.services.autoscaling.model.TrafficSourcesCopier;
import software.amazon.awssdk.services.autoscaling.model.WarmPoolConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroup> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(AutoScalingGroup.getter(AutoScalingGroup::autoScalingGroupName)).setter(AutoScalingGroup.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupARN").getter(AutoScalingGroup.getter(AutoScalingGroup::autoScalingGroupARN)).setter(AutoScalingGroup.setter(Builder::autoScalingGroupARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupARN").build()}).build();
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchConfigurationName").getter(AutoScalingGroup.getter(AutoScalingGroup::launchConfigurationName)).setter(AutoScalingGroup.setter(Builder::launchConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplate").getter(AutoScalingGroup.getter(AutoScalingGroup::launchTemplate)).setter(AutoScalingGroup.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()}).build();
    private static final SdkField<MixedInstancesPolicy> MIXED_INSTANCES_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MixedInstancesPolicy").getter(AutoScalingGroup.getter(AutoScalingGroup::mixedInstancesPolicy)).setter(AutoScalingGroup.setter(Builder::mixedInstancesPolicy)).constructor(MixedInstancesPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedInstancesPolicy").build()}).build();
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinSize").getter(AutoScalingGroup.getter(AutoScalingGroup::minSize)).setter(AutoScalingGroup.setter(Builder::minSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()}).build();
    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSize").getter(AutoScalingGroup.getter(AutoScalingGroup::maxSize)).setter(AutoScalingGroup.setter(Builder::maxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()}).build();
    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DesiredCapacity").getter(AutoScalingGroup.getter(AutoScalingGroup::desiredCapacity)).setter(AutoScalingGroup.setter(Builder::desiredCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()}).build();
    private static final SdkField<Integer> PREDICTED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PredictedCapacity").getter(AutoScalingGroup.getter(AutoScalingGroup::predictedCapacity)).setter(AutoScalingGroup.setter(Builder::predictedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictedCapacity").build()}).build();
    private static final SdkField<Integer> DEFAULT_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultCooldown").getter(AutoScalingGroup.getter(AutoScalingGroup::defaultCooldown)).setter(AutoScalingGroup.setter(Builder::defaultCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCooldown").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(AutoScalingGroup.getter(AutoScalingGroup::availabilityZones)).setter(AutoScalingGroup.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancerNames").getter(AutoScalingGroup.getter(AutoScalingGroup::loadBalancerNames)).setter(AutoScalingGroup.setter(Builder::loadBalancerNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_GROUP_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetGroupARNs").getter(AutoScalingGroup.getter(AutoScalingGroup::targetGroupARNs)).setter(AutoScalingGroup.setter(Builder::targetGroupARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckType").getter(AutoScalingGroup.getter(AutoScalingGroup::healthCheckType)).setter(AutoScalingGroup.setter(Builder::healthCheckType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthCheckGracePeriod").getter(AutoScalingGroup.getter(AutoScalingGroup::healthCheckGracePeriod)).setter(AutoScalingGroup.setter(Builder::healthCheckGracePeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build()}).build();
    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(AutoScalingGroup.getter(AutoScalingGroup::instances)).setter(AutoScalingGroup.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(AutoScalingGroup.getter(AutoScalingGroup::createdTime)).setter(AutoScalingGroup.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<List<SuspendedProcess>> SUSPENDED_PROCESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuspendedProcesses").getter(AutoScalingGroup.getter(AutoScalingGroup::suspendedProcesses)).setter(AutoScalingGroup.setter(Builder::suspendedProcesses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspendedProcesses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuspendedProcess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlacementGroup").getter(AutoScalingGroup.getter(AutoScalingGroup::placementGroup)).setter(AutoScalingGroup.setter(Builder::placementGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroup").build()}).build();
    private static final SdkField<String> VPC_ZONE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCZoneIdentifier").getter(AutoScalingGroup.getter(AutoScalingGroup::vpcZoneIdentifier)).setter(AutoScalingGroup.setter(Builder::vpcZoneIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCZoneIdentifier").build()}).build();
    private static final SdkField<List<EnabledMetric>> ENABLED_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledMetrics").getter(AutoScalingGroup.getter(AutoScalingGroup::enabledMetrics)).setter(AutoScalingGroup.setter(Builder::enabledMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnabledMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AutoScalingGroup.getter(AutoScalingGroup::status)).setter(AutoScalingGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<TagDescription>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(AutoScalingGroup.getter(AutoScalingGroup::tags)).setter(AutoScalingGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TERMINATION_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TerminationPolicies").getter(AutoScalingGroup.getter(AutoScalingGroup::terminationPolicies)).setter(AutoScalingGroup.setter(Builder::terminationPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NewInstancesProtectedFromScaleIn").getter(AutoScalingGroup.getter(AutoScalingGroup::newInstancesProtectedFromScaleIn)).setter(AutoScalingGroup.setter(Builder::newInstancesProtectedFromScaleIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewInstancesProtectedFromScaleIn").build()}).build();
    private static final SdkField<String> SERVICE_LINKED_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceLinkedRoleARN").getter(AutoScalingGroup.getter(AutoScalingGroup::serviceLinkedRoleARN)).setter(AutoScalingGroup.setter(Builder::serviceLinkedRoleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkedRoleARN").build()}).build();
    private static final SdkField<Integer> MAX_INSTANCE_LIFETIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxInstanceLifetime").getter(AutoScalingGroup.getter(AutoScalingGroup::maxInstanceLifetime)).setter(AutoScalingGroup.setter(Builder::maxInstanceLifetime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInstanceLifetime").build()}).build();
    private static final SdkField<Boolean> CAPACITY_REBALANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CapacityRebalance").getter(AutoScalingGroup.getter(AutoScalingGroup::capacityRebalance)).setter(AutoScalingGroup.setter(Builder::capacityRebalance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRebalance").build()}).build();
    private static final SdkField<WarmPoolConfiguration> WARM_POOL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WarmPoolConfiguration").getter(AutoScalingGroup.getter(AutoScalingGroup::warmPoolConfiguration)).setter(AutoScalingGroup.setter(Builder::warmPoolConfiguration)).constructor(WarmPoolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmPoolConfiguration").build()}).build();
    private static final SdkField<Integer> WARM_POOL_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WarmPoolSize").getter(AutoScalingGroup.getter(AutoScalingGroup::warmPoolSize)).setter(AutoScalingGroup.setter(Builder::warmPoolSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmPoolSize").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Context").getter(AutoScalingGroup.getter(AutoScalingGroup::context)).setter(AutoScalingGroup.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build()}).build();
    private static final SdkField<String> DESIRED_CAPACITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredCapacityType").getter(AutoScalingGroup.getter(AutoScalingGroup::desiredCapacityType)).setter(AutoScalingGroup.setter(Builder::desiredCapacityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacityType").build()}).build();
    private static final SdkField<Integer> DEFAULT_INSTANCE_WARMUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultInstanceWarmup").getter(AutoScalingGroup.getter(AutoScalingGroup::defaultInstanceWarmup)).setter(AutoScalingGroup.setter(Builder::defaultInstanceWarmup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceWarmup").build()}).build();
    private static final SdkField<List<TrafficSourceIdentifier>> TRAFFIC_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrafficSources").getter(AutoScalingGroup.getter(AutoScalingGroup::trafficSources)).setter(AutoScalingGroup.setter(Builder::trafficSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrafficSourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceMaintenancePolicy> INSTANCE_MAINTENANCE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceMaintenancePolicy").getter(AutoScalingGroup.getter(AutoScalingGroup::instanceMaintenancePolicy)).setter(AutoScalingGroup.setter(Builder::instanceMaintenancePolicy)).constructor(InstanceMaintenancePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMaintenancePolicy").build()}).build();
    private static final SdkField<AvailabilityZoneDistribution> AVAILABILITY_ZONE_DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvailabilityZoneDistribution").getter(AutoScalingGroup.getter(AutoScalingGroup::availabilityZoneDistribution)).setter(AutoScalingGroup.setter(Builder::availabilityZoneDistribution)).constructor(AvailabilityZoneDistribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneDistribution").build()}).build();
    private static final SdkField<AvailabilityZoneImpairmentPolicy> AVAILABILITY_ZONE_IMPAIRMENT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvailabilityZoneImpairmentPolicy").getter(AutoScalingGroup.getter(AutoScalingGroup::availabilityZoneImpairmentPolicy)).setter(AutoScalingGroup.setter(Builder::availabilityZoneImpairmentPolicy)).constructor(AvailabilityZoneImpairmentPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneImpairmentPolicy").build()}).build();
    private static final SdkField<CapacityReservationSpecification> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservationSpecification").getter(AutoScalingGroup.getter(AutoScalingGroup::capacityReservationSpecification)).setter(AutoScalingGroup.setter(Builder::capacityReservationSpecification)).constructor(CapacityReservationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, AUTO_SCALING_GROUP_ARN_FIELD, LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_TEMPLATE_FIELD, MIXED_INSTANCES_POLICY_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, DESIRED_CAPACITY_FIELD, PREDICTED_CAPACITY_FIELD, DEFAULT_COOLDOWN_FIELD, AVAILABILITY_ZONES_FIELD, LOAD_BALANCER_NAMES_FIELD, TARGET_GROUP_AR_NS_FIELD, HEALTH_CHECK_TYPE_FIELD, HEALTH_CHECK_GRACE_PERIOD_FIELD, INSTANCES_FIELD, CREATED_TIME_FIELD, SUSPENDED_PROCESSES_FIELD, PLACEMENT_GROUP_FIELD, VPC_ZONE_IDENTIFIER_FIELD, ENABLED_METRICS_FIELD, STATUS_FIELD, TAGS_FIELD, TERMINATION_POLICIES_FIELD, NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD, SERVICE_LINKED_ROLE_ARN_FIELD, MAX_INSTANCE_LIFETIME_FIELD, CAPACITY_REBALANCE_FIELD, WARM_POOL_CONFIGURATION_FIELD, WARM_POOL_SIZE_FIELD, CONTEXT_FIELD, DESIRED_CAPACITY_TYPE_FIELD, DEFAULT_INSTANCE_WARMUP_FIELD, TRAFFIC_SOURCES_FIELD, INSTANCE_MAINTENANCE_POLICY_FIELD, AVAILABILITY_ZONE_DISTRIBUTION_FIELD, AVAILABILITY_ZONE_IMPAIRMENT_POLICY_FIELD, CAPACITY_RESERVATION_SPECIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoScalingGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String autoScalingGroupName;
    private final String autoScalingGroupARN;
    private final String launchConfigurationName;
    private final LaunchTemplateSpecification launchTemplate;
    private final MixedInstancesPolicy mixedInstancesPolicy;
    private final Integer minSize;
    private final Integer maxSize;
    private final Integer desiredCapacity;
    private final Integer predictedCapacity;
    private final Integer defaultCooldown;
    private final List<String> availabilityZones;
    private final List<String> loadBalancerNames;
    private final List<String> targetGroupARNs;
    private final String healthCheckType;
    private final Integer healthCheckGracePeriod;
    private final List<Instance> instances;
    private final Instant createdTime;
    private final List<SuspendedProcess> suspendedProcesses;
    private final String placementGroup;
    private final String vpcZoneIdentifier;
    private final List<EnabledMetric> enabledMetrics;
    private final String status;
    private final List<TagDescription> tags;
    private final List<String> terminationPolicies;
    private final Boolean newInstancesProtectedFromScaleIn;
    private final String serviceLinkedRoleARN;
    private final Integer maxInstanceLifetime;
    private final Boolean capacityRebalance;
    private final WarmPoolConfiguration warmPoolConfiguration;
    private final Integer warmPoolSize;
    private final String context;
    private final String desiredCapacityType;
    private final Integer defaultInstanceWarmup;
    private final List<TrafficSourceIdentifier> trafficSources;
    private final InstanceMaintenancePolicy instanceMaintenancePolicy;
    private final AvailabilityZoneDistribution availabilityZoneDistribution;
    private final AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy;
    private final CapacityReservationSpecification capacityReservationSpecification;

    private AutoScalingGroup(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.autoScalingGroupARN = builder.autoScalingGroupARN;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchTemplate = builder.launchTemplate;
        this.mixedInstancesPolicy = builder.mixedInstancesPolicy;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.predictedCapacity = builder.predictedCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.targetGroupARNs = builder.targetGroupARNs;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.instances = builder.instances;
        this.createdTime = builder.createdTime;
        this.suspendedProcesses = builder.suspendedProcesses;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.enabledMetrics = builder.enabledMetrics;
        this.status = builder.status;
        this.tags = builder.tags;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
        this.serviceLinkedRoleARN = builder.serviceLinkedRoleARN;
        this.maxInstanceLifetime = builder.maxInstanceLifetime;
        this.capacityRebalance = builder.capacityRebalance;
        this.warmPoolConfiguration = builder.warmPoolConfiguration;
        this.warmPoolSize = builder.warmPoolSize;
        this.context = builder.context;
        this.desiredCapacityType = builder.desiredCapacityType;
        this.defaultInstanceWarmup = builder.defaultInstanceWarmup;
        this.trafficSources = builder.trafficSources;
        this.instanceMaintenancePolicy = builder.instanceMaintenancePolicy;
        this.availabilityZoneDistribution = builder.availabilityZoneDistribution;
        this.availabilityZoneImpairmentPolicy = builder.availabilityZoneImpairmentPolicy;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final String autoScalingGroupARN() {
        return this.autoScalingGroupARN;
    }

    public final String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public final LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public final MixedInstancesPolicy mixedInstancesPolicy() {
        return this.mixedInstancesPolicy;
    }

    public final Integer minSize() {
        return this.minSize;
    }

    public final Integer maxSize() {
        return this.maxSize;
    }

    public final Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public final Integer predictedCapacity() {
        return this.predictedCapacity;
    }

    public final Integer defaultCooldown() {
        return this.defaultCooldown;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasLoadBalancerNames() {
        return this.loadBalancerNames != null && !(this.loadBalancerNames instanceof SdkAutoConstructList);
    }

    public final List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public final boolean hasTargetGroupARNs() {
        return this.targetGroupARNs != null && !(this.targetGroupARNs instanceof SdkAutoConstructList);
    }

    public final List<String> targetGroupARNs() {
        return this.targetGroupARNs;
    }

    public final String healthCheckType() {
        return this.healthCheckType;
    }

    public final Integer healthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<Instance> instances() {
        return this.instances;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final boolean hasSuspendedProcesses() {
        return this.suspendedProcesses != null && !(this.suspendedProcesses instanceof SdkAutoConstructList);
    }

    public final List<SuspendedProcess> suspendedProcesses() {
        return this.suspendedProcesses;
    }

    public final String placementGroup() {
        return this.placementGroup;
    }

    public final String vpcZoneIdentifier() {
        return this.vpcZoneIdentifier;
    }

    public final boolean hasEnabledMetrics() {
        return this.enabledMetrics != null && !(this.enabledMetrics instanceof SdkAutoConstructList);
    }

    public final List<EnabledMetric> enabledMetrics() {
        return this.enabledMetrics;
    }

    public final String status() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagDescription> tags() {
        return this.tags;
    }

    public final boolean hasTerminationPolicies() {
        return this.terminationPolicies != null && !(this.terminationPolicies instanceof SdkAutoConstructList);
    }

    public final List<String> terminationPolicies() {
        return this.terminationPolicies;
    }

    public final Boolean newInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    public final String serviceLinkedRoleARN() {
        return this.serviceLinkedRoleARN;
    }

    public final Integer maxInstanceLifetime() {
        return this.maxInstanceLifetime;
    }

    public final Boolean capacityRebalance() {
        return this.capacityRebalance;
    }

    public final WarmPoolConfiguration warmPoolConfiguration() {
        return this.warmPoolConfiguration;
    }

    public final Integer warmPoolSize() {
        return this.warmPoolSize;
    }

    public final String context() {
        return this.context;
    }

    public final String desiredCapacityType() {
        return this.desiredCapacityType;
    }

    public final Integer defaultInstanceWarmup() {
        return this.defaultInstanceWarmup;
    }

    public final boolean hasTrafficSources() {
        return this.trafficSources != null && !(this.trafficSources instanceof SdkAutoConstructList);
    }

    public final List<TrafficSourceIdentifier> trafficSources() {
        return this.trafficSources;
    }

    public final InstanceMaintenancePolicy instanceMaintenancePolicy() {
        return this.instanceMaintenancePolicy;
    }

    public final AvailabilityZoneDistribution availabilityZoneDistribution() {
        return this.availabilityZoneDistribution;
    }

    public final AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy() {
        return this.availabilityZoneImpairmentPolicy;
    }

    public final CapacityReservationSpecification capacityReservationSpecification() {
        return this.capacityReservationSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.mixedInstancesPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancerNames() ? this.loadBalancerNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetGroupARNs() ? this.targetGroupARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuspendedProcesses() ? this.suspendedProcesses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledMetrics() ? this.enabledMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerminationPolicies() ? this.terminationPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.newInstancesProtectedFromScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLinkedRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInstanceLifetime());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityRebalance());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmPoolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmPoolSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultInstanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrafficSources() ? this.trafficSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMaintenancePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneImpairmentPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup)obj;
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.autoScalingGroupARN(), other.autoScalingGroupARN()) && Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.mixedInstancesPolicy(), other.mixedInstancesPolicy()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.desiredCapacity(), other.desiredCapacity()) && Objects.equals(this.predictedCapacity(), other.predictedCapacity()) && Objects.equals(this.defaultCooldown(), other.defaultCooldown()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasLoadBalancerNames() == other.hasLoadBalancerNames() && Objects.equals(this.loadBalancerNames(), other.loadBalancerNames()) && this.hasTargetGroupARNs() == other.hasTargetGroupARNs() && Objects.equals(this.targetGroupARNs(), other.targetGroupARNs()) && Objects.equals(this.healthCheckType(), other.healthCheckType()) && Objects.equals(this.healthCheckGracePeriod(), other.healthCheckGracePeriod()) && this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.createdTime(), other.createdTime()) && this.hasSuspendedProcesses() == other.hasSuspendedProcesses() && Objects.equals(this.suspendedProcesses(), other.suspendedProcesses()) && Objects.equals(this.placementGroup(), other.placementGroup()) && Objects.equals(this.vpcZoneIdentifier(), other.vpcZoneIdentifier()) && this.hasEnabledMetrics() == other.hasEnabledMetrics() && Objects.equals(this.enabledMetrics(), other.enabledMetrics()) && Objects.equals(this.status(), other.status()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasTerminationPolicies() == other.hasTerminationPolicies() && Objects.equals(this.terminationPolicies(), other.terminationPolicies()) && Objects.equals(this.newInstancesProtectedFromScaleIn(), other.newInstancesProtectedFromScaleIn()) && Objects.equals(this.serviceLinkedRoleARN(), other.serviceLinkedRoleARN()) && Objects.equals(this.maxInstanceLifetime(), other.maxInstanceLifetime()) && Objects.equals(this.capacityRebalance(), other.capacityRebalance()) && Objects.equals(this.warmPoolConfiguration(), other.warmPoolConfiguration()) && Objects.equals(this.warmPoolSize(), other.warmPoolSize()) && Objects.equals(this.context(), other.context()) && Objects.equals(this.desiredCapacityType(), other.desiredCapacityType()) && Objects.equals(this.defaultInstanceWarmup(), other.defaultInstanceWarmup()) && this.hasTrafficSources() == other.hasTrafficSources() && Objects.equals(this.trafficSources(), other.trafficSources()) && Objects.equals(this.instanceMaintenancePolicy(), other.instanceMaintenancePolicy()) && Objects.equals(this.availabilityZoneDistribution(), other.availabilityZoneDistribution()) && Objects.equals(this.availabilityZoneImpairmentPolicy(), other.availabilityZoneImpairmentPolicy()) && Objects.equals(this.capacityReservationSpecification(), other.capacityReservationSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingGroup").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("AutoScalingGroupARN", (Object)this.autoScalingGroupARN()).add("LaunchConfigurationName", (Object)this.launchConfigurationName()).add("LaunchTemplate", (Object)this.launchTemplate()).add("MixedInstancesPolicy", (Object)this.mixedInstancesPolicy()).add("MinSize", (Object)this.minSize()).add("MaxSize", (Object)this.maxSize()).add("DesiredCapacity", (Object)this.desiredCapacity()).add("PredictedCapacity", (Object)this.predictedCapacity()).add("DefaultCooldown", (Object)this.defaultCooldown()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("LoadBalancerNames", this.hasLoadBalancerNames() ? this.loadBalancerNames() : null).add("TargetGroupARNs", this.hasTargetGroupARNs() ? this.targetGroupARNs() : null).add("HealthCheckType", (Object)this.healthCheckType()).add("HealthCheckGracePeriod", (Object)this.healthCheckGracePeriod()).add("Instances", this.hasInstances() ? this.instances() : null).add("CreatedTime", (Object)this.createdTime()).add("SuspendedProcesses", this.hasSuspendedProcesses() ? this.suspendedProcesses() : null).add("PlacementGroup", (Object)this.placementGroup()).add("VPCZoneIdentifier", (Object)this.vpcZoneIdentifier()).add("EnabledMetrics", this.hasEnabledMetrics() ? this.enabledMetrics() : null).add("Status", (Object)this.status()).add("Tags", this.hasTags() ? this.tags() : null).add("TerminationPolicies", this.hasTerminationPolicies() ? this.terminationPolicies() : null).add("NewInstancesProtectedFromScaleIn", (Object)this.newInstancesProtectedFromScaleIn()).add("ServiceLinkedRoleARN", (Object)this.serviceLinkedRoleARN()).add("MaxInstanceLifetime", (Object)this.maxInstanceLifetime()).add("CapacityRebalance", (Object)this.capacityRebalance()).add("WarmPoolConfiguration", (Object)this.warmPoolConfiguration()).add("WarmPoolSize", (Object)this.warmPoolSize()).add("Context", (Object)this.context()).add("DesiredCapacityType", (Object)this.desiredCapacityType()).add("DefaultInstanceWarmup", (Object)this.defaultInstanceWarmup()).add("TrafficSources", this.hasTrafficSources() ? this.trafficSources() : null).add("InstanceMaintenancePolicy", (Object)this.instanceMaintenancePolicy()).add("AvailabilityZoneDistribution", (Object)this.availabilityZoneDistribution()).add("AvailabilityZoneImpairmentPolicy", (Object)this.availabilityZoneImpairmentPolicy()).add("CapacityReservationSpecification", (Object)this.capacityReservationSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "AutoScalingGroupARN": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupARN()));
            }
            case "LaunchConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationName()));
            }
            case "LaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "MixedInstancesPolicy": {
                return Optional.ofNullable(clazz.cast(this.mixedInstancesPolicy()));
            }
            case "MinSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "MaxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
            case "DesiredCapacity": {
                return Optional.ofNullable(clazz.cast(this.desiredCapacity()));
            }
            case "PredictedCapacity": {
                return Optional.ofNullable(clazz.cast(this.predictedCapacity()));
            }
            case "DefaultCooldown": {
                return Optional.ofNullable(clazz.cast(this.defaultCooldown()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "LoadBalancerNames": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerNames()));
            }
            case "TargetGroupARNs": {
                return Optional.ofNullable(clazz.cast(this.targetGroupARNs()));
            }
            case "HealthCheckType": {
                return Optional.ofNullable(clazz.cast(this.healthCheckType()));
            }
            case "HealthCheckGracePeriod": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriod()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "SuspendedProcesses": {
                return Optional.ofNullable(clazz.cast(this.suspendedProcesses()));
            }
            case "PlacementGroup": {
                return Optional.ofNullable(clazz.cast(this.placementGroup()));
            }
            case "VPCZoneIdentifier": {
                return Optional.ofNullable(clazz.cast(this.vpcZoneIdentifier()));
            }
            case "EnabledMetrics": {
                return Optional.ofNullable(clazz.cast(this.enabledMetrics()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TerminationPolicies": {
                return Optional.ofNullable(clazz.cast(this.terminationPolicies()));
            }
            case "NewInstancesProtectedFromScaleIn": {
                return Optional.ofNullable(clazz.cast(this.newInstancesProtectedFromScaleIn()));
            }
            case "ServiceLinkedRoleARN": {
                return Optional.ofNullable(clazz.cast(this.serviceLinkedRoleARN()));
            }
            case "MaxInstanceLifetime": {
                return Optional.ofNullable(clazz.cast(this.maxInstanceLifetime()));
            }
            case "CapacityRebalance": {
                return Optional.ofNullable(clazz.cast(this.capacityRebalance()));
            }
            case "WarmPoolConfiguration": {
                return Optional.ofNullable(clazz.cast(this.warmPoolConfiguration()));
            }
            case "WarmPoolSize": {
                return Optional.ofNullable(clazz.cast(this.warmPoolSize()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "DesiredCapacityType": {
                return Optional.ofNullable(clazz.cast(this.desiredCapacityType()));
            }
            case "DefaultInstanceWarmup": {
                return Optional.ofNullable(clazz.cast(this.defaultInstanceWarmup()));
            }
            case "TrafficSources": {
                return Optional.ofNullable(clazz.cast(this.trafficSources()));
            }
            case "InstanceMaintenancePolicy": {
                return Optional.ofNullable(clazz.cast(this.instanceMaintenancePolicy()));
            }
            case "AvailabilityZoneDistribution": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneDistribution()));
            }
            case "AvailabilityZoneImpairmentPolicy": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneImpairmentPolicy()));
            }
            case "CapacityReservationSpecification": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("AutoScalingGroupARN", AUTO_SCALING_GROUP_ARN_FIELD);
        map.put("LaunchConfigurationName", LAUNCH_CONFIGURATION_NAME_FIELD);
        map.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("MixedInstancesPolicy", MIXED_INSTANCES_POLICY_FIELD);
        map.put("MinSize", MIN_SIZE_FIELD);
        map.put("MaxSize", MAX_SIZE_FIELD);
        map.put("DesiredCapacity", DESIRED_CAPACITY_FIELD);
        map.put("PredictedCapacity", PREDICTED_CAPACITY_FIELD);
        map.put("DefaultCooldown", DEFAULT_COOLDOWN_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("LoadBalancerNames", LOAD_BALANCER_NAMES_FIELD);
        map.put("TargetGroupARNs", TARGET_GROUP_AR_NS_FIELD);
        map.put("HealthCheckType", HEALTH_CHECK_TYPE_FIELD);
        map.put("HealthCheckGracePeriod", HEALTH_CHECK_GRACE_PERIOD_FIELD);
        map.put("Instances", INSTANCES_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("SuspendedProcesses", SUSPENDED_PROCESSES_FIELD);
        map.put("PlacementGroup", PLACEMENT_GROUP_FIELD);
        map.put("VPCZoneIdentifier", VPC_ZONE_IDENTIFIER_FIELD);
        map.put("EnabledMetrics", ENABLED_METRICS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TerminationPolicies", TERMINATION_POLICIES_FIELD);
        map.put("NewInstancesProtectedFromScaleIn", NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD);
        map.put("ServiceLinkedRoleARN", SERVICE_LINKED_ROLE_ARN_FIELD);
        map.put("MaxInstanceLifetime", MAX_INSTANCE_LIFETIME_FIELD);
        map.put("CapacityRebalance", CAPACITY_REBALANCE_FIELD);
        map.put("WarmPoolConfiguration", WARM_POOL_CONFIGURATION_FIELD);
        map.put("WarmPoolSize", WARM_POOL_SIZE_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("DesiredCapacityType", DESIRED_CAPACITY_TYPE_FIELD);
        map.put("DefaultInstanceWarmup", DEFAULT_INSTANCE_WARMUP_FIELD);
        map.put("TrafficSources", TRAFFIC_SOURCES_FIELD);
        map.put("InstanceMaintenancePolicy", INSTANCE_MAINTENANCE_POLICY_FIELD);
        map.put("AvailabilityZoneDistribution", AVAILABILITY_ZONE_DISTRIBUTION_FIELD);
        map.put("AvailabilityZoneImpairmentPolicy", AVAILABILITY_ZONE_IMPAIRMENT_POLICY_FIELD);
        map.put("CapacityReservationSpecification", CAPACITY_RESERVATION_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroup, T> g) {
        return obj -> g.apply((AutoScalingGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String autoScalingGroupARN;
        private String launchConfigurationName;
        private LaunchTemplateSpecification launchTemplate;
        private MixedInstancesPolicy mixedInstancesPolicy;
        private Integer minSize;
        private Integer maxSize;
        private Integer desiredCapacity;
        private Integer predictedCapacity;
        private Integer defaultCooldown;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetGroupARNs = DefaultSdkAutoConstructList.getInstance();
        private String healthCheckType;
        private Integer healthCheckGracePeriod;
        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;
        private List<SuspendedProcess> suspendedProcesses = DefaultSdkAutoConstructList.getInstance();
        private String placementGroup;
        private String vpcZoneIdentifier;
        private List<EnabledMetric> enabledMetrics = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private List<TagDescription> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> terminationPolicies = DefaultSdkAutoConstructList.getInstance();
        private Boolean newInstancesProtectedFromScaleIn;
        private String serviceLinkedRoleARN;
        private Integer maxInstanceLifetime;
        private Boolean capacityRebalance;
        private WarmPoolConfiguration warmPoolConfiguration;
        private Integer warmPoolSize;
        private String context;
        private String desiredCapacityType;
        private Integer defaultInstanceWarmup;
        private List<TrafficSourceIdentifier> trafficSources = DefaultSdkAutoConstructList.getInstance();
        private InstanceMaintenancePolicy instanceMaintenancePolicy;
        private AvailabilityZoneDistribution availabilityZoneDistribution;
        private AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy;
        private CapacityReservationSpecification capacityReservationSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroup model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.autoScalingGroupARN(model.autoScalingGroupARN);
            this.launchConfigurationName(model.launchConfigurationName);
            this.launchTemplate(model.launchTemplate);
            this.mixedInstancesPolicy(model.mixedInstancesPolicy);
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.desiredCapacity(model.desiredCapacity);
            this.predictedCapacity(model.predictedCapacity);
            this.defaultCooldown(model.defaultCooldown);
            this.availabilityZones(model.availabilityZones);
            this.loadBalancerNames(model.loadBalancerNames);
            this.targetGroupARNs(model.targetGroupARNs);
            this.healthCheckType(model.healthCheckType);
            this.healthCheckGracePeriod(model.healthCheckGracePeriod);
            this.instances(model.instances);
            this.createdTime(model.createdTime);
            this.suspendedProcesses(model.suspendedProcesses);
            this.placementGroup(model.placementGroup);
            this.vpcZoneIdentifier(model.vpcZoneIdentifier);
            this.enabledMetrics(model.enabledMetrics);
            this.status(model.status);
            this.tags(model.tags);
            this.terminationPolicies(model.terminationPolicies);
            this.newInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
            this.serviceLinkedRoleARN(model.serviceLinkedRoleARN);
            this.maxInstanceLifetime(model.maxInstanceLifetime);
            this.capacityRebalance(model.capacityRebalance);
            this.warmPoolConfiguration(model.warmPoolConfiguration);
            this.warmPoolSize(model.warmPoolSize);
            this.context(model.context);
            this.desiredCapacityType(model.desiredCapacityType);
            this.defaultInstanceWarmup(model.defaultInstanceWarmup);
            this.trafficSources(model.trafficSources);
            this.instanceMaintenancePolicy(model.instanceMaintenancePolicy);
            this.availabilityZoneDistribution(model.availabilityZoneDistribution);
            this.availabilityZoneImpairmentPolicy(model.availabilityZoneImpairmentPolicy);
            this.capacityReservationSpecification(model.capacityReservationSpecification);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getAutoScalingGroupARN() {
            return this.autoScalingGroupARN;
        }

        public final void setAutoScalingGroupARN(String autoScalingGroupARN) {
            this.autoScalingGroupARN = autoScalingGroupARN;
        }

        @Override
        public final Builder autoScalingGroupARN(String autoScalingGroupARN) {
            this.autoScalingGroupARN = autoScalingGroupARN;
            return this;
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final MixedInstancesPolicy.Builder getMixedInstancesPolicy() {
            return this.mixedInstancesPolicy != null ? this.mixedInstancesPolicy.toBuilder() : null;
        }

        public final void setMixedInstancesPolicy(MixedInstancesPolicy.BuilderImpl mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy != null ? mixedInstancesPolicy.build() : null;
        }

        @Override
        public final Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final Integer getPredictedCapacity() {
            return this.predictedCapacity;
        }

        public final void setPredictedCapacity(Integer predictedCapacity) {
            this.predictedCapacity = predictedCapacity;
        }

        @Override
        public final Builder predictedCapacity(Integer predictedCapacity) {
            this.predictedCapacity = predictedCapacity;
            return this;
        }

        public final Integer getDefaultCooldown() {
            return this.defaultCooldown;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getLoadBalancerNames() {
            if (this.loadBalancerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loadBalancerNames;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            this.loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final Collection<String> getTargetGroupARNs() {
            if (this.targetGroupARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetGroupARNs;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String ... targetGroupARNs) {
            this.targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final String getHealthCheckType() {
            return this.healthCheckType;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final Integer getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final List<Instance.Builder> getInstances() {
            List<Instance.Builder> result = InstancesCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (Instance)((Instance.Builder)Instance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final List<SuspendedProcess.Builder> getSuspendedProcesses() {
            List<SuspendedProcess.Builder> result = SuspendedProcessesCopier.copyToBuilder(this.suspendedProcesses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuspendedProcesses(Collection<SuspendedProcess.BuilderImpl> suspendedProcesses) {
            this.suspendedProcesses = SuspendedProcessesCopier.copyFromBuilder(suspendedProcesses);
        }

        @Override
        public final Builder suspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
            this.suspendedProcesses = SuspendedProcessesCopier.copy(suspendedProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suspendedProcesses(SuspendedProcess ... suspendedProcesses) {
            this.suspendedProcesses(Arrays.asList(suspendedProcesses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suspendedProcesses(Consumer<SuspendedProcess.Builder> ... suspendedProcesses) {
            this.suspendedProcesses(Stream.of(suspendedProcesses).map(c -> (SuspendedProcess)((SuspendedProcess.Builder)SuspendedProcess.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlacementGroup() {
            return this.placementGroup;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final String getVpcZoneIdentifier() {
            return this.vpcZoneIdentifier;
        }

        public final void setVpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final List<EnabledMetric.Builder> getEnabledMetrics() {
            List<EnabledMetric.Builder> result = EnabledMetricsCopier.copyToBuilder(this.enabledMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnabledMetrics(Collection<EnabledMetric.BuilderImpl> enabledMetrics) {
            this.enabledMetrics = EnabledMetricsCopier.copyFromBuilder(enabledMetrics);
        }

        @Override
        public final Builder enabledMetrics(Collection<EnabledMetric> enabledMetrics) {
            this.enabledMetrics = EnabledMetricsCopier.copy(enabledMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledMetrics(EnabledMetric ... enabledMetrics) {
            this.enabledMetrics(Arrays.asList(enabledMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledMetrics(Consumer<EnabledMetric.Builder> ... enabledMetrics) {
            this.enabledMetrics(Stream.of(enabledMetrics).map(c -> (EnabledMetric)((EnabledMetric.Builder)EnabledMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final List<TagDescription.Builder> getTags() {
            List<TagDescription.Builder> result = TagDescriptionListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagDescription.BuilderImpl> tags) {
            this.tags = TagDescriptionListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagDescription> tags) {
            this.tags = TagDescriptionListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagDescription ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagDescription.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagDescription)((TagDescription.Builder)TagDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTerminationPolicies() {
            if (this.terminationPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.terminationPolicies;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String ... terminationPolicies) {
            this.terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return this.newInstancesProtectedFromScaleIn;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final String getServiceLinkedRoleARN() {
            return this.serviceLinkedRoleARN;
        }

        public final void setServiceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
        }

        @Override
        public final Builder serviceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
            return this;
        }

        public final Integer getMaxInstanceLifetime() {
            return this.maxInstanceLifetime;
        }

        public final void setMaxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
        }

        @Override
        public final Builder maxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        public final Boolean getCapacityRebalance() {
            return this.capacityRebalance;
        }

        public final void setCapacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
        }

        @Override
        public final Builder capacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        public final WarmPoolConfiguration.Builder getWarmPoolConfiguration() {
            return this.warmPoolConfiguration != null ? this.warmPoolConfiguration.toBuilder() : null;
        }

        public final void setWarmPoolConfiguration(WarmPoolConfiguration.BuilderImpl warmPoolConfiguration) {
            this.warmPoolConfiguration = warmPoolConfiguration != null ? warmPoolConfiguration.build() : null;
        }

        @Override
        public final Builder warmPoolConfiguration(WarmPoolConfiguration warmPoolConfiguration) {
            this.warmPoolConfiguration = warmPoolConfiguration;
            return this;
        }

        public final Integer getWarmPoolSize() {
            return this.warmPoolSize;
        }

        public final void setWarmPoolSize(Integer warmPoolSize) {
            this.warmPoolSize = warmPoolSize;
        }

        @Override
        public final Builder warmPoolSize(Integer warmPoolSize) {
            this.warmPoolSize = warmPoolSize;
            return this;
        }

        public final String getContext() {
            return this.context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final String getDesiredCapacityType() {
            return this.desiredCapacityType;
        }

        public final void setDesiredCapacityType(String desiredCapacityType) {
            this.desiredCapacityType = desiredCapacityType;
        }

        @Override
        public final Builder desiredCapacityType(String desiredCapacityType) {
            this.desiredCapacityType = desiredCapacityType;
            return this;
        }

        public final Integer getDefaultInstanceWarmup() {
            return this.defaultInstanceWarmup;
        }

        public final void setDefaultInstanceWarmup(Integer defaultInstanceWarmup) {
            this.defaultInstanceWarmup = defaultInstanceWarmup;
        }

        @Override
        public final Builder defaultInstanceWarmup(Integer defaultInstanceWarmup) {
            this.defaultInstanceWarmup = defaultInstanceWarmup;
            return this;
        }

        public final List<TrafficSourceIdentifier.Builder> getTrafficSources() {
            List<TrafficSourceIdentifier.Builder> result = TrafficSourcesCopier.copyToBuilder(this.trafficSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficSources(Collection<TrafficSourceIdentifier.BuilderImpl> trafficSources) {
            this.trafficSources = TrafficSourcesCopier.copyFromBuilder(trafficSources);
        }

        @Override
        public final Builder trafficSources(Collection<TrafficSourceIdentifier> trafficSources) {
            this.trafficSources = TrafficSourcesCopier.copy(trafficSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(TrafficSourceIdentifier ... trafficSources) {
            this.trafficSources(Arrays.asList(trafficSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficSources(Consumer<TrafficSourceIdentifier.Builder> ... trafficSources) {
            this.trafficSources(Stream.of(trafficSources).map(c -> (TrafficSourceIdentifier)((TrafficSourceIdentifier.Builder)TrafficSourceIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceMaintenancePolicy.Builder getInstanceMaintenancePolicy() {
            return this.instanceMaintenancePolicy != null ? this.instanceMaintenancePolicy.toBuilder() : null;
        }

        public final void setInstanceMaintenancePolicy(InstanceMaintenancePolicy.BuilderImpl instanceMaintenancePolicy) {
            this.instanceMaintenancePolicy = instanceMaintenancePolicy != null ? instanceMaintenancePolicy.build() : null;
        }

        @Override
        public final Builder instanceMaintenancePolicy(InstanceMaintenancePolicy instanceMaintenancePolicy) {
            this.instanceMaintenancePolicy = instanceMaintenancePolicy;
            return this;
        }

        public final AvailabilityZoneDistribution.Builder getAvailabilityZoneDistribution() {
            return this.availabilityZoneDistribution != null ? this.availabilityZoneDistribution.toBuilder() : null;
        }

        public final void setAvailabilityZoneDistribution(AvailabilityZoneDistribution.BuilderImpl availabilityZoneDistribution) {
            this.availabilityZoneDistribution = availabilityZoneDistribution != null ? availabilityZoneDistribution.build() : null;
        }

        @Override
        public final Builder availabilityZoneDistribution(AvailabilityZoneDistribution availabilityZoneDistribution) {
            this.availabilityZoneDistribution = availabilityZoneDistribution;
            return this;
        }

        public final AvailabilityZoneImpairmentPolicy.Builder getAvailabilityZoneImpairmentPolicy() {
            return this.availabilityZoneImpairmentPolicy != null ? this.availabilityZoneImpairmentPolicy.toBuilder() : null;
        }

        public final void setAvailabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy.BuilderImpl availabilityZoneImpairmentPolicy) {
            this.availabilityZoneImpairmentPolicy = availabilityZoneImpairmentPolicy != null ? availabilityZoneImpairmentPolicy.build() : null;
        }

        @Override
        public final Builder availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy availabilityZoneImpairmentPolicy) {
            this.availabilityZoneImpairmentPolicy = availabilityZoneImpairmentPolicy;
            return this;
        }

        public final CapacityReservationSpecification.Builder getCapacityReservationSpecification() {
            return this.capacityReservationSpecification != null ? this.capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(CapacityReservationSpecification.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification.build() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public AutoScalingGroup build() {
            return new AutoScalingGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroup> {
        public Builder autoScalingGroupName(String var1);

        public Builder autoScalingGroupARN(String var1);

        public Builder launchConfigurationName(String var1);

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder mixedInstancesPolicy(MixedInstancesPolicy var1);

        default public Builder mixedInstancesPolicy(Consumer<MixedInstancesPolicy.Builder> mixedInstancesPolicy) {
            return this.mixedInstancesPolicy((MixedInstancesPolicy)((MixedInstancesPolicy.Builder)MixedInstancesPolicy.builder().applyMutation(mixedInstancesPolicy)).build());
        }

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder desiredCapacity(Integer var1);

        public Builder predictedCapacity(Integer var1);

        public Builder defaultCooldown(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder targetGroupARNs(Collection<String> var1);

        public Builder targetGroupARNs(String ... var1);

        public Builder healthCheckType(String var1);

        public Builder healthCheckGracePeriod(Integer var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder instances(Consumer<Instance.Builder> ... var1);

        public Builder createdTime(Instant var1);

        public Builder suspendedProcesses(Collection<SuspendedProcess> var1);

        public Builder suspendedProcesses(SuspendedProcess ... var1);

        public Builder suspendedProcesses(Consumer<SuspendedProcess.Builder> ... var1);

        public Builder placementGroup(String var1);

        public Builder vpcZoneIdentifier(String var1);

        public Builder enabledMetrics(Collection<EnabledMetric> var1);

        public Builder enabledMetrics(EnabledMetric ... var1);

        public Builder enabledMetrics(Consumer<EnabledMetric.Builder> ... var1);

        public Builder status(String var1);

        public Builder tags(Collection<TagDescription> var1);

        public Builder tags(TagDescription ... var1);

        public Builder tags(Consumer<TagDescription.Builder> ... var1);

        public Builder terminationPolicies(Collection<String> var1);

        public Builder terminationPolicies(String ... var1);

        public Builder newInstancesProtectedFromScaleIn(Boolean var1);

        public Builder serviceLinkedRoleARN(String var1);

        public Builder maxInstanceLifetime(Integer var1);

        public Builder capacityRebalance(Boolean var1);

        public Builder warmPoolConfiguration(WarmPoolConfiguration var1);

        default public Builder warmPoolConfiguration(Consumer<WarmPoolConfiguration.Builder> warmPoolConfiguration) {
            return this.warmPoolConfiguration((WarmPoolConfiguration)((WarmPoolConfiguration.Builder)WarmPoolConfiguration.builder().applyMutation(warmPoolConfiguration)).build());
        }

        public Builder warmPoolSize(Integer var1);

        public Builder context(String var1);

        public Builder desiredCapacityType(String var1);

        public Builder defaultInstanceWarmup(Integer var1);

        public Builder trafficSources(Collection<TrafficSourceIdentifier> var1);

        public Builder trafficSources(TrafficSourceIdentifier ... var1);

        public Builder trafficSources(Consumer<TrafficSourceIdentifier.Builder> ... var1);

        public Builder instanceMaintenancePolicy(InstanceMaintenancePolicy var1);

        default public Builder instanceMaintenancePolicy(Consumer<InstanceMaintenancePolicy.Builder> instanceMaintenancePolicy) {
            return this.instanceMaintenancePolicy((InstanceMaintenancePolicy)((InstanceMaintenancePolicy.Builder)InstanceMaintenancePolicy.builder().applyMutation(instanceMaintenancePolicy)).build());
        }

        public Builder availabilityZoneDistribution(AvailabilityZoneDistribution var1);

        default public Builder availabilityZoneDistribution(Consumer<AvailabilityZoneDistribution.Builder> availabilityZoneDistribution) {
            return this.availabilityZoneDistribution((AvailabilityZoneDistribution)((AvailabilityZoneDistribution.Builder)AvailabilityZoneDistribution.builder().applyMutation(availabilityZoneDistribution)).build());
        }

        public Builder availabilityZoneImpairmentPolicy(AvailabilityZoneImpairmentPolicy var1);

        default public Builder availabilityZoneImpairmentPolicy(Consumer<AvailabilityZoneImpairmentPolicy.Builder> availabilityZoneImpairmentPolicy) {
            return this.availabilityZoneImpairmentPolicy((AvailabilityZoneImpairmentPolicy)((AvailabilityZoneImpairmentPolicy.Builder)AvailabilityZoneImpairmentPolicy.builder().applyMutation(availabilityZoneImpairmentPolicy)).build());
        }

        public Builder capacityReservationSpecification(CapacityReservationSpecification var1);

        default public Builder capacityReservationSpecification(Consumer<CapacityReservationSpecification.Builder> capacityReservationSpecification) {
            return this.capacityReservationSpecification((CapacityReservationSpecification)((CapacityReservationSpecification.Builder)CapacityReservationSpecification.builder().applyMutation(capacityReservationSpecification)).build());
        }
    }
}

