/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroupNamesCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.Filter;
import software.amazon.awssdk.services.autoscaling.model.FiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAutoScalingGroupsRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeAutoScalingGroupsRequest> {
    private static final SdkField<List<String>> AUTO_SCALING_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoScalingGroupNames").getter(DescribeAutoScalingGroupsRequest.getter(DescribeAutoScalingGroupsRequest::autoScalingGroupNames)).setter(DescribeAutoScalingGroupsRequest.setter(Builder::autoScalingGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAutoScalingGroupsRequest.getter(DescribeAutoScalingGroupsRequest::nextToken)).setter(DescribeAutoScalingGroupsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeAutoScalingGroupsRequest.getter(DescribeAutoScalingGroupsRequest::maxRecords)).setter(DescribeAutoScalingGroupsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeAutoScalingGroupsRequest.getter(DescribeAutoScalingGroupsRequest::filters)).setter(DescribeAutoScalingGroupsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAMES_FIELD, NEXT_TOKEN_FIELD, MAX_RECORDS_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AutoScalingGroupNames", AUTO_SCALING_GROUP_NAMES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxRecords", MAX_RECORDS_FIELD);
            this.put("Filters", FILTERS_FIELD);
        }
    });
    private final List<String> autoScalingGroupNames;
    private final String nextToken;
    private final Integer maxRecords;
    private final List<Filter> filters;

    private DescribeAutoScalingGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupNames = builder.autoScalingGroupNames;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
        this.filters = builder.filters;
    }

    public final boolean hasAutoScalingGroupNames() {
        return this.autoScalingGroupNames != null && !(this.autoScalingGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> autoScalingGroupNames() {
        return this.autoScalingGroupNames;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingGroupNames() ? this.autoScalingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingGroupsRequest)) {
            return false;
        }
        DescribeAutoScalingGroupsRequest other = (DescribeAutoScalingGroupsRequest)((Object)obj);
        return this.hasAutoScalingGroupNames() == other.hasAutoScalingGroupNames() && Objects.equals(this.autoScalingGroupNames(), other.autoScalingGroupNames()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxRecords(), other.maxRecords()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAutoScalingGroupsRequest").add("AutoScalingGroupNames", this.hasAutoScalingGroupNames() ? this.autoScalingGroupNames() : null).add("NextToken", (Object)this.nextToken()).add("MaxRecords", (Object)this.maxRecords()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupNames": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoScalingGroupsRequest, T> g) {
        return obj -> g.apply((DescribeAutoScalingGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private List<String> autoScalingGroupNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxRecords;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingGroupsRequest model) {
            super(model);
            this.autoScalingGroupNames(model.autoScalingGroupNames);
            this.nextToken(model.nextToken);
            this.maxRecords(model.maxRecords);
            this.filters(model.filters);
        }

        public final Collection<String> getAutoScalingGroupNames() {
            if (this.autoScalingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoScalingGroupNames;
        }

        public final void setAutoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNamesCopier.copy(autoScalingGroupNames);
        }

        @Override
        public final Builder autoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNamesCopier.copy(autoScalingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupNames(String ... autoScalingGroupNames) {
            this.autoScalingGroupNames(Arrays.asList(autoScalingGroupNames));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAutoScalingGroupsRequest build() {
            return new DescribeAutoScalingGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAutoScalingGroupsRequest> {
        public Builder autoScalingGroupNames(Collection<String> var1);

        public Builder autoScalingGroupNames(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

