/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.PredictiveScalingConfiguration;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustment;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustmentsCopier;
import software.amazon.awssdk.services.autoscaling.model.TargetTrackingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutScalingPolicyRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, PutScalingPolicyRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::autoScalingGroupName)).setter(PutScalingPolicyRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::policyName)).setter(PutScalingPolicyRequest.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::policyType)).setter(PutScalingPolicyRequest.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<String> ADJUSTMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdjustmentType").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::adjustmentType)).setter(PutScalingPolicyRequest.setter(Builder::adjustmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjustmentType").build()}).build();
    private static final SdkField<Integer> MIN_ADJUSTMENT_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinAdjustmentStep").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::minAdjustmentStep)).setter(PutScalingPolicyRequest.setter(Builder::minAdjustmentStep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinAdjustmentStep").build()}).build();
    private static final SdkField<Integer> MIN_ADJUSTMENT_MAGNITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinAdjustmentMagnitude").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::minAdjustmentMagnitude)).setter(PutScalingPolicyRequest.setter(Builder::minAdjustmentMagnitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinAdjustmentMagnitude").build()}).build();
    private static final SdkField<Integer> SCALING_ADJUSTMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScalingAdjustment").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::scalingAdjustment)).setter(PutScalingPolicyRequest.setter(Builder::scalingAdjustment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustment").build()}).build();
    private static final SdkField<Integer> COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Cooldown").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::cooldown)).setter(PutScalingPolicyRequest.setter(Builder::cooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cooldown").build()}).build();
    private static final SdkField<String> METRIC_AGGREGATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricAggregationType").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::metricAggregationType)).setter(PutScalingPolicyRequest.setter(Builder::metricAggregationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricAggregationType").build()}).build();
    private static final SdkField<List<StepAdjustment>> STEP_ADJUSTMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StepAdjustments").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::stepAdjustments)).setter(PutScalingPolicyRequest.setter(Builder::stepAdjustments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepAdjustments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepAdjustment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> ESTIMATED_INSTANCE_WARMUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EstimatedInstanceWarmup").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::estimatedInstanceWarmup)).setter(PutScalingPolicyRequest.setter(Builder::estimatedInstanceWarmup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedInstanceWarmup").build()}).build();
    private static final SdkField<TargetTrackingConfiguration> TARGET_TRACKING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetTrackingConfiguration").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::targetTrackingConfiguration)).setter(PutScalingPolicyRequest.setter(Builder::targetTrackingConfiguration)).constructor(TargetTrackingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingConfiguration").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::enabled)).setter(PutScalingPolicyRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<PredictiveScalingConfiguration> PREDICTIVE_SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredictiveScalingConfiguration").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::predictiveScalingConfiguration)).setter(PutScalingPolicyRequest.setter(Builder::predictiveScalingConfiguration)).constructor(PredictiveScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictiveScalingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, POLICY_NAME_FIELD, POLICY_TYPE_FIELD, ADJUSTMENT_TYPE_FIELD, MIN_ADJUSTMENT_STEP_FIELD, MIN_ADJUSTMENT_MAGNITUDE_FIELD, SCALING_ADJUSTMENT_FIELD, COOLDOWN_FIELD, METRIC_AGGREGATION_TYPE_FIELD, STEP_ADJUSTMENTS_FIELD, ESTIMATED_INSTANCE_WARMUP_FIELD, TARGET_TRACKING_CONFIGURATION_FIELD, ENABLED_FIELD, PREDICTIVE_SCALING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
            this.put("PolicyName", POLICY_NAME_FIELD);
            this.put("PolicyType", POLICY_TYPE_FIELD);
            this.put("AdjustmentType", ADJUSTMENT_TYPE_FIELD);
            this.put("MinAdjustmentStep", MIN_ADJUSTMENT_STEP_FIELD);
            this.put("MinAdjustmentMagnitude", MIN_ADJUSTMENT_MAGNITUDE_FIELD);
            this.put("ScalingAdjustment", SCALING_ADJUSTMENT_FIELD);
            this.put("Cooldown", COOLDOWN_FIELD);
            this.put("MetricAggregationType", METRIC_AGGREGATION_TYPE_FIELD);
            this.put("StepAdjustments", STEP_ADJUSTMENTS_FIELD);
            this.put("EstimatedInstanceWarmup", ESTIMATED_INSTANCE_WARMUP_FIELD);
            this.put("TargetTrackingConfiguration", TARGET_TRACKING_CONFIGURATION_FIELD);
            this.put("Enabled", ENABLED_FIELD);
            this.put("PredictiveScalingConfiguration", PREDICTIVE_SCALING_CONFIGURATION_FIELD);
        }
    });
    private final String autoScalingGroupName;
    private final String policyName;
    private final String policyType;
    private final String adjustmentType;
    private final Integer minAdjustmentStep;
    private final Integer minAdjustmentMagnitude;
    private final Integer scalingAdjustment;
    private final Integer cooldown;
    private final String metricAggregationType;
    private final List<StepAdjustment> stepAdjustments;
    private final Integer estimatedInstanceWarmup;
    private final TargetTrackingConfiguration targetTrackingConfiguration;
    private final Boolean enabled;
    private final PredictiveScalingConfiguration predictiveScalingConfiguration;

    private PutScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.policyType = builder.policyType;
        this.adjustmentType = builder.adjustmentType;
        this.minAdjustmentStep = builder.minAdjustmentStep;
        this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.cooldown = builder.cooldown;
        this.metricAggregationType = builder.metricAggregationType;
        this.stepAdjustments = builder.stepAdjustments;
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
        this.targetTrackingConfiguration = builder.targetTrackingConfiguration;
        this.enabled = builder.enabled;
        this.predictiveScalingConfiguration = builder.predictiveScalingConfiguration;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String policyType() {
        return this.policyType;
    }

    public final String adjustmentType() {
        return this.adjustmentType;
    }

    public final Integer minAdjustmentStep() {
        return this.minAdjustmentStep;
    }

    public final Integer minAdjustmentMagnitude() {
        return this.minAdjustmentMagnitude;
    }

    public final Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public final Integer cooldown() {
        return this.cooldown;
    }

    public final String metricAggregationType() {
        return this.metricAggregationType;
    }

    public final boolean hasStepAdjustments() {
        return this.stepAdjustments != null && !(this.stepAdjustments instanceof SdkAutoConstructList);
    }

    public final List<StepAdjustment> stepAdjustments() {
        return this.stepAdjustments;
    }

    public final Integer estimatedInstanceWarmup() {
        return this.estimatedInstanceWarmup;
    }

    public final TargetTrackingConfiguration targetTrackingConfiguration() {
        return this.targetTrackingConfiguration;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final PredictiveScalingConfiguration predictiveScalingConfiguration() {
        return this.predictiveScalingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyType());
        hashCode = 31 * hashCode + Objects.hashCode(this.adjustmentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.minAdjustmentStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.minAdjustmentMagnitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingAdjustment());
        hashCode = 31 * hashCode + Objects.hashCode(this.cooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAggregationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepAdjustments() ? this.stepAdjustments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedInstanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTrackingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictiveScalingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyRequest)) {
            return false;
        }
        PutScalingPolicyRequest other = (PutScalingPolicyRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyType(), other.policyType()) && Objects.equals(this.adjustmentType(), other.adjustmentType()) && Objects.equals(this.minAdjustmentStep(), other.minAdjustmentStep()) && Objects.equals(this.minAdjustmentMagnitude(), other.minAdjustmentMagnitude()) && Objects.equals(this.scalingAdjustment(), other.scalingAdjustment()) && Objects.equals(this.cooldown(), other.cooldown()) && Objects.equals(this.metricAggregationType(), other.metricAggregationType()) && this.hasStepAdjustments() == other.hasStepAdjustments() && Objects.equals(this.stepAdjustments(), other.stepAdjustments()) && Objects.equals(this.estimatedInstanceWarmup(), other.estimatedInstanceWarmup()) && Objects.equals(this.targetTrackingConfiguration(), other.targetTrackingConfiguration()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.predictiveScalingConfiguration(), other.predictiveScalingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PutScalingPolicyRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("PolicyName", (Object)this.policyName()).add("PolicyType", (Object)this.policyType()).add("AdjustmentType", (Object)this.adjustmentType()).add("MinAdjustmentStep", (Object)this.minAdjustmentStep()).add("MinAdjustmentMagnitude", (Object)this.minAdjustmentMagnitude()).add("ScalingAdjustment", (Object)this.scalingAdjustment()).add("Cooldown", (Object)this.cooldown()).add("MetricAggregationType", (Object)this.metricAggregationType()).add("StepAdjustments", this.hasStepAdjustments() ? this.stepAdjustments() : null).add("EstimatedInstanceWarmup", (Object)this.estimatedInstanceWarmup()).add("TargetTrackingConfiguration", (Object)this.targetTrackingConfiguration()).add("Enabled", (Object)this.enabled()).add("PredictiveScalingConfiguration", (Object)this.predictiveScalingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyType()));
            }
            case "AdjustmentType": {
                return Optional.ofNullable(clazz.cast(this.adjustmentType()));
            }
            case "MinAdjustmentStep": {
                return Optional.ofNullable(clazz.cast(this.minAdjustmentStep()));
            }
            case "MinAdjustmentMagnitude": {
                return Optional.ofNullable(clazz.cast(this.minAdjustmentMagnitude()));
            }
            case "ScalingAdjustment": {
                return Optional.ofNullable(clazz.cast(this.scalingAdjustment()));
            }
            case "Cooldown": {
                return Optional.ofNullable(clazz.cast(this.cooldown()));
            }
            case "MetricAggregationType": {
                return Optional.ofNullable(clazz.cast(this.metricAggregationType()));
            }
            case "StepAdjustments": {
                return Optional.ofNullable(clazz.cast(this.stepAdjustments()));
            }
            case "EstimatedInstanceWarmup": {
                return Optional.ofNullable(clazz.cast(this.estimatedInstanceWarmup()));
            }
            case "TargetTrackingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingConfiguration()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "PredictiveScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.predictiveScalingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutScalingPolicyRequest, T> g) {
        return obj -> g.apply((PutScalingPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String policyName;
        private String policyType;
        private String adjustmentType;
        private Integer minAdjustmentStep;
        private Integer minAdjustmentMagnitude;
        private Integer scalingAdjustment;
        private Integer cooldown;
        private String metricAggregationType;
        private List<StepAdjustment> stepAdjustments = DefaultSdkAutoConstructList.getInstance();
        private Integer estimatedInstanceWarmup;
        private TargetTrackingConfiguration targetTrackingConfiguration;
        private Boolean enabled;
        private PredictiveScalingConfiguration predictiveScalingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.policyName(model.policyName);
            this.policyType(model.policyType);
            this.adjustmentType(model.adjustmentType);
            this.minAdjustmentStep(model.minAdjustmentStep);
            this.minAdjustmentMagnitude(model.minAdjustmentMagnitude);
            this.scalingAdjustment(model.scalingAdjustment);
            this.cooldown(model.cooldown);
            this.metricAggregationType(model.metricAggregationType);
            this.stepAdjustments(model.stepAdjustments);
            this.estimatedInstanceWarmup(model.estimatedInstanceWarmup);
            this.targetTrackingConfiguration(model.targetTrackingConfiguration);
            this.enabled(model.enabled);
            this.predictiveScalingConfiguration(model.predictiveScalingConfiguration);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public final String getAdjustmentType() {
            return this.adjustmentType;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        public final Integer getMinAdjustmentStep() {
            return this.minAdjustmentStep;
        }

        public final void setMinAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
        }

        @Override
        public final Builder minAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
            return this;
        }

        public final Integer getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        public final void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        @Override
        public final Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final Integer getCooldown() {
            return this.cooldown;
        }

        public final void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }

        @Override
        public final Builder cooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public final String getMetricAggregationType() {
            return this.metricAggregationType;
        }

        public final void setMetricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
        }

        @Override
        public final Builder metricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        public final List<StepAdjustment.Builder> getStepAdjustments() {
            List<StepAdjustment.Builder> result = StepAdjustmentsCopier.copyToBuilder(this.stepAdjustments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStepAdjustments(Collection<StepAdjustment.BuilderImpl> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copyFromBuilder(stepAdjustments);
        }

        @Override
        public final Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(StepAdjustment ... stepAdjustments) {
            this.stepAdjustments(Arrays.asList(stepAdjustments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(Consumer<StepAdjustment.Builder> ... stepAdjustments) {
            this.stepAdjustments(Stream.of(stepAdjustments).map(c -> (StepAdjustment)((StepAdjustment.Builder)StepAdjustment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final TargetTrackingConfiguration.Builder getTargetTrackingConfiguration() {
            return this.targetTrackingConfiguration != null ? this.targetTrackingConfiguration.toBuilder() : null;
        }

        public final void setTargetTrackingConfiguration(TargetTrackingConfiguration.BuilderImpl targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration != null ? targetTrackingConfiguration.build() : null;
        }

        @Override
        public final Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final PredictiveScalingConfiguration.Builder getPredictiveScalingConfiguration() {
            return this.predictiveScalingConfiguration != null ? this.predictiveScalingConfiguration.toBuilder() : null;
        }

        public final void setPredictiveScalingConfiguration(PredictiveScalingConfiguration.BuilderImpl predictiveScalingConfiguration) {
            this.predictiveScalingConfiguration = predictiveScalingConfiguration != null ? predictiveScalingConfiguration.build() : null;
        }

        @Override
        public final Builder predictiveScalingConfiguration(PredictiveScalingConfiguration predictiveScalingConfiguration) {
            this.predictiveScalingConfiguration = predictiveScalingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutScalingPolicyRequest build() {
            return new PutScalingPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutScalingPolicyRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder policyName(String var1);

        public Builder policyType(String var1);

        public Builder adjustmentType(String var1);

        public Builder minAdjustmentStep(Integer var1);

        public Builder minAdjustmentMagnitude(Integer var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder cooldown(Integer var1);

        public Builder metricAggregationType(String var1);

        public Builder stepAdjustments(Collection<StepAdjustment> var1);

        public Builder stepAdjustments(StepAdjustment ... var1);

        public Builder stepAdjustments(Consumer<StepAdjustment.Builder> ... var1);

        public Builder estimatedInstanceWarmup(Integer var1);

        public Builder targetTrackingConfiguration(TargetTrackingConfiguration var1);

        default public Builder targetTrackingConfiguration(Consumer<TargetTrackingConfiguration.Builder> targetTrackingConfiguration) {
            return this.targetTrackingConfiguration((TargetTrackingConfiguration)((TargetTrackingConfiguration.Builder)TargetTrackingConfiguration.builder().applyMutation(targetTrackingConfiguration)).build());
        }

        public Builder enabled(Boolean var1);

        public Builder predictiveScalingConfiguration(PredictiveScalingConfiguration var1);

        default public Builder predictiveScalingConfiguration(Consumer<PredictiveScalingConfiguration.Builder> predictiveScalingConfiguration) {
            return this.predictiveScalingConfiguration((PredictiveScalingConfiguration)((PredictiveScalingConfiguration.Builder)PredictiveScalingConfiguration.builder().applyMutation(predictiveScalingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

