/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesResponse;

public class DescribeTrafficSourcesIterable
implements SdkIterable<DescribeTrafficSourcesResponse> {
    private final AutoScalingClient client;
    private final DescribeTrafficSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTrafficSourcesIterable(AutoScalingClient client, DescribeTrafficSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTrafficSourcesResponseFetcher();
    }

    public Iterator<DescribeTrafficSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeTrafficSourcesResponseFetcher
    implements SyncPageFetcher<DescribeTrafficSourcesResponse> {
        private DescribeTrafficSourcesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrafficSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTrafficSourcesResponse nextPage(DescribeTrafficSourcesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrafficSourcesIterable.this.client.describeTrafficSources(DescribeTrafficSourcesIterable.this.firstRequest);
            }
            return DescribeTrafficSourcesIterable.this.client.describeTrafficSources((DescribeTrafficSourcesRequest)((Object)DescribeTrafficSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

