/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.awssdk.services.autoscaling.AutoScalingBaseClientBuilder;
import software.amazon.awssdk.services.autoscaling.endpoints.AutoScalingEndpointProvider;
import software.amazon.awssdk.services.autoscaling.endpoints.internal.AutoScalingEndpointAuthSchemeInterceptor;
import software.amazon.awssdk.services.autoscaling.endpoints.internal.AutoScalingRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.autoscaling.endpoints.internal.AutoScalingResolveEndpointInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultAutoScalingBaseClientBuilder<B extends AutoScalingBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultAutoScalingBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "autoscaling";
    }

    protected final String serviceName() {
        return "AutoScaling";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new AutoScalingResolveEndpointInterceptor());
        endpointInterceptors.add(new AutoScalingEndpointAuthSchemeInterceptor());
        endpointInterceptors.add(new AutoScalingRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/autoscaling/execution.interceptors");
        ArrayList<QueryParametersToBodyInterceptor> additionalInterceptors = new ArrayList<QueryParametersToBodyInterceptor>();
        additionalInterceptors.add(new QueryParametersToBodyInterceptor());
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        return config.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    protected final String signingName() {
        return "autoscaling";
    }

    private AutoScalingEndpointProvider defaultEndpointProvider() {
        return AutoScalingEndpointProvider.defaultProvider();
    }
}

