/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.ProcessType;
import software.amazon.awssdk.services.autoscaling.model.ProcessesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingProcessTypesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeScalingProcessTypesResponse> {
    private static final SdkField<List<ProcessType>> PROCESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Processes").getter(DescribeScalingProcessTypesResponse.getter(DescribeScalingProcessTypesResponse::processes)).setter(DescribeScalingProcessTypesResponse.setter(Builder::processes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSES_FIELD));
    private final List<ProcessType> processes;

    private DescribeScalingProcessTypesResponse(BuilderImpl builder) {
        super(builder);
        this.processes = builder.processes;
    }

    public final boolean hasProcesses() {
        return this.processes != null && !(this.processes instanceof SdkAutoConstructList);
    }

    public final List<ProcessType> processes() {
        return this.processes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcesses() ? this.processes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingProcessTypesResponse)) {
            return false;
        }
        DescribeScalingProcessTypesResponse other = (DescribeScalingProcessTypesResponse)((Object)obj);
        return this.hasProcesses() == other.hasProcesses() && Objects.equals(this.processes(), other.processes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScalingProcessTypesResponse").add("Processes", this.hasProcesses() ? this.processes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Processes": {
                return Optional.ofNullable(clazz.cast(this.processes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingProcessTypesResponse, T> g) {
        return obj -> g.apply((DescribeScalingProcessTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<ProcessType> processes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingProcessTypesResponse model) {
            super(model);
            this.processes(model.processes);
        }

        public final List<ProcessType.Builder> getProcesses() {
            List<ProcessType.Builder> result = ProcessesCopier.copyToBuilder(this.processes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcesses(Collection<ProcessType.BuilderImpl> processes) {
            this.processes = ProcessesCopier.copyFromBuilder(processes);
        }

        @Override
        public final Builder processes(Collection<ProcessType> processes) {
            this.processes = ProcessesCopier.copy(processes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processes(ProcessType ... processes) {
            this.processes(Arrays.asList(processes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processes(Consumer<ProcessType.Builder> ... processes) {
            this.processes(Stream.of(processes).map(c -> (ProcessType)((ProcessType.Builder)ProcessType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeScalingProcessTypesResponse build() {
            return new DescribeScalingProcessTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingProcessTypesResponse> {
        public Builder processes(Collection<ProcessType> var1);

        public Builder processes(ProcessType ... var1);

        public Builder processes(Consumer<ProcessType.Builder> ... var1);
    }
}

