/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.CheckpointPercentagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshPreferences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RefreshPreferences> {
    private static final SdkField<Integer> MIN_HEALTHY_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinHealthyPercentage").getter(RefreshPreferences.getter(RefreshPreferences::minHealthyPercentage)).setter(RefreshPreferences.setter(Builder::minHealthyPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinHealthyPercentage").build()}).build();
    private static final SdkField<Integer> INSTANCE_WARMUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceWarmup").getter(RefreshPreferences.getter(RefreshPreferences::instanceWarmup)).setter(RefreshPreferences.setter(Builder::instanceWarmup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceWarmup").build()}).build();
    private static final SdkField<List<Integer>> CHECKPOINT_PERCENTAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CheckpointPercentages").getter(RefreshPreferences.getter(RefreshPreferences::checkpointPercentages)).setter(RefreshPreferences.setter(Builder::checkpointPercentages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointPercentages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CHECKPOINT_DELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CheckpointDelay").getter(RefreshPreferences.getter(RefreshPreferences::checkpointDelay)).setter(RefreshPreferences.setter(Builder::checkpointDelay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointDelay").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_HEALTHY_PERCENTAGE_FIELD, INSTANCE_WARMUP_FIELD, CHECKPOINT_PERCENTAGES_FIELD, CHECKPOINT_DELAY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer minHealthyPercentage;
    private final Integer instanceWarmup;
    private final List<Integer> checkpointPercentages;
    private final Integer checkpointDelay;

    private RefreshPreferences(BuilderImpl builder) {
        this.minHealthyPercentage = builder.minHealthyPercentage;
        this.instanceWarmup = builder.instanceWarmup;
        this.checkpointPercentages = builder.checkpointPercentages;
        this.checkpointDelay = builder.checkpointDelay;
    }

    public final Integer minHealthyPercentage() {
        return this.minHealthyPercentage;
    }

    public final Integer instanceWarmup() {
        return this.instanceWarmup;
    }

    public final boolean hasCheckpointPercentages() {
        return this.checkpointPercentages != null && !(this.checkpointPercentages instanceof SdkAutoConstructList);
    }

    public final List<Integer> checkpointPercentages() {
        return this.checkpointPercentages;
    }

    public final Integer checkpointDelay() {
        return this.checkpointDelay;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minHealthyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCheckpointPercentages() ? this.checkpointPercentages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointDelay());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshPreferences)) {
            return false;
        }
        RefreshPreferences other = (RefreshPreferences)obj;
        return Objects.equals(this.minHealthyPercentage(), other.minHealthyPercentage()) && Objects.equals(this.instanceWarmup(), other.instanceWarmup()) && this.hasCheckpointPercentages() == other.hasCheckpointPercentages() && Objects.equals(this.checkpointPercentages(), other.checkpointPercentages()) && Objects.equals(this.checkpointDelay(), other.checkpointDelay());
    }

    public final String toString() {
        return ToString.builder((String)"RefreshPreferences").add("MinHealthyPercentage", (Object)this.minHealthyPercentage()).add("InstanceWarmup", (Object)this.instanceWarmup()).add("CheckpointPercentages", this.hasCheckpointPercentages() ? this.checkpointPercentages() : null).add("CheckpointDelay", (Object)this.checkpointDelay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinHealthyPercentage": {
                return Optional.ofNullable(clazz.cast(this.minHealthyPercentage()));
            }
            case "InstanceWarmup": {
                return Optional.ofNullable(clazz.cast(this.instanceWarmup()));
            }
            case "CheckpointPercentages": {
                return Optional.ofNullable(clazz.cast(this.checkpointPercentages()));
            }
            case "CheckpointDelay": {
                return Optional.ofNullable(clazz.cast(this.checkpointDelay()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RefreshPreferences, T> g) {
        return obj -> g.apply((RefreshPreferences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minHealthyPercentage;
        private Integer instanceWarmup;
        private List<Integer> checkpointPercentages = DefaultSdkAutoConstructList.getInstance();
        private Integer checkpointDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshPreferences model) {
            this.minHealthyPercentage(model.minHealthyPercentage);
            this.instanceWarmup(model.instanceWarmup);
            this.checkpointPercentages(model.checkpointPercentages);
            this.checkpointDelay(model.checkpointDelay);
        }

        public final Integer getMinHealthyPercentage() {
            return this.minHealthyPercentage;
        }

        public final void setMinHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
        }

        @Override
        @Transient
        public final Builder minHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
            return this;
        }

        public final Integer getInstanceWarmup() {
            return this.instanceWarmup;
        }

        public final void setInstanceWarmup(Integer instanceWarmup) {
            this.instanceWarmup = instanceWarmup;
        }

        @Override
        @Transient
        public final Builder instanceWarmup(Integer instanceWarmup) {
            this.instanceWarmup = instanceWarmup;
            return this;
        }

        public final Collection<Integer> getCheckpointPercentages() {
            if (this.checkpointPercentages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.checkpointPercentages;
        }

        public final void setCheckpointPercentages(Collection<Integer> checkpointPercentages) {
            this.checkpointPercentages = CheckpointPercentagesCopier.copy(checkpointPercentages);
        }

        @Override
        @Transient
        public final Builder checkpointPercentages(Collection<Integer> checkpointPercentages) {
            this.checkpointPercentages = CheckpointPercentagesCopier.copy(checkpointPercentages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder checkpointPercentages(Integer ... checkpointPercentages) {
            this.checkpointPercentages(Arrays.asList(checkpointPercentages));
            return this;
        }

        public final Integer getCheckpointDelay() {
            return this.checkpointDelay;
        }

        public final void setCheckpointDelay(Integer checkpointDelay) {
            this.checkpointDelay = checkpointDelay;
        }

        @Override
        @Transient
        public final Builder checkpointDelay(Integer checkpointDelay) {
            this.checkpointDelay = checkpointDelay;
            return this;
        }

        public RefreshPreferences build() {
            return new RefreshPreferences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RefreshPreferences> {
        public Builder minHealthyPercentage(Integer var1);

        public Builder instanceWarmup(Integer var1);

        public Builder checkpointPercentages(Collection<Integer> var1);

        public Builder checkpointPercentages(Integer ... var1);

        public Builder checkpointDelay(Integer var1);
    }
}

