/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a target tracking scaling policy configuration to use with Amazon EC2 Auto Scaling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetTrackingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetTrackingConfiguration.Builder, TargetTrackingConfiguration> {
    private static final SdkField<PredefinedMetricSpecification> PREDEFINED_METRIC_SPECIFICATION_FIELD = SdkField
            .<PredefinedMetricSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("PredefinedMetricSpecification")
            .getter(getter(TargetTrackingConfiguration::predefinedMetricSpecification))
            .setter(setter(Builder::predefinedMetricSpecification))
            .constructor(PredefinedMetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricSpecification")
                    .build()).build();

    private static final SdkField<CustomizedMetricSpecification> CUSTOMIZED_METRIC_SPECIFICATION_FIELD = SdkField
            .<CustomizedMetricSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("CustomizedMetricSpecification")
            .getter(getter(TargetTrackingConfiguration::customizedMetricSpecification))
            .setter(setter(Builder::customizedMetricSpecification))
            .constructor(CustomizedMetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomizedMetricSpecification")
                    .build()).build();

    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TargetValue").getter(getter(TargetTrackingConfiguration::targetValue))
            .setter(setter(Builder::targetValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()).build();

    private static final SdkField<Boolean> DISABLE_SCALE_IN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableScaleIn").getter(getter(TargetTrackingConfiguration::disableScaleIn))
            .setter(setter(Builder::disableScaleIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableScaleIn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREDEFINED_METRIC_SPECIFICATION_FIELD, CUSTOMIZED_METRIC_SPECIFICATION_FIELD, TARGET_VALUE_FIELD,
            DISABLE_SCALE_IN_FIELD));

    private static final long serialVersionUID = 1L;

    private final PredefinedMetricSpecification predefinedMetricSpecification;

    private final CustomizedMetricSpecification customizedMetricSpecification;

    private final Double targetValue;

    private final Boolean disableScaleIn;

    private TargetTrackingConfiguration(BuilderImpl builder) {
        this.predefinedMetricSpecification = builder.predefinedMetricSpecification;
        this.customizedMetricSpecification = builder.customizedMetricSpecification;
        this.targetValue = builder.targetValue;
        this.disableScaleIn = builder.disableScaleIn;
    }

    /**
     * <p>
     * A predefined metric. You must specify either a predefined metric or a customized metric.
     * </p>
     * 
     * @return A predefined metric. You must specify either a predefined metric or a customized metric.
     */
    public final PredefinedMetricSpecification predefinedMetricSpecification() {
        return predefinedMetricSpecification;
    }

    /**
     * <p>
     * A customized metric. You must specify either a predefined metric or a customized metric.
     * </p>
     * 
     * @return A customized metric. You must specify either a predefined metric or a customized metric.
     */
    public final CustomizedMetricSpecification customizedMetricSpecification() {
        return customizedMetricSpecification;
    }

    /**
     * <p>
     * The target value for the metric.
     * </p>
     * 
     * @return The target value for the metric.
     */
    public final Double targetValue() {
        return targetValue;
    }

    /**
     * <p>
     * Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is disabled, the
     * target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the target
     * tracking scaling policy can remove instances from the Auto Scaling group. The default is <code>false</code>.
     * </p>
     * 
     * @return Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is
     *         disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group.
     *         Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The
     *         default is <code>false</code>.
     */
    public final Boolean disableScaleIn() {
        return disableScaleIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefinedMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(customizedMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        hashCode = 31 * hashCode + Objects.hashCode(disableScaleIn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingConfiguration)) {
            return false;
        }
        TargetTrackingConfiguration other = (TargetTrackingConfiguration) obj;
        return Objects.equals(predefinedMetricSpecification(), other.predefinedMetricSpecification())
                && Objects.equals(customizedMetricSpecification(), other.customizedMetricSpecification())
                && Objects.equals(targetValue(), other.targetValue()) && Objects.equals(disableScaleIn(), other.disableScaleIn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetTrackingConfiguration")
                .add("PredefinedMetricSpecification", predefinedMetricSpecification())
                .add("CustomizedMetricSpecification", customizedMetricSpecification()).add("TargetValue", targetValue())
                .add("DisableScaleIn", disableScaleIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredefinedMetricSpecification":
            return Optional.ofNullable(clazz.cast(predefinedMetricSpecification()));
        case "CustomizedMetricSpecification":
            return Optional.ofNullable(clazz.cast(customizedMetricSpecification()));
        case "TargetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        case "DisableScaleIn":
            return Optional.ofNullable(clazz.cast(disableScaleIn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingConfiguration, T> g) {
        return obj -> g.apply((TargetTrackingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetTrackingConfiguration> {
        /**
         * <p>
         * A predefined metric. You must specify either a predefined metric or a customized metric.
         * </p>
         * 
         * @param predefinedMetricSpecification
         *        A predefined metric. You must specify either a predefined metric or a customized metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefinedMetricSpecification(PredefinedMetricSpecification predefinedMetricSpecification);

        /**
         * <p>
         * A predefined metric. You must specify either a predefined metric or a customized metric.
         * </p>
         * This is a convenience that creates an instance of the {@link PredefinedMetricSpecification.Builder} avoiding
         * the need to create one manually via {@link PredefinedMetricSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link PredefinedMetricSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #predefinedMetricSpecification(PredefinedMetricSpecification)}
         * .
         * 
         * @param predefinedMetricSpecification
         *        a consumer that will call methods on {@link PredefinedMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefinedMetricSpecification(PredefinedMetricSpecification)
         */
        default Builder predefinedMetricSpecification(
                Consumer<PredefinedMetricSpecification.Builder> predefinedMetricSpecification) {
            return predefinedMetricSpecification(PredefinedMetricSpecification.builder()
                    .applyMutation(predefinedMetricSpecification).build());
        }

        /**
         * <p>
         * A customized metric. You must specify either a predefined metric or a customized metric.
         * </p>
         * 
         * @param customizedMetricSpecification
         *        A customized metric. You must specify either a predefined metric or a customized metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customizedMetricSpecification(CustomizedMetricSpecification customizedMetricSpecification);

        /**
         * <p>
         * A customized metric. You must specify either a predefined metric or a customized metric.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomizedMetricSpecification.Builder} avoiding
         * the need to create one manually via {@link CustomizedMetricSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomizedMetricSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #customizedMetricSpecification(CustomizedMetricSpecification)}
         * .
         * 
         * @param customizedMetricSpecification
         *        a consumer that will call methods on {@link CustomizedMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customizedMetricSpecification(CustomizedMetricSpecification)
         */
        default Builder customizedMetricSpecification(
                Consumer<CustomizedMetricSpecification.Builder> customizedMetricSpecification) {
            return customizedMetricSpecification(CustomizedMetricSpecification.builder()
                    .applyMutation(customizedMetricSpecification).build());
        }

        /**
         * <p>
         * The target value for the metric.
         * </p>
         * 
         * @param targetValue
         *        The target value for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);

        /**
         * <p>
         * Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is disabled,
         * the target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the
         * target tracking scaling policy can remove instances from the Auto Scaling group. The default is
         * <code>false</code>.
         * </p>
         * 
         * @param disableScaleIn
         *        Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is
         *        disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group.
         *        Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The
         *        default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableScaleIn(Boolean disableScaleIn);
    }

    static final class BuilderImpl implements Builder {
        private PredefinedMetricSpecification predefinedMetricSpecification;

        private CustomizedMetricSpecification customizedMetricSpecification;

        private Double targetValue;

        private Boolean disableScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingConfiguration model) {
            predefinedMetricSpecification(model.predefinedMetricSpecification);
            customizedMetricSpecification(model.customizedMetricSpecification);
            targetValue(model.targetValue);
            disableScaleIn(model.disableScaleIn);
        }

        public final PredefinedMetricSpecification.Builder getPredefinedMetricSpecification() {
            return predefinedMetricSpecification != null ? predefinedMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder predefinedMetricSpecification(PredefinedMetricSpecification predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification;
            return this;
        }

        public final void setPredefinedMetricSpecification(PredefinedMetricSpecification.BuilderImpl predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification != null ? predefinedMetricSpecification.build()
                    : null;
        }

        public final CustomizedMetricSpecification.Builder getCustomizedMetricSpecification() {
            return customizedMetricSpecification != null ? customizedMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder customizedMetricSpecification(CustomizedMetricSpecification customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification;
            return this;
        }

        public final void setCustomizedMetricSpecification(CustomizedMetricSpecification.BuilderImpl customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification != null ? customizedMetricSpecification.build()
                    : null;
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        public final Boolean getDisableScaleIn() {
            return disableScaleIn;
        }

        @Override
        public final Builder disableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        public final void setDisableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
        }

        @Override
        public TargetTrackingConfiguration build() {
            return new TargetTrackingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
