/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an override for a launch template. The maximum number of instance types that can be associated with an Auto
 * Scaling group is 40. The maximum number of distinct launch templates you can define for an Auto Scaling group is 20.
 * For more information about configuring overrides, see <a
 * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-override-options.html">Configuring overrides</a> in
 * the <i>Amazon EC2 Auto Scaling User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplateOverrides.Builder, LaunchTemplateOverrides> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(LaunchTemplateOverrides::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> WEIGHTED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WeightedCapacity").getter(getter(LaunchTemplateOverrides::weightedCapacity))
            .setter(setter(Builder::weightedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").build()).build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_SPECIFICATION_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplateSpecification")
            .getter(getter(LaunchTemplateOverrides::launchTemplateSpecification))
            .setter(setter(Builder::launchTemplateSpecification))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateSpecification")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            WEIGHTED_CAPACITY_FIELD, LAUNCH_TEMPLATE_SPECIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final String weightedCapacity;

    private final LaunchTemplateSpecification launchTemplateSpecification;

    private LaunchTemplateOverrides(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.weightedCapacity = builder.weightedCapacity;
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
    }

    /**
     * <p>
     * The instance type, such as <code>m3.xlarge</code>. You must use an instance type that is supported in your
     * requested Region and Availability Zones. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The instance type, such as <code>m3.xlarge</code>. You must use an instance type that is supported in
     *         your requested Region and Availability Zones. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of capacity units provided by the specified instance type in terms of virtual CPUs, memory, storage,
     * throughput, or other relative performance characteristic. When a Spot or On-Demand Instance is provisioned, the
     * capacity units count toward the desired capacity. Amazon EC2 Auto Scaling provisions instances until the desired
     * capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to
     * fulfill capacity, and Amazon EC2 Auto Scaling can only provision an instance with a <code>WeightedCapacity</code>
     * of 5 units, the instance is provisioned, and the desired capacity is exceeded by 3 units. For more information,
     * see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance
     * weighting for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. Value must be in the
     * range of 1 to 999.
     * </p>
     * 
     * @return The number of capacity units provided by the specified instance type in terms of virtual CPUs, memory,
     *         storage, throughput, or other relative performance characteristic. When a Spot or On-Demand Instance is
     *         provisioned, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling provisions
     *         instances until the desired capacity is totally fulfilled, even if this results in an overage. For
     *         example, if there are 2 units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only
     *         provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and
     *         the desired capacity is exceeded by 3 units. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance
     *         weighting for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. Value must be
     *         in the range of 1 to 999.
     */
    public final String weightedCapacity() {
        return weightedCapacity;
    }

    /**
     * <p>
     * Provides the launch template to be used when launching the instance type. For example, some instance types might
     * require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template
     * that's defined for your mixed instances policy. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-template-overrides.html">Specifying a
     * different launch template for an instance type</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Provides the launch template to be used when launching the instance type. For example, some instance
     *         types might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses
     *         the launch template that's defined for your mixed instances policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-template-overrides.html"
     *         >Specifying a different launch template for an instance type</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.
     */
    public final LaunchTemplateSpecification launchTemplateSpecification() {
        return launchTemplateSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateOverrides)) {
            return false;
        }
        LaunchTemplateOverrides other = (LaunchTemplateOverrides) obj;
        return Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(weightedCapacity(), other.weightedCapacity())
                && Objects.equals(launchTemplateSpecification(), other.launchTemplateSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplateOverrides").add("InstanceType", instanceType())
                .add("WeightedCapacity", weightedCapacity()).add("LaunchTemplateSpecification", launchTemplateSpecification())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "WeightedCapacity":
            return Optional.ofNullable(clazz.cast(weightedCapacity()));
        case "LaunchTemplateSpecification":
            return Optional.ofNullable(clazz.cast(launchTemplateSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateOverrides, T> g) {
        return obj -> g.apply((LaunchTemplateOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateOverrides> {
        /**
         * <p>
         * The instance type, such as <code>m3.xlarge</code>. You must use an instance type that is supported in your
         * requested Region and Availability Zones. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type, such as <code>m3.xlarge</code>. You must use an instance type that is supported in
         *        your requested Region and Availability Zones. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of capacity units provided by the specified instance type in terms of virtual CPUs, memory,
         * storage, throughput, or other relative performance characteristic. When a Spot or On-Demand Instance is
         * provisioned, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling provisions
         * instances until the desired capacity is totally fulfilled, even if this results in an overage. For example,
         * if there are 2 units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only provision an
         * instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the desired
         * capacity is exceeded by 3 units. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance weighting
         * for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. Value must be in the range
         * of 1 to 999.
         * </p>
         * 
         * @param weightedCapacity
         *        The number of capacity units provided by the specified instance type in terms of virtual CPUs, memory,
         *        storage, throughput, or other relative performance characteristic. When a Spot or On-Demand Instance
         *        is provisioned, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling
         *        provisions instances until the desired capacity is totally fulfilled, even if this results in an
         *        overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EC2 Auto Scaling
         *        can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is
         *        provisioned, and the desired capacity is exceeded by 3 units. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance
         *        weighting for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. Value must
         *        be in the range of 1 to 999.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedCapacity(String weightedCapacity);

        /**
         * <p>
         * Provides the launch template to be used when launching the instance type. For example, some instance types
         * might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the
         * launch template that's defined for your mixed instances policy. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-template-overrides.html">Specifying a
         * different launch template for an instance type</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param launchTemplateSpecification
         *        Provides the launch template to be used when launching the instance type. For example, some instance
         *        types might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling
         *        uses the launch template that's defined for your mixed instances policy. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-template-overrides.html">
         *        Specifying a different launch template for an instance type</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateSpecification(LaunchTemplateSpecification launchTemplateSpecification);

        /**
         * <p>
         * Provides the launch template to be used when launching the instance type. For example, some instance types
         * might require a launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the
         * launch template that's defined for your mixed instances policy. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-template-overrides.html">Specifying a
         * different launch template for an instance type</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateSpecification.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplateSpecification(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplateSpecification
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateSpecification(LaunchTemplateSpecification)
         */
        default Builder launchTemplateSpecification(Consumer<LaunchTemplateSpecification.Builder> launchTemplateSpecification) {
            return launchTemplateSpecification(LaunchTemplateSpecification.builder().applyMutation(launchTemplateSpecification)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private String weightedCapacity;

        private LaunchTemplateSpecification launchTemplateSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateOverrides model) {
            instanceType(model.instanceType);
            weightedCapacity(model.weightedCapacity);
            launchTemplateSpecification(model.launchTemplateSpecification);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getWeightedCapacity() {
            return weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(String weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final void setWeightedCapacity(String weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplateSpecification() {
            return launchTemplateSpecification != null ? launchTemplateSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateSpecification(LaunchTemplateSpecification launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final void setLaunchTemplateSpecification(LaunchTemplateSpecification.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        @Override
        public LaunchTemplateOverrides build() {
            return new LaunchTemplateOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
