/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAdjustmentTypesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeAdjustmentTypesResponse.Builder, DescribeAdjustmentTypesResponse> {
    private static final SdkField<List<AdjustmentType>> ADJUSTMENT_TYPES_FIELD = SdkField
            .<List<AdjustmentType>> builder(MarshallingType.LIST)
            .memberName("AdjustmentTypes")
            .getter(getter(DescribeAdjustmentTypesResponse::adjustmentTypes))
            .setter(setter(Builder::adjustmentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjustmentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdjustmentType> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdjustmentType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADJUSTMENT_TYPES_FIELD));

    private final List<AdjustmentType> adjustmentTypes;

    private DescribeAdjustmentTypesResponse(BuilderImpl builder) {
        super(builder);
        this.adjustmentTypes = builder.adjustmentTypes;
    }

    /**
     * Returns true if the AdjustmentTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAdjustmentTypes() {
        return adjustmentTypes != null && !(adjustmentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The policy adjustment types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdjustmentTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The policy adjustment types.
     */
    public final List<AdjustmentType> adjustmentTypes() {
        return adjustmentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdjustmentTypes() ? adjustmentTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAdjustmentTypesResponse)) {
            return false;
        }
        DescribeAdjustmentTypesResponse other = (DescribeAdjustmentTypesResponse) obj;
        return hasAdjustmentTypes() == other.hasAdjustmentTypes() && Objects.equals(adjustmentTypes(), other.adjustmentTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAdjustmentTypesResponse")
                .add("AdjustmentTypes", hasAdjustmentTypes() ? adjustmentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdjustmentTypes":
            return Optional.ofNullable(clazz.cast(adjustmentTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAdjustmentTypesResponse, T> g) {
        return obj -> g.apply((DescribeAdjustmentTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAdjustmentTypesResponse> {
        /**
         * <p>
         * The policy adjustment types.
         * </p>
         * 
         * @param adjustmentTypes
         *        The policy adjustment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentTypes(Collection<AdjustmentType> adjustmentTypes);

        /**
         * <p>
         * The policy adjustment types.
         * </p>
         * 
         * @param adjustmentTypes
         *        The policy adjustment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentTypes(AdjustmentType... adjustmentTypes);

        /**
         * <p>
         * The policy adjustment types.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AdjustmentType>.Builder} avoiding the need
         * to create one manually via {@link List<AdjustmentType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdjustmentType>.Builder#build()} is called immediately and
         * its result is passed to {@link #adjustmentTypes(List<AdjustmentType>)}.
         * 
         * @param adjustmentTypes
         *        a consumer that will call methods on {@link List<AdjustmentType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adjustmentTypes(List<AdjustmentType>)
         */
        Builder adjustmentTypes(Consumer<AdjustmentType.Builder>... adjustmentTypes);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<AdjustmentType> adjustmentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAdjustmentTypesResponse model) {
            super(model);
            adjustmentTypes(model.adjustmentTypes);
        }

        public final Collection<AdjustmentType.Builder> getAdjustmentTypes() {
            if (adjustmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return adjustmentTypes != null ? adjustmentTypes.stream().map(AdjustmentType::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder adjustmentTypes(Collection<AdjustmentType> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copy(adjustmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustmentTypes(AdjustmentType... adjustmentTypes) {
            adjustmentTypes(Arrays.asList(adjustmentTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustmentTypes(Consumer<AdjustmentType.Builder>... adjustmentTypes) {
            adjustmentTypes(Stream.of(adjustmentTypes).map(c -> AdjustmentType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAdjustmentTypes(Collection<AdjustmentType.BuilderImpl> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copyFromBuilder(adjustmentTypes);
        }

        @Override
        public DescribeAdjustmentTypesResponse build() {
            return new DescribeAdjustmentTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
