/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefreshStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceRefresh
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceRefresh> {
    private static final SdkField<String> INSTANCE_REFRESH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceRefreshId").getter(InstanceRefresh.getter(InstanceRefresh::instanceRefreshId)).setter(InstanceRefresh.setter(Builder::instanceRefreshId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRefreshId").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(InstanceRefresh.getter(InstanceRefresh::autoScalingGroupName)).setter(InstanceRefresh.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InstanceRefresh.getter(InstanceRefresh::statusAsString)).setter(InstanceRefresh.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(InstanceRefresh.getter(InstanceRefresh::statusReason)).setter(InstanceRefresh.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(InstanceRefresh.getter(InstanceRefresh::startTime)).setter(InstanceRefresh.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(InstanceRefresh.getter(InstanceRefresh::endTime)).setter(InstanceRefresh.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Integer> PERCENTAGE_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PercentageComplete").getter(InstanceRefresh.getter(InstanceRefresh::percentageComplete)).setter(InstanceRefresh.setter(Builder::percentageComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageComplete").build()}).build();
    private static final SdkField<Integer> INSTANCES_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesToUpdate").getter(InstanceRefresh.getter(InstanceRefresh::instancesToUpdate)).setter(InstanceRefresh.setter(Builder::instancesToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesToUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_REFRESH_ID_FIELD, AUTO_SCALING_GROUP_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERCENTAGE_COMPLETE_FIELD, INSTANCES_TO_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceRefreshId;
    private final String autoScalingGroupName;
    private final String status;
    private final String statusReason;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer percentageComplete;
    private final Integer instancesToUpdate;

    private InstanceRefresh(BuilderImpl builder) {
        this.instanceRefreshId = builder.instanceRefreshId;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.percentageComplete = builder.percentageComplete;
        this.instancesToUpdate = builder.instancesToUpdate;
    }

    public String instanceRefreshId() {
        return this.instanceRefreshId;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public InstanceRefreshStatus status() {
        return InstanceRefreshStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Integer percentageComplete() {
        return this.percentageComplete;
    }

    public Integer instancesToUpdate() {
        return this.instancesToUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRefreshId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesToUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRefresh)) {
            return false;
        }
        InstanceRefresh other = (InstanceRefresh)obj;
        return Objects.equals(this.instanceRefreshId(), other.instanceRefreshId()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.percentageComplete(), other.percentageComplete()) && Objects.equals(this.instancesToUpdate(), other.instancesToUpdate());
    }

    public String toString() {
        return ToString.builder((String)"InstanceRefresh").add("InstanceRefreshId", (Object)this.instanceRefreshId()).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("PercentageComplete", (Object)this.percentageComplete()).add("InstancesToUpdate", (Object)this.instancesToUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceRefreshId": {
                return Optional.ofNullable(clazz.cast(this.instanceRefreshId()));
            }
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "PercentageComplete": {
                return Optional.ofNullable(clazz.cast(this.percentageComplete()));
            }
            case "InstancesToUpdate": {
                return Optional.ofNullable(clazz.cast(this.instancesToUpdate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceRefresh, T> g) {
        return obj -> g.apply((InstanceRefresh)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceRefreshId;
        private String autoScalingGroupName;
        private String status;
        private String statusReason;
        private Instant startTime;
        private Instant endTime;
        private Integer percentageComplete;
        private Integer instancesToUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRefresh model) {
            this.instanceRefreshId(model.instanceRefreshId);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.percentageComplete(model.percentageComplete);
            this.instancesToUpdate(model.instancesToUpdate);
        }

        public final String getInstanceRefreshId() {
            return this.instanceRefreshId;
        }

        @Override
        public final Builder instanceRefreshId(String instanceRefreshId) {
            this.instanceRefreshId = instanceRefreshId;
            return this;
        }

        public final void setInstanceRefreshId(String instanceRefreshId) {
            this.instanceRefreshId = instanceRefreshId;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceRefreshStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Integer getPercentageComplete() {
            return this.percentageComplete;
        }

        @Override
        public final Builder percentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
            return this;
        }

        public final void setPercentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
        }

        public final Integer getInstancesToUpdate() {
            return this.instancesToUpdate;
        }

        @Override
        public final Builder instancesToUpdate(Integer instancesToUpdate) {
            this.instancesToUpdate = instancesToUpdate;
            return this;
        }

        public final void setInstancesToUpdate(Integer instancesToUpdate) {
            this.instancesToUpdate = instancesToUpdate;
        }

        public InstanceRefresh build() {
            return new InstanceRefresh(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceRefresh> {
        public Builder instanceRefreshId(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder status(String var1);

        public Builder status(InstanceRefreshStatus var1);

        public Builder statusReason(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder percentageComplete(Integer var1);

        public Builder instancesToUpdate(Integer var1);
    }
}

