/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.ProcessNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuspendProcessesRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, SuspendProcessesRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(SuspendProcessesRequest.getter(SuspendProcessesRequest::autoScalingGroupName)).setter(SuspendProcessesRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<List<String>> SCALING_PROCESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScalingProcesses").getter(SuspendProcessesRequest.getter(SuspendProcessesRequest::scalingProcesses)).setter(SuspendProcessesRequest.setter(Builder::scalingProcesses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingProcesses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, SCALING_PROCESSES_FIELD));
    private final String autoScalingGroupName;
    private final List<String> scalingProcesses;

    private SuspendProcessesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scalingProcesses = builder.scalingProcesses;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public boolean hasScalingProcesses() {
        return this.scalingProcesses != null && !(this.scalingProcesses instanceof SdkAutoConstructList);
    }

    public List<String> scalingProcesses() {
        return this.scalingProcesses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingProcesses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendProcessesRequest)) {
            return false;
        }
        SuspendProcessesRequest other = (SuspendProcessesRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.scalingProcesses(), other.scalingProcesses());
    }

    public String toString() {
        return ToString.builder((String)"SuspendProcessesRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("ScalingProcesses", this.scalingProcesses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "ScalingProcesses": {
                return Optional.ofNullable(clazz.cast(this.scalingProcesses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuspendProcessesRequest, T> g) {
        return obj -> g.apply((SuspendProcessesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> scalingProcesses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendProcessesRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.scalingProcesses(model.scalingProcesses);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getScalingProcesses() {
            return this.scalingProcesses;
        }

        @Override
        public final Builder scalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingProcesses(String ... scalingProcesses) {
            this.scalingProcesses(Arrays.asList(scalingProcesses));
            return this;
        }

        public final void setScalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SuspendProcessesRequest build() {
            return new SuspendProcessesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SuspendProcessesRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder scalingProcesses(Collection<String> var1);

        public Builder scalingProcesses(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

