/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.FailedScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.FailedScheduledUpdateGroupActionRequestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteScheduledActionResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, BatchDeleteScheduledActionResponse> {
    private static final SdkField<List<FailedScheduledUpdateGroupActionRequest>> FAILED_SCHEDULED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedScheduledActions").getter(BatchDeleteScheduledActionResponse.getter(BatchDeleteScheduledActionResponse::failedScheduledActions)).setter(BatchDeleteScheduledActionResponse.setter(Builder::failedScheduledActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedScheduledActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedScheduledUpdateGroupActionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_SCHEDULED_ACTIONS_FIELD));
    private final List<FailedScheduledUpdateGroupActionRequest> failedScheduledActions;

    private BatchDeleteScheduledActionResponse(BuilderImpl builder) {
        super(builder);
        this.failedScheduledActions = builder.failedScheduledActions;
    }

    public boolean hasFailedScheduledActions() {
        return this.failedScheduledActions != null && !(this.failedScheduledActions instanceof SdkAutoConstructList);
    }

    public List<FailedScheduledUpdateGroupActionRequest> failedScheduledActions() {
        return this.failedScheduledActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failedScheduledActions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteScheduledActionResponse)) {
            return false;
        }
        BatchDeleteScheduledActionResponse other = (BatchDeleteScheduledActionResponse)((Object)obj);
        return Objects.equals(this.failedScheduledActions(), other.failedScheduledActions());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteScheduledActionResponse").add("FailedScheduledActions", this.failedScheduledActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedScheduledActions": {
                return Optional.ofNullable(clazz.cast(this.failedScheduledActions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteScheduledActionResponse, T> g) {
        return obj -> g.apply((BatchDeleteScheduledActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<FailedScheduledUpdateGroupActionRequest> failedScheduledActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteScheduledActionResponse model) {
            super(model);
            this.failedScheduledActions(model.failedScheduledActions);
        }

        public final Collection<FailedScheduledUpdateGroupActionRequest.Builder> getFailedScheduledActions() {
            return this.failedScheduledActions != null ? (Collection)this.failedScheduledActions.stream().map(FailedScheduledUpdateGroupActionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedScheduledActions(Collection<FailedScheduledUpdateGroupActionRequest> failedScheduledActions) {
            this.failedScheduledActions = FailedScheduledUpdateGroupActionRequestsCopier.copy(failedScheduledActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedScheduledActions(FailedScheduledUpdateGroupActionRequest ... failedScheduledActions) {
            this.failedScheduledActions(Arrays.asList(failedScheduledActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedScheduledActions(Consumer<FailedScheduledUpdateGroupActionRequest.Builder> ... failedScheduledActions) {
            this.failedScheduledActions(Stream.of(failedScheduledActions).map(c -> (FailedScheduledUpdateGroupActionRequest)((FailedScheduledUpdateGroupActionRequest.Builder)FailedScheduledUpdateGroupActionRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedScheduledActions(Collection<FailedScheduledUpdateGroupActionRequest.BuilderImpl> failedScheduledActions) {
            this.failedScheduledActions = FailedScheduledUpdateGroupActionRequestsCopier.copyFromBuilder(failedScheduledActions);
        }

        @Override
        public BatchDeleteScheduledActionResponse build() {
            return new BatchDeleteScheduledActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteScheduledActionResponse> {
        public Builder failedScheduledActions(Collection<FailedScheduledUpdateGroupActionRequest> var1);

        public Builder failedScheduledActions(FailedScheduledUpdateGroupActionRequest ... var1);

        public Builder failedScheduledActions(Consumer<FailedScheduledUpdateGroupActionRequest.Builder> ... var1);
    }
}

